/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.automation.internal.module.handler;

import java.util.HashMap;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.openhab.core.automation.Trigger;
import org.openhab.core.automation.handler.BaseTriggerModuleHandler;
import org.openhab.core.automation.handler.TriggerHandlerCallback;
import org.openhab.core.events.Event;
import org.openhab.core.events.EventFilter;
import org.openhab.core.events.EventSubscriber;
import org.openhab.core.events.TopicPrefixEventFilter;
import org.openhab.core.items.ItemRegistry;
import org.openhab.core.items.events.ItemAddedEvent;
import org.openhab.core.items.events.ItemCommandEvent;
import org.openhab.core.items.events.ItemRemovedEvent;
import org.openhab.core.types.Command;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NonNullByDefault
public class ItemCommandTriggerHandler
extends BaseTriggerModuleHandler
implements EventSubscriber {
    public static final String MODULE_TYPE_ID = "core.ItemCommandTrigger";
    public static final String CFG_ITEMNAME = "itemName";
    public static final String CFG_COMMAND = "command";
    private final Logger logger = LoggerFactory.getLogger(ItemCommandTriggerHandler.class);
    private final String itemName;
    private final @Nullable String command;
    private final Set<String> types;
    private final BundleContext bundleContext;
    private final String ruleUID;
    private final EventFilter eventFilter;
    private final ServiceRegistration<?> eventSubscriberRegistration;

    public ItemCommandTriggerHandler(Trigger module, String ruleUID, BundleContext bundleContext, ItemRegistry itemRegistry) {
        super(module);
        this.itemName = (String)module.getConfiguration().get(CFG_ITEMNAME);
        this.eventFilter = new TopicPrefixEventFilter("openhab/items/" + this.itemName + "/");
        this.command = (String)module.getConfiguration().get(CFG_COMMAND);
        this.bundleContext = bundleContext;
        this.ruleUID = ruleUID;
        this.types = Set.of(ItemCommandEvent.TYPE, ItemAddedEvent.TYPE, ItemRemovedEvent.TYPE);
        this.eventSubscriberRegistration = this.bundleContext.registerService(EventSubscriber.class.getName(), (Object)this, null);
        if (itemRegistry.get((Object)this.itemName) == null) {
            this.logger.warn("Item '{}' needed for rule '{}' is missing. Trigger '{}' will not work.", new Object[]{this.itemName, ruleUID, module.getId()});
        }
    }

    public Set<String> getSubscribedEventTypes() {
        return this.types;
    }

    public @Nullable EventFilter getEventFilter() {
        return this.eventFilter;
    }

    public void receive(Event event) {
        Event event2 = event;
        if (event2 instanceof ItemAddedEvent && (var2_3 = (ItemAddedEvent)event2) == (ItemAddedEvent)var3_2) {
            if (this.itemName.equals(addedEvent.getItem().name)) {
                this.logger.info("Item '{}' needed for rule '{}' added. Trigger '{}' will now work.", new Object[]{this.itemName, this.ruleUID, ((Trigger)this.module).getId()});
                return;
            }
        } else {
            if (event instanceof ItemRemovedEvent var4_5 && this.itemName.equals(removedEvent.getItem().name)) {
                this.logger.warn("Item '{}' needed for rule '{}' removed. Trigger '{}' will no longer work.", new Object[]{this.itemName, this.ruleUID, ((Trigger)this.module).getId()});
                return;
            }
        }
        if ((callback = this.callback) != null) {
            this.logger.trace("Received Event: Source: {} Topic: {} Type: {}  Payload: {}", new Object[]{event.getSource(), event.getTopic(), event.getType(), event.getPayload()});
            HashMap<String, Object> values = new HashMap<String, Object>();
            if (event instanceof ItemCommandEvent var8_9) {
                String command = this.command;
                Command itemCommand = commandEvent.getItemCommand();
                if (command == null || command.equals(itemCommand.toFullString())) {
                    values.put(CFG_COMMAND, itemCommand);
                    values.put("event", event);
                    ((TriggerHandlerCallback)callback).triggered((Trigger)this.module, values);
                }
            }
        }
    }

    @Override
    public void dispose() {
        super.dispose();
        this.eventSubscriberRegistration.unregister();
    }
}

