/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.automation.internal.module.handler;

import java.util.HashMap;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.openhab.core.automation.Trigger;
import org.openhab.core.automation.handler.BaseTriggerModuleHandler;
import org.openhab.core.automation.handler.TriggerHandlerCallback;
import org.openhab.core.events.Event;
import org.openhab.core.events.EventSubscriber;
import org.openhab.core.items.Item;
import org.openhab.core.items.ItemRegistry;
import org.openhab.core.items.events.GroupItemStateChangedEvent;
import org.openhab.core.items.events.ItemAddedEvent;
import org.openhab.core.items.events.ItemRemovedEvent;
import org.openhab.core.items.events.ItemStateChangedEvent;
import org.openhab.core.items.events.ItemStateUpdatedEvent;
import org.openhab.core.types.State;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NonNullByDefault
public class GroupStateTriggerHandler
extends BaseTriggerModuleHandler
implements EventSubscriber {
    public static final String UPDATE_MODULE_TYPE_ID = "core.GroupStateUpdateTrigger";
    public static final String CHANGE_MODULE_TYPE_ID = "core.GroupStateChangeTrigger";
    public static final String CFG_GROUPNAME = "groupName";
    public static final String CFG_STATE = "state";
    public static final String CFG_PREVIOUS_STATE = "previousState";
    private final Logger logger = LoggerFactory.getLogger(GroupStateTriggerHandler.class);
    private final String groupName;
    private final @Nullable String state;
    private final String previousState;
    private final String ruleUID;
    private Set<String> types;
    private final BundleContext bundleContext;
    private ItemRegistry itemRegistry;
    private ServiceRegistration<?> eventSubscriberRegistration;

    public GroupStateTriggerHandler(Trigger module, String ruleUID, BundleContext bundleContext, ItemRegistry itemRegistry) {
        super(module);
        this.groupName = (String)module.getConfiguration().get(CFG_GROUPNAME);
        this.state = (String)module.getConfiguration().get(CFG_STATE);
        this.previousState = (String)module.getConfiguration().get(CFG_PREVIOUS_STATE);
        this.types = UPDATE_MODULE_TYPE_ID.equals(module.getTypeUID()) ? Set.of(ItemStateUpdatedEvent.TYPE, ItemAddedEvent.TYPE, ItemRemovedEvent.TYPE) : Set.of(ItemStateChangedEvent.TYPE, GroupItemStateChangedEvent.TYPE, ItemAddedEvent.TYPE, ItemRemovedEvent.TYPE);
        this.bundleContext = bundleContext;
        this.ruleUID = ruleUID;
        this.itemRegistry = itemRegistry;
        this.eventSubscriberRegistration = this.bundleContext.registerService(EventSubscriber.class.getName(), (Object)this, null);
        if (itemRegistry.get((Object)this.groupName) == null) {
            this.logger.warn("Group '{}' needed for rule '{}' is missing. Trigger '{}' will not work.", new Object[]{this.groupName, ruleUID, module.getId()});
        }
    }

    public Set<String> getSubscribedEventTypes() {
        return this.types;
    }

    public void receive(Event event) {
        Event event2 = event;
        if (event2 instanceof ItemAddedEvent && (var2_3 = (ItemAddedEvent)event2) == (ItemAddedEvent)var3_2) {
            if (this.groupName.equals(addedEvent.getItem().name)) {
                this.logger.info("Group '{}' needed for rule '{}' added. Trigger '{}' will now work.", new Object[]{this.groupName, this.ruleUID, ((Trigger)this.module).getId()});
                return;
            }
        } else {
            if (event instanceof ItemRemovedEvent var4_5 && this.groupName.equals(removedEvent.getItem().name)) {
                this.logger.warn("Group '{}' needed for rule '{}' removed. Trigger '{}' will no longer work.", new Object[]{this.groupName, this.ruleUID, ((Trigger)this.module).getId()});
                return;
            }
        }
        if (( instanceOfPatternExpressionValue = this.callback) instanceof TriggerHandlerCallback var6_7) {
            this.logger.trace("Received Event: Source: {} Topic: {} Type: {}  Payload: {}", new Object[]{event.getSource(), event.getTopic(), event.getType(), event.getPayload()});
            if (event instanceof ItemStateUpdatedEvent var8_9 && UPDATE_MODULE_TYPE_ID.equals(((Trigger)this.module).getTypeUID())) {
                String itemName = isEvent.getItemName();
                Item item = (Item)this.itemRegistry.get((Object)itemName);
                Item group = (Item)this.itemRegistry.get((Object)this.groupName);
                if (item != null && item.getGroupNames().contains(this.groupName)) {
                    State state = isEvent.getItemState();
                    if (this.state == null || state.toFullString().equals(this.state)) {
                        HashMap<String, Object> values = new HashMap<String, Object>();
                        if (group != null) {
                            values.put("triggeringGroup", group);
                        }
                        values.put("triggeringItem", item);
                        values.put(CFG_STATE, state);
                        values.put("event", event);
                        cb.triggered((Trigger)this.module, values);
                    }
                }
            } else {
                if (event instanceof ItemStateChangedEvent itemName && CHANGE_MODULE_TYPE_ID.equals(((Trigger)this.module).getTypeUID())) {
                    String itemName = iscEvent.getItemName();
                    Item item = (Item)this.itemRegistry.get((Object)itemName);
                    Item group = (Item)this.itemRegistry.get((Object)this.groupName);
                    if (item != null && item.getGroupNames().contains(this.groupName)) {
                        State state = iscEvent.getItemState();
                        State oldState = iscEvent.getOldItemState();
                        if (this.stateMatches(this.state, state) && this.stateMatches(this.previousState, oldState)) {
                            HashMap<String, Object> values = new HashMap<String, Object>();
                            if (group != null) {
                                values.put("triggeringGroup", group);
                            }
                            values.put("triggeringItem", item);
                            values.put("oldState", oldState);
                            values.put("newState", state);
                            values.put("event", event);
                            cb.triggered((Trigger)this.module, values);
                        }
                    }
                }
            }
        }
    }

    private boolean stateMatches(@Nullable String requiredState, State state) {
        if (requiredState == null) {
            return true;
        }
        String reqState = requiredState.trim();
        return reqState.isEmpty() || reqState.equals(state.toFullString());
    }

    @Override
    public void dispose() {
        super.dispose();
        this.eventSubscriberRegistration.unregister();
    }
}

