/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.automation.internal.module.handler;

import java.util.HashMap;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.openhab.core.automation.Trigger;
import org.openhab.core.automation.handler.BaseTriggerModuleHandler;
import org.openhab.core.automation.handler.TriggerHandlerCallback;
import org.openhab.core.events.Event;
import org.openhab.core.events.EventSubscriber;
import org.openhab.core.items.Item;
import org.openhab.core.items.ItemRegistry;
import org.openhab.core.items.events.ItemAddedEvent;
import org.openhab.core.items.events.ItemCommandEvent;
import org.openhab.core.items.events.ItemRemovedEvent;
import org.openhab.core.types.Command;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NonNullByDefault
public class GroupCommandTriggerHandler
extends BaseTriggerModuleHandler
implements EventSubscriber {
    private final Logger logger = LoggerFactory.getLogger(GroupCommandTriggerHandler.class);
    private final String groupName;
    private final @Nullable String command;
    private final Set<String> types;
    private final BundleContext bundleContext;
    private final ItemRegistry itemRegistry;
    public static final String MODULE_TYPE_ID = "core.GroupCommandTrigger";
    public static final String CFG_GROUPNAME = "groupName";
    public static final String CFG_COMMAND = "command";
    private final String ruleUID;
    private ServiceRegistration<?> eventSubscriberRegistration;

    public GroupCommandTriggerHandler(Trigger module, String ruleUID, BundleContext bundleContext, ItemRegistry itemRegistry) {
        super(module);
        this.groupName = (String)module.getConfiguration().get(CFG_GROUPNAME);
        this.command = (String)module.getConfiguration().get(CFG_COMMAND);
        this.types = Set.of(ItemCommandEvent.TYPE, ItemAddedEvent.TYPE, ItemRemovedEvent.TYPE);
        this.bundleContext = bundleContext;
        this.itemRegistry = itemRegistry;
        this.ruleUID = ruleUID;
        this.eventSubscriberRegistration = this.bundleContext.registerService(EventSubscriber.class.getName(), (Object)this, null);
        if (itemRegistry.get((Object)this.groupName) == null) {
            this.logger.warn("Group '{}' needed for rule '{}' is missing. Trigger '{}' will not work.", new Object[]{this.groupName, ruleUID, module.getId()});
        }
    }

    public Set<String> getSubscribedEventTypes() {
        return this.types;
    }

    public void receive(Event event) {
        Event event2 = event;
        if (event2 instanceof ItemAddedEvent && (var2_3 = (ItemAddedEvent)event2) == (ItemAddedEvent)var3_2) {
            if (this.groupName.equals(addedEvent.getItem().name)) {
                this.logger.info("Group '{}' needed for rule '{}' added. Trigger '{}' will now work.", new Object[]{this.groupName, this.ruleUID, ((Trigger)this.module).getId()});
                return;
            }
        } else {
            if (event instanceof ItemRemovedEvent var4_5 && this.groupName.equals(removedEvent.getItem().name)) {
                this.logger.warn("Group '{}' needed for rule '{}' removed. Trigger '{}' will no longer work.", new Object[]{this.groupName, this.ruleUID, ((Trigger)this.module).getId()});
                return;
            }
        }
        if (( instanceOfPatternExpressionValue = this.callback) instanceof TriggerHandlerCallback var6_7) {
            this.logger.trace("Received Event: Source: {} Topic: {} Type: {}  Payload: {}", new Object[]{event.getSource(), event.getTopic(), event.getType(), event.getPayload()});
            HashMap<String, Object> values = new HashMap<String, Object>();
            if (event instanceof ItemCommandEvent var9_10) {
                String itemName = icEvent.getItemName();
                Item item = (Item)this.itemRegistry.get((Object)itemName);
                Item group = (Item)this.itemRegistry.get((Object)this.groupName);
                if (item != null && item.getGroupNames().contains(this.groupName)) {
                    String command = this.command;
                    Command itemCommand = icEvent.getItemCommand();
                    if (command == null || command.equals(itemCommand.toFullString())) {
                        if (group != null) {
                            values.put("triggeringGroup", group);
                        }
                        values.put("triggeringItem", item);
                        values.put(CFG_COMMAND, itemCommand);
                        values.put("event", event);
                        cb.triggered((Trigger)this.module, values);
                    }
                }
            }
        }
    }

    @Override
    public void dispose() {
        super.dispose();
        this.eventSubscriberRegistration.unregister();
    }
}

