/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.automation.internal.module.handler;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.openhab.core.automation.Condition;
import org.openhab.core.automation.handler.BaseConditionModuleHandler;
import org.openhab.core.automation.internal.module.exception.UncomparableException;
import org.openhab.core.types.State;
import org.openhab.core.types.TypeParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NonNullByDefault
public class CompareConditionHandler
extends BaseConditionModuleHandler {
    public static final String MODULE_TYPE = "core.GenericCompareCondition";
    public static final String INPUT_LEFT_OBJECT = "input";
    public static final String INPUT_LEFT_FIELD = "inputproperty";
    public static final String RIGHT_OP = "right";
    public static final String OPERATOR = "operator";
    public final Logger logger = LoggerFactory.getLogger(CompareConditionHandler.class);

    public CompareConditionHandler(Condition module) {
        super(module);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean isSatisfied(Map<String, @Nullable Object> context) {
        void s;
        String string;
        void s2;
        String string2;
        void s3;
        String string3;
        Object object;
        Object operatorObj = ((Condition)this.module).getConfiguration().get(OPERATOR);
        String operator = operatorObj != null && (object = operatorObj) instanceof String && (string3 = (String)object) == (String)object ? s3 : null;
        Object rightObj = ((Condition)this.module).getConfiguration().get(RIGHT_OP);
        String rightOperandString = rightObj != null && ( instanceOfPatternExpressionValue = rightObj) instanceof String && (string2 = (String) instanceOfPatternExpressionValue) == (String) instanceOfPatternExpressionValue ? s2 : null;
        Object leftObjFieldNameObj = ((Condition)this.module).getConfiguration().get(INPUT_LEFT_FIELD);
        String leftObjectFieldName = leftObjFieldNameObj != null && ( instanceOfPatternExpressionValue = leftObjFieldNameObj) instanceof String && (string = (String) instanceOfPatternExpressionValue) == (String) instanceOfPatternExpressionValue ? s : null;
        if (rightOperandString == null) return false;
        if (operator == null) {
            return false;
        }
        Object leftObj = context.get(INPUT_LEFT_OBJECT);
        Object toCompare = this.getCompareValue(leftObj, leftObjectFieldName);
        Object rightValue = this.getRightOperandValue(rightOperandString, toCompare);
        if (rightValue == null) {
            if (leftObj != null) {
                this.logger.info("unsupported type for compare condition: {}", leftObj.getClass());
                return false;
            }
            this.logger.info("unsupported type for compare condition: null ({})", (Object)((Condition)this.module).getInputs().get(INPUT_LEFT_FIELD));
            return false;
        }
        try {
            switch (operator) {
                case "equals": 
                case "=": 
                case "==": 
                case "EQ": 
                case "eq": 
                case "EQUALS": {
                    if (toCompare != null) return toCompare.equals(rightValue);
                    if ("null".equals(rightOperandString)) return true;
                    if ("".equals(rightOperandString)) return true;
                    return false;
                }
                case ">": 
                case "GT": 
                case "gt": {
                    if (toCompare == null) {
                        return false;
                    }
                    if (this.compare(toCompare, rightValue) <= 0) return false;
                    return true;
                }
                case "=>": 
                case ">=": 
                case "GTE": 
                case "gte": {
                    if (toCompare == null) {
                        return false;
                    }
                    if (this.compare(toCompare, rightValue) < 0) return false;
                    return true;
                }
                case "<": 
                case "LT": 
                case "lt": {
                    if (toCompare == null) {
                        return false;
                    }
                    if (this.compare(toCompare, rightValue) >= 0) return false;
                    return true;
                }
                case "<=": 
                case "=<": 
                case "LTE": 
                case "lte": {
                    if (toCompare == null) {
                        return false;
                    }
                    if (this.compare(toCompare, rightValue) > 0) return false;
                    return true;
                }
                case "matches": {
                    void string22;
                    void string1;
                     instanceOfPatternExpressionValue = toCompare;
                    if (!( instanceOfPatternExpressionValue instanceof String)) return false;
                    String string4 = (String) instanceOfPatternExpressionValue;
                    if (string4 != (String) instanceOfPatternExpressionValue) return false;
                     instanceOfPatternExpressionValue = rightValue;
                    if (!( instanceOfPatternExpressionValue instanceof String)) return false;
                    String string5 = (String) instanceOfPatternExpressionValue;
                    if (string5 != (String) instanceOfPatternExpressionValue) return false;
                    return string1.matches((String)string22);
                }
            }
            return false;
        }
        catch (UncomparableException e) {
            return false;
        }
    }

    private int compare(Object a, Object b) throws UncomparableException {
        if (Comparable.class.isAssignableFrom(a.getClass()) && a.getClass().equals(b.getClass())) {
            try {
                return ((Comparable)a).compareTo(b);
            }
            catch (ClassCastException e) {
                throw new UncomparableException();
            }
        }
        throw new UncomparableException();
    }

    private @Nullable Object getRightOperandValue(String rightOperandString2, @Nullable Object toCompare) {
        if ("null".equals(rightOperandString2)) {
            return rightOperandString2;
        }
        if (toCompare instanceof State var3_4) {
            return TypeParser.parseState(List.of(state.getClass()), (String)rightOperandString2);
        }
        if (toCompare instanceof Integer) {
            return Integer.parseInt(rightOperandString2);
        }
        if (toCompare instanceof String) {
            return rightOperandString2;
        }
        if (toCompare instanceof Long) {
            return Long.parseLong(rightOperandString2);
        }
        if (toCompare instanceof Double) {
            return Double.parseDouble(rightOperandString2);
        }
        return null;
    }

    private @Nullable Object getCompareValue(@Nullable Object leftObj, @Nullable String leftObjFieldName) {
        if (leftObj == null || leftObjFieldName == null || leftObjFieldName.isEmpty() || leftObj instanceof String || leftObj instanceof Integer || leftObj instanceof Long || leftObj instanceof Double) {
            return leftObj;
        }
        try {
            Method m = leftObj.getClass().getMethod("get" + leftObjFieldName.substring(0, 1).toUpperCase() + leftObjFieldName.substring(1), new Class[0]);
            return m.invoke(leftObj, new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | StringIndexOutOfBoundsException | InvocationTargetException e) {
            return null;
        }
    }
}

