/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.automation.internal.module.handler;

import java.util.Map;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.openhab.core.automation.ModuleHandlerCallback;
import org.openhab.core.automation.Trigger;
import org.openhab.core.automation.handler.BaseTriggerModuleHandler;
import org.openhab.core.automation.handler.TriggerHandlerCallback;
import org.openhab.core.events.Event;
import org.openhab.core.events.EventFilter;
import org.openhab.core.events.EventSubscriber;
import org.openhab.core.thing.ChannelUID;
import org.openhab.core.thing.events.ChannelTriggeredEvent;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NonNullByDefault
public class ChannelEventTriggerHandler
extends BaseTriggerModuleHandler
implements EventSubscriber,
EventFilter {
    public static final String MODULE_TYPE_ID = "core.ChannelEventTrigger";
    public static final String CFG_CHANNEL_EVENT = "event";
    public static final String CFG_CHANNEL = "channelUID";
    public static final String TOPIC = "openhab/channels/*/triggered";
    private final Logger logger = LoggerFactory.getLogger(ChannelEventTriggerHandler.class);
    private final @Nullable String eventOnChannel;
    private final ChannelUID channelUID;
    private final Set<String> types;
    private final BundleContext bundleContext;
    private final ServiceRegistration<?> eventSubscriberRegistration;

    public ChannelEventTriggerHandler(Trigger module, BundleContext bundleContext) {
        super(module);
        this.eventOnChannel = (String)module.getConfiguration().get(CFG_CHANNEL_EVENT);
        this.channelUID = new ChannelUID((String)module.getConfiguration().get(CFG_CHANNEL));
        this.types = Set.of("ChannelTriggeredEvent");
        this.bundleContext = bundleContext;
        this.eventSubscriberRegistration = this.bundleContext.registerService(EventSubscriber.class.getName(), (Object)this, null);
    }

    public void receive(Event event) {
        ModuleHandlerCallback localCallback = this.callback;
        if (localCallback != null) {
            this.logger.trace("Received Event: Source: {} Topic: {} Type: {}  Payload: {}", new Object[]{event.getSource(), event.getTopic(), event.getType(), event.getPayload()});
            ((TriggerHandlerCallback)localCallback).triggered((Trigger)this.module, Map.of(CFG_CHANNEL_EVENT, event));
        }
    }

    public boolean apply(Event event) {
        boolean eventMatches = false;
        if (event instanceof ChannelTriggeredEvent var3_4 && this.channelUID.equals((Object)cte.getChannel())) {
            String eventOnChannel = this.eventOnChannel;
            this.logger.trace("->FILTER: {}:{}", (Object)cte.getEvent(), (Object)eventOnChannel);
            eventMatches = eventOnChannel == null || eventOnChannel.isBlank() || eventOnChannel.equals(cte.getEvent());
        }
        return eventMatches;
    }

    public @Nullable EventFilter getEventFilter() {
        return this;
    }

    public Set<String> getSubscribedEventTypes() {
        return this.types;
    }

    @Override
    public void dispose() {
        super.dispose();
        this.eventSubscriberRegistration.unregister();
    }
}

