/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.automation.internal.composite;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.openhab.core.automation.Module;
import org.openhab.core.automation.ModuleHandlerCallback;
import org.openhab.core.automation.handler.ModuleHandler;
import org.openhab.core.automation.type.ModuleType;
import org.openhab.core.automation.util.ReferenceResolver;

@NonNullByDefault
public abstract class AbstractCompositeModuleHandler<M extends Module, MT extends ModuleType, H extends ModuleHandler>
implements ModuleHandler {
    protected LinkedHashMap<M, @Nullable H> moduleHandlerMap;
    protected M module;
    protected MT moduleType;

    public AbstractCompositeModuleHandler(M module, MT moduleType, LinkedHashMap<M, @Nullable H> mapModuleToHandler) {
        this.module = module;
        this.moduleType = moduleType;
        this.moduleHandlerMap = mapModuleToHandler;
    }

    protected Map<String, Object> getCompositeContext(Map<String, ?> context) {
        HashMap<String, Object> result = new HashMap<String, Object>(context);
        result.putAll(this.module.getConfiguration().getProperties());
        return result;
    }

    protected Map<String, Object> getChildContext(Module child, Map<String, ?> compositeContext) {
        return ReferenceResolver.getCompositeChildContext(child, compositeContext);
    }

    @Override
    public void dispose() {
        List<M> children = this.getChildren();
        for (Module child : children) {
            ModuleHandler childHandler = (ModuleHandler)this.moduleHandlerMap.remove(child);
            if (childHandler == null) continue;
            childHandler.dispose();
        }
        this.moduleHandlerMap.clear();
    }

    @Override
    public void setCallback(ModuleHandlerCallback callback) {
        List<M> children = this.getChildren();
        for (Module child : children) {
            @Nullable ModuleHandler handler = (ModuleHandler)this.moduleHandlerMap.get(child);
            if (handler == null) continue;
            handler.setCallback(callback);
        }
    }

    protected abstract List<M> getChildren();
}

