/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.automation.internal.commands;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.eclipse.jdt.annotation.NonNullByDefault;

@NonNullByDefault
public class Utils {
    static final String ROW_END = "\n";
    static final char FILLER = ' ';
    static final char TABLE_DELIMITER = '-';

    static Map<String, String> putInHastable(String[] strings) {
        Hashtable<String, String> sorted = new Hashtable<String, String>();
        int i = 0;
        while (i < strings.length) {
            sorted.put(String.valueOf(i + 1), strings[i]);
            ++i;
        }
        return sorted;
    }

    static Map<String, String> filterList(Map<String, ?> listObjects, Map<String, String> listUIDs) {
        Hashtable<String, String> filtered = new Hashtable<String, String>();
        for (Map.Entry<String, String> entry : listUIDs.entrySet()) {
            String id = entry.getKey();
            String uid = entry.getValue();
            Object obj = listObjects.get(uid);
            if (obj == null) continue;
            filtered.put(id, uid);
        }
        return filtered;
    }

    static String getTableContent(int width, int[] columnWidths, List<String> values, String titleRow) {
        StringBuilder sb = new StringBuilder();
        List<String> tableRows = Utils.collectTableRows(width, columnWidths, values, titleRow);
        for (String tableRow : tableRows) {
            sb.append(String.valueOf(tableRow) + ROW_END);
        }
        return sb.toString();
    }

    static List<String> collectTableRows(int width, int[] columnWidths, List<String> values, String titleRow) {
        List<String> tableRows = Utils.getTableTitle(titleRow, width);
        for (String value : values) {
            tableRows.add(value);
        }
        tableRows.add(Utils.getTableBottom(width));
        return tableRows;
    }

    static String getRow(int[] columnWidths, List<String> values) {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < columnWidths.length) {
            sb.append(Utils.getColumn(columnWidths[i], values.get(i)));
            ++i;
        }
        return sb.toString();
    }

    static List<String> getTableTitle(String titleRow, int width) {
        ArrayList<String> res = new ArrayList<String>();
        res.add(Utils.printChars('-', width));
        res.add(titleRow);
        res.add(Utils.printChars('-', width));
        return res;
    }

    static String getTableBottom(int width) {
        return Utils.printChars('-', width);
    }

    static String getColumn(int width, String value) {
        value = String.valueOf(value) + ' ';
        return String.valueOf(value) + Utils.printChars(' ', width - value.length());
    }

    static String printChars(char ch, int count) {
        if (count < 1) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < count) {
            sb.append(ch);
            ++i;
        }
        return sb.toString();
    }

    static void quickSort(String[] strings, int begin, int length) {
        while (length >= 3) {
            int rightLength;
            int leftLength;
            int t = length - 1;
            int j = t + begin;
            int i = (t >> 1) + begin;
            Utils.sort3(strings, begin, i, j);
            if (length == 3) {
                return;
            }
            String x = strings[i];
            i = begin + 1;
            --j;
            while (true) {
                if (strings[i].compareTo(x) < 0) {
                    ++i;
                    continue;
                }
                while (strings[j].compareTo(x) > 0) {
                    --j;
                }
                if (i >= j) {
                    if (i != j) break;
                    ++i;
                    --j;
                    break;
                }
                Utils.swap(strings, i, j);
                if (++i > --j) break;
            }
            if ((leftLength = j - begin + 1) < (rightLength = begin - i + length)) {
                if (leftLength > 1) {
                    Utils.quickSort(strings, begin, leftLength);
                }
                begin = i;
                length = rightLength;
                continue;
            }
            if (rightLength > 1) {
                Utils.quickSort(strings, i, rightLength);
            }
            length = leftLength;
        }
        if (length == 2 && strings[begin].compareTo(strings[begin + 1]) > 0) {
            Utils.swap(strings, begin, begin + 1);
        }
    }

    private static void sort3(String[] a, int x, int y, int z) {
        if (a[x].compareTo(a[y]) > 0) {
            if (a[x].compareTo(a[z]) > 0) {
                if (a[y].compareTo(a[z]) > 0) {
                    Utils.swap(a, x, z);
                } else {
                    Utils.swap3(a, x, y, z);
                }
            } else {
                Utils.swap(a, x, y);
            }
        } else if (a[x].compareTo(a[z]) > 0) {
            Utils.swap3(a, x, z, y);
        } else if (a[y].compareTo(a[z]) > 0) {
            Utils.swap(a, y, z);
        }
    }

    private static void swap(String[] a, int x, int y) {
        String t = a[x];
        a[x] = a[y];
        a[y] = t;
    }

    private static void swap3(String[] a, int x, int y, int z) {
        String t = a[x];
        a[x] = a[y];
        a[y] = a[z];
        a[z] = t;
    }
}

