/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.automation.internal.commands;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.openhab.core.automation.Rule;
import org.openhab.core.automation.RuleManager;
import org.openhab.core.automation.RuleRegistry;
import org.openhab.core.automation.RuleStatus;
import org.openhab.core.automation.RuleStatusInfo;
import org.openhab.core.automation.internal.commands.AutomationCommand;
import org.openhab.core.automation.internal.commands.AutomationCommandEnableRule;
import org.openhab.core.automation.internal.commands.AutomationCommandExport;
import org.openhab.core.automation.internal.commands.AutomationCommandImport;
import org.openhab.core.automation.internal.commands.AutomationCommandList;
import org.openhab.core.automation.internal.commands.AutomationCommandRemove;
import org.openhab.core.automation.internal.commands.AutomationCommands;
import org.openhab.core.automation.template.RuleTemplate;
import org.openhab.core.automation.template.TemplateRegistry;
import org.openhab.core.automation.type.ActionType;
import org.openhab.core.automation.type.ConditionType;
import org.openhab.core.automation.type.ModuleType;
import org.openhab.core.automation.type.ModuleTypeRegistry;
import org.openhab.core.automation.type.TriggerType;
import org.openhab.core.io.console.Console;
import org.openhab.core.io.console.extensions.ConsoleCommandExtension;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@NonNullByDefault
@Component
public class AutomationCommandsPluggable
extends AutomationCommands
implements ConsoleCommandExtension {
    public static final String NAME = "automation";
    public static final String DESCRIPTION = "Commands for managing Automation Rules, Templates and ModuleTypes resources.";
    private static final int MODULE_TYPE_REGISTRY = 3;
    private static final int TEMPLATE_REGISTRY = 2;
    private static final int RULE_REGISTRY = 1;
    protected final RuleRegistry ruleRegistry;
    protected final RuleManager ruleManager;
    protected final TemplateRegistry<RuleTemplate> templateRegistry;
    protected final ModuleTypeRegistry moduleTypeRegistry;

    @Activate
    public AutomationCommandsPluggable(ComponentContext componentContext, @Reference RuleRegistry ruleRegistry, @Reference ModuleTypeRegistry moduleTypeRegistry, @Reference TemplateRegistry<RuleTemplate> templateRegistry, @Reference RuleManager ruleManager) {
        this.ruleRegistry = ruleRegistry;
        this.moduleTypeRegistry = moduleTypeRegistry;
        this.templateRegistry = templateRegistry;
        this.ruleManager = ruleManager;
        this.initialize(componentContext.getBundleContext(), moduleTypeRegistry, templateRegistry, ruleRegistry);
    }

    @Deactivate
    protected void deactivate(ComponentContext componentContext) {
        super.dispose();
    }

    public void execute(String[] args, Console console) {
        String res;
        if (args.length == 0) {
            console.println(this.getUsages().stream().collect(Collectors.joining("\n")));
            return;
        }
        String command = args[0];
        String[] params = new String[args.length - 1];
        if (params.length > 0) {
            System.arraycopy(args, 1, params, 0, params.length);
        }
        if ((res = super.executeCommand(command, params)) == null) {
            console.println(String.format("Unsupported command %s", command));
        } else {
            console.println(res);
        }
    }

    public List<String> getUsages() {
        return Arrays.asList(this.buildCommandUsage("listModuleTypes [-st] <filter> <language>", "lists all Module Types. If filter is present, lists only matching Module Types. If language is missing, the default language will be used."), this.buildCommandUsage("listTemplates [-st] <filter> <language>", "lists all Templates. If filter is present, lists only matching Templates. If language is missing, the default language will be used."), this.buildCommandUsage("listRules [-st] <filter>", "lists all Rules. If filter is present, lists only matching Rules"), this.buildCommandUsage("removeModuleTypes [-st] <url>", "Removes the Module Types, loaded from the given url"), this.buildCommandUsage("removeTemplates [-st] <url>", "Removes the Templates, loaded from the given url"), this.buildCommandUsage("removeRule [-st] <uid>", "Removes the rule, specified by given UID"), this.buildCommandUsage("removeRules [-st] <filter>", "Removes the rules. If filter is present, removes only matching Rules"), this.buildCommandUsage("importModuleTypes [-p] <parserType> [-st] <url>", "Imports Module Types from given url. If parser type missing, \"json\" parser will be set as default"), this.buildCommandUsage("importTemplates [-p] <parserType> [-st] <url>", "Imports Templates from given url. If parser type missing, \"json\" parser will be set as default"), this.buildCommandUsage("importRules [-p] <parserType> [-st] <url>", "Imports Rules from given url. If parser type missing, \"json\" parser will be set as default"), this.buildCommandUsage("exportModuleTypes [-p] <parserType> [-st] <file>", "Exports Module Types in a file. If parser type missing, \"json\" parser will be set as default"), this.buildCommandUsage("exportTemplates [-p] <parserType> [-st] <file>", "Exports Templates in a file. If parser type missing, \"json\" parser will be set as default"), this.buildCommandUsage("exportRules [-p] <parserType> [-st] <file>", "Exports Rules in a file. If parser type missing, \"json\" parser will be set as default"), this.buildCommandUsage("enableRule [-st] <uid> <enable>", "Enables the Rule, specified by given UID. If enable parameter is missing, the result of the command will be visualization of enabled/disabled state of the rule, if its value is \"true\" or \"false\", the result of the command will be to set enable/disable on the Rule."));
    }

    public String getCommand() {
        return NAME;
    }

    public String getDescription() {
        return DESCRIPTION;
    }

    @Override
    public @Nullable Rule getRule(String uid) {
        return (Rule)this.ruleRegistry.get(uid);
    }

    @Override
    public @Nullable RuleTemplate getTemplate(String templateUID, @Nullable Locale locale) {
        return this.templateRegistry.get(templateUID, locale);
    }

    @Override
    public Collection<RuleTemplate> getTemplates(@Nullable Locale locale) {
        return this.templateRegistry.getAll(locale);
    }

    @Override
    public @Nullable ModuleType getModuleType(String typeUID, @Nullable Locale locale) {
        return this.moduleTypeRegistry.get(typeUID, locale);
    }

    public Collection<TriggerType> getTriggers(@Nullable Locale locale) {
        return this.moduleTypeRegistry.getTriggers(locale, new String[0]);
    }

    public Collection<ConditionType> getConditions(@Nullable Locale locale) {
        return this.moduleTypeRegistry.getConditions(locale, new String[0]);
    }

    public Collection<ActionType> getActions(@Nullable Locale locale) {
        return this.moduleTypeRegistry.getActions(locale, new String[0]);
    }

    @Override
    public String removeRule(String uid) {
        if (this.ruleRegistry.remove(uid) != null) {
            return "SUCCESS";
        }
        return String.format("Rule with id '%s' does not exist.", uid);
    }

    @Override
    public String removeRules(String ruleFilter) {
        for (Rule r : this.ruleRegistry.getAll()) {
            if (!r.getUID().contains(ruleFilter)) continue;
            this.ruleRegistry.remove(r.getUID());
        }
        return "SUCCESS";
    }

    @Override
    protected @Nullable AutomationCommand parseCommand(String command, String[] params) {
        if ("importModuleTypes".equalsIgnoreCase(command)) {
            return new AutomationCommandImport("importModuleTypes", params, 3, this);
        }
        if ("exportModuleTypes".equalsIgnoreCase(command)) {
            return new AutomationCommandExport("exportModuleTypes", params, 3, this);
        }
        if ("listModuleTypes".equalsIgnoreCase(command)) {
            return new AutomationCommandList("listModuleTypes", params, 3, this);
        }
        if ("importTemplates".equalsIgnoreCase(command)) {
            return new AutomationCommandImport("importTemplates", params, 2, this);
        }
        if ("exportTemplates".equalsIgnoreCase(command)) {
            return new AutomationCommandExport("exportTemplates", params, 2, this);
        }
        if ("listTemplates".equalsIgnoreCase(command)) {
            return new AutomationCommandList("listTemplates", params, 2, this);
        }
        if ("importRules".equalsIgnoreCase(command)) {
            return new AutomationCommandImport("importRules", params, 1, this);
        }
        if ("exportRules".equalsIgnoreCase(command)) {
            return new AutomationCommandExport("exportRules", params, 1, this);
        }
        if ("listRules".equalsIgnoreCase(command)) {
            return new AutomationCommandList("listRules", params, 1, this);
        }
        if ("removeTemplates".equalsIgnoreCase(command)) {
            return new AutomationCommandRemove("removeTemplates", params, 2, this);
        }
        if ("removeModuleTypes".equalsIgnoreCase(command)) {
            return new AutomationCommandRemove("removeModuleTypes", params, 3, this);
        }
        if ("removeRule".equalsIgnoreCase(command)) {
            return new AutomationCommandRemove("removeRule", params, 1, this);
        }
        if ("removeRules".equalsIgnoreCase(command)) {
            return new AutomationCommandRemove("removeRules", params, 1, this);
        }
        if ("enableRule".equalsIgnoreCase(command)) {
            return new AutomationCommandEnableRule("enableRule", params, 1, this);
        }
        return null;
    }

    protected String buildCommandUsage(String description) {
        return String.format("%s - %s", this.getCommand(), description);
    }

    protected String buildCommandUsage(String syntax, String description) {
        return String.format("%s %s - %s", this.getCommand(), syntax, description);
    }

    @Override
    public Collection<Rule> getRules() {
        return this.ruleRegistry.getAll();
    }

    @Override
    public @Nullable RuleStatus getRuleStatus(String ruleUID) {
        RuleStatusInfo rsi = this.ruleManager.getStatusInfo(ruleUID);
        return rsi != null ? rsi.getStatus() : null;
    }

    @Override
    public void setEnabled(String uid, boolean isEnabled) {
        this.ruleManager.setEnabled(uid, isEnabled);
    }
}

