/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.automation.internal.commands;

import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.URL;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.openhab.core.automation.parser.Parser;
import org.openhab.core.automation.parser.ParsingException;
import org.openhab.core.common.registry.ProviderChangeListener;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NonNullByDefault
public abstract class AbstractCommandProvider<@NonNull E>
implements ServiceTrackerCustomizer {
    protected final Logger logger = LoggerFactory.getLogger(AbstractCommandProvider.class);
    protected BundleContext bundleContext;
    protected final Map<URL, List<String>> providerPortfolio = new HashMap<URL, List<String>>();
    @NonNullByDefault(value={})
    protected ServiceTracker<Parser, Parser> parserTracker;
    protected final Map<String, Parser<E>> parsers = new HashMap<String, Parser<E>>();
    protected final Map<String, E> providedObjectsHolder = new HashMap<String, E>();
    protected final List<ProviderChangeListener<E>> listeners = new LinkedList<ProviderChangeListener<E>>();

    public AbstractCommandProvider(BundleContext context) {
        this.bundleContext = context;
        this.parserTracker = new ServiceTracker(context, Parser.class.getName(), (ServiceTrackerCustomizer)this);
        this.parserTracker.open();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        if (this.parserTracker != null) {
            this.parserTracker.close();
            this.parserTracker = null;
            this.parsers.clear();
            Map<Object, Object> map = this.providedObjectsHolder;
            synchronized (map) {
                this.providedObjectsHolder.clear();
            }
            map = this.providerPortfolio;
            synchronized (map) {
                this.providerPortfolio.clear();
            }
        }
    }

    public @Nullable Object addingService(@Nullable ServiceReference reference) {
        Parser service = (Parser)this.bundleContext.getService(reference);
        String key = (String)reference.getProperty("format");
        key = key == null ? "json" : key;
        this.parsers.put(key, service);
        return service;
    }

    public void modifiedService(@Nullable ServiceReference reference, @Nullable Object service) {
    }

    public void removedService(@Nullable ServiceReference reference, @Nullable Object service) {
        String key = (String)reference.getProperty("format");
        key = key == null ? "json" : key;
        this.parsers.remove(key);
    }

    public String exportData(String parserType, Set<E> set, File file) throws Exception {
        Parser<E> parser = this.parsers.get(parserType);
        if (parser != null) {
            block10: {
                Throwable throwable = null;
                Object var6_7 = null;
                OutputStreamWriter oWriter = new OutputStreamWriter(new FileOutputStream(file));
                try {
                    parser.serialize(set, oWriter);
                    if (oWriter == null) break block10;
                }
                catch (Throwable throwable2) {
                    try {
                        if (oWriter != null) {
                            oWriter.close();
                        }
                        throw throwable2;
                    }
                    catch (Throwable throwable3) {
                        if (throwable == null) {
                            throwable = throwable3;
                        } else if (throwable != throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        throw throwable;
                    }
                }
                oWriter.close();
            }
            return "SUCCESS";
        }
        return String.format("%s! Parser \"%s\" not found!", "FAIL", parserType);
    }

    protected abstract Set<E> importData(URL var1, Parser<E> var2, InputStreamReader var3) throws ParsingException;
}

