/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.automation.internal;

import java.time.ZonedDateTime;
import java.time.temporal.Temporal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.stream.Stream;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.openhab.core.automation.Condition;
import org.openhab.core.automation.Rule;
import org.openhab.core.automation.RuleExecution;
import org.openhab.core.automation.RulePredicates;
import org.openhab.core.automation.RuleRegistry;
import org.openhab.core.automation.Trigger;
import org.openhab.core.automation.handler.ConditionHandler;
import org.openhab.core.automation.handler.TimeBasedConditionHandler;
import org.openhab.core.automation.handler.TimeBasedTriggerHandler;
import org.openhab.core.automation.handler.TriggerHandler;
import org.openhab.core.automation.internal.RuleEngineImpl;
import org.openhab.core.scheduler.SchedulerTemporalAdjuster;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NonNullByDefault
final class RuleExecutionSimulator {
    private static final String TAG_SCHEDULE = "Schedule";
    private final Logger logger = LoggerFactory.getLogger(RuleExecutionSimulator.class);
    private final RuleRegistry ruleRegistry;
    private final RuleEngineImpl ruleEngine;

    public RuleExecutionSimulator(RuleRegistry ruleRegistry, RuleEngineImpl ruleEngine) {
        this.ruleRegistry = ruleRegistry;
        this.ruleEngine = ruleEngine;
    }

    public Stream<RuleExecution> simulateRuleExecutions(ZonedDateTime from, ZonedDateTime until) {
        this.logger.debug("Simulating rules from {} until {}.", (Object)from, (Object)until);
        return this.ruleRegistry.stream().filter(RulePredicates.hasAllTags(TAG_SCHEDULE)).filter(r -> this.ruleEngine.isEnabled(r.getUID())).map(r -> this.simulateExecutionsForRule((Rule)r, from, until)).flatMap(Collection::stream).sorted();
    }

    /*
     * WARNING - void declaration
     */
    private List<RuleExecution> simulateExecutionsForRule(Rule rule, ZonedDateTime from, ZonedDateTime until) {
        ArrayList<RuleExecution> executions = new ArrayList<RuleExecution>();
        for (Trigger trigger : rule.getTriggers()) {
            void handler;
            SchedulerTemporalAdjuster temporalAdjuster;
            TimeBasedTriggerHandler timeBasedTriggerHandler;
            TriggerHandler triggerHandler = (TriggerHandler)this.ruleEngine.getModuleHandler(trigger, rule.getUID());
            TriggerHandler triggerHandler2 = triggerHandler;
            if (!(triggerHandler2 instanceof TimeBasedTriggerHandler) || (timeBasedTriggerHandler = (TimeBasedTriggerHandler)triggerHandler2) != (TimeBasedTriggerHandler)triggerHandler2 || (temporalAdjuster = handler.getTemporalAdjuster()) == null) continue;
            executions.addAll(this.simulateExecutionsForCronBasedRule(rule, from, until, temporalAdjuster));
        }
        this.logger.debug("Created {} rule simulations for rule {}.", (Object)executions.size(), (Object)rule.getName());
        return executions;
    }

    private List<RuleExecution> simulateExecutionsForCronBasedRule(Rule rule, ZonedDateTime from, ZonedDateTime until, SchedulerTemporalAdjuster temporalAdjuster) {
        ArrayList<RuleExecution> result = new ArrayList<RuleExecution>();
        ZonedDateTime currentTime = ZonedDateTime.from(temporalAdjuster.adjustInto((Temporal)from));
        while (!temporalAdjuster.isDone((Temporal)currentTime) && currentTime.isBefore(until)) {
            if (this.checkConditions(rule, currentTime)) {
                result.add(new RuleExecution(Date.from(currentTime.toInstant()), rule));
            }
            currentTime = ZonedDateTime.from(temporalAdjuster.adjustInto((Temporal)currentTime));
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    private boolean checkConditions(Rule rule, ZonedDateTime current) {
        for (Condition condition : rule.getConditions()) {
            void handler;
            TimeBasedConditionHandler timeBasedConditionHandler;
            ConditionHandler conditionHandler = (ConditionHandler)this.ruleEngine.getModuleHandler(condition, rule.getUID());
            ConditionHandler conditionHandler2 = conditionHandler;
            if (!(conditionHandler2 instanceof TimeBasedConditionHandler) || (timeBasedConditionHandler = (TimeBasedConditionHandler)conditionHandler2) != (TimeBasedConditionHandler)conditionHandler2 || handler.isSatisfiedAt(current)) continue;
            return false;
        }
        return true;
    }
}

