/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.automation.handler;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.openhab.core.automation.Module;
import org.openhab.core.automation.handler.ModuleHandler;
import org.openhab.core.automation.handler.ModuleHandlerFactory;

@NonNullByDefault
public abstract class BaseModuleHandlerFactory
implements ModuleHandlerFactory {
    private final Map<String, ModuleHandler> handlers = new HashMap<String, ModuleHandler>();

    protected void deactivate() {
        for (ModuleHandler handler : this.handlers.values()) {
            handler.dispose();
        }
        this.handlers.clear();
    }

    protected Map<String, ModuleHandler> getHandlers() {
        return Collections.unmodifiableMap(this.handlers);
    }

    @Override
    public @Nullable ModuleHandler getHandler(Module module, String ruleUID) {
        String id = this.getModuleIdentifier(ruleUID, module.getId());
        ModuleHandler handler = this.handlers.get(id);
        ModuleHandler moduleHandler = handler = handler == null ? this.internalCreate(module, ruleUID) : handler;
        if (handler != null) {
            this.handlers.put(id, handler);
        }
        return handler;
    }

    protected abstract @Nullable ModuleHandler internalCreate(Module var1, String var2);

    @Override
    public void ungetHandler(Module module, String ruleUID, ModuleHandler handler) {
        if (this.handlers.remove(this.getModuleIdentifier(ruleUID, module.getId()), handler)) {
            handler.dispose();
        }
    }

    protected String getModuleIdentifier(String ruleUid, String moduleId) {
        return String.valueOf(ruleUid) + "$" + moduleId;
    }
}

