/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.transform;

import java.util.Map;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.openhab.core.common.registry.Identifiable;

@NonNullByDefault
public class Transformation
implements Identifiable<String> {
    public static final String FUNCTION = "function";
    private final String uid;
    private final String label;
    private final String type;
    private final Map<String, String> configuration;

    public Transformation(String uid, String label, String type, Map<String, String> configuration) {
        this.uid = uid;
        this.label = label;
        this.type = type;
        this.configuration = configuration;
    }

    public String getUID() {
        return this.uid;
    }

    public String getLabel() {
        return this.label;
    }

    public String getType() {
        return this.type;
    }

    public Map<String, String> getConfiguration() {
        return this.configuration;
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Transformation that = (Transformation)o;
        return this.uid.equals(that.uid) && this.label.equals(that.label) && this.type.equals(that.type) && this.configuration.equals(that.configuration);
    }

    public int hashCode() {
        return Objects.hash(this.uid, this.label, this.type, this.configuration);
    }

    public String toString() {
        return "TransformationConfiguration{uid='" + this.uid + "', label='" + this.label + "', type='" + this.type + "', configuration='" + this.configuration + "'}";
    }
}

