/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.automation.module.script.profile;

import java.util.List;
import javax.script.ScriptException;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.openhab.core.config.core.ConfigParser;
import org.openhab.core.thing.profiles.ProfileCallback;
import org.openhab.core.thing.profiles.ProfileContext;
import org.openhab.core.thing.profiles.ProfileTypeUID;
import org.openhab.core.thing.profiles.StateProfile;
import org.openhab.core.transform.TransformationException;
import org.openhab.core.transform.TransformationService;
import org.openhab.core.types.Command;
import org.openhab.core.types.State;
import org.openhab.core.types.Type;
import org.openhab.core.types.TypeParser;
import org.openhab.core.types.UnDefType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NonNullByDefault
public class ScriptProfile
implements StateProfile {
    public static final String CONFIG_TO_ITEM_SCRIPT = "toItemScript";
    public static final String CONFIG_TO_HANDLER_SCRIPT = "toHandlerScript";
    private final Logger logger = LoggerFactory.getLogger(ScriptProfile.class);
    private final ProfileCallback callback;
    private final TransformationService transformationService;
    private final List<Class<? extends State>> acceptedDataTypes;
    private final List<Class<? extends Command>> acceptedCommandTypes;
    private final List<Class<? extends Command>> handlerAcceptedCommandTypes;
    private final String toItemScript;
    private final String toHandlerScript;
    private final ProfileTypeUID profileTypeUID;
    private final boolean isConfigured;

    public ScriptProfile(ProfileTypeUID profileTypeUID, ProfileCallback callback, ProfileContext profileContext, TransformationService transformationService) {
        this.profileTypeUID = profileTypeUID;
        this.callback = callback;
        this.transformationService = transformationService;
        this.acceptedCommandTypes = profileContext.getAcceptedCommandTypes();
        this.acceptedDataTypes = profileContext.getAcceptedDataTypes();
        this.handlerAcceptedCommandTypes = profileContext.getHandlerAcceptedCommandTypes();
        this.toItemScript = (String)ConfigParser.valueAsOrElse((Object)profileContext.getConfiguration().get(CONFIG_TO_ITEM_SCRIPT), String.class, (Object)"");
        this.toHandlerScript = (String)ConfigParser.valueAsOrElse((Object)profileContext.getConfiguration().get(CONFIG_TO_HANDLER_SCRIPT), String.class, (Object)"");
        if (this.toItemScript.isBlank() && this.toHandlerScript.isBlank()) {
            this.logger.error("Neither 'toItemScript' nor 'toHandlerScript' defined in link '{}'. Profile will discard all states and commands.", (Object)callback.getItemChannelLink());
            this.isConfigured = false;
            return;
        }
        this.isConfigured = true;
    }

    public ProfileTypeUID getProfileTypeUID() {
        return this.profileTypeUID;
    }

    public void onStateUpdateFromItem(State state) {
    }

    public void onCommandFromItem(Command command) {
        Command newCommand;
        String returnValue;
        if (this.isConfigured && (returnValue = this.executeScript(this.toHandlerScript, (Type)command)) != null && (newCommand = TypeParser.parseCommand(this.handlerAcceptedCommandTypes, (String)returnValue)) != null) {
            this.callback.handleCommand(newCommand);
        }
    }

    public void onCommandFromHandler(Command command) {
        Command newCommand;
        String returnValue;
        if (this.isConfigured && (returnValue = this.executeScript(this.toItemScript, (Type)command)) != null && (newCommand = TypeParser.parseCommand(this.acceptedCommandTypes, (String)returnValue)) != null) {
            this.callback.sendCommand(newCommand);
        }
    }

    public void onStateUpdateFromHandler(State state) {
        if (this.isConfigured) {
            State newState;
            String returnValue = this.executeScript(this.toItemScript, (Type)state);
            if ("UNDEF".equals(returnValue)) {
                this.callback.sendUpdate((State)UnDefType.UNDEF);
            } else if ("NULL".equals(returnValue)) {
                this.callback.sendUpdate((State)UnDefType.NULL);
            } else if (returnValue != null && (newState = TypeParser.parseState(this.acceptedDataTypes, (String)returnValue)) != null) {
                this.callback.sendUpdate(newState);
            }
        }
    }

    private @Nullable String executeScript(String script, Type input) {
        if (!script.isBlank()) {
            try {
                return this.transformationService.transform(script, input.toFullString());
            }
            catch (TransformationException e) {
                if (e.getCause() instanceof ScriptException) {
                    this.logger.error("Failed to process script '{}': {}", (Object)script, (Object)e.getCause().getMessage());
                }
                this.logger.error("Failed to process script '{}': {}", (Object)script, (Object)e.getMessage());
            }
        }
        return null;
    }
}

