/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.automation.module.script.internal.handler;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import javax.script.ScriptEngine;
import javax.script.ScriptException;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.openhab.core.automation.Action;
import org.openhab.core.automation.handler.ActionHandler;
import org.openhab.core.automation.module.script.ScriptEngineManager;
import org.openhab.core.automation.module.script.internal.handler.AbstractScriptModuleHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NonNullByDefault
public class ScriptActionHandler
extends AbstractScriptModuleHandler<Action>
implements ActionHandler {
    public static final String TYPE_ID = "script.ScriptAction";
    private final Logger logger = LoggerFactory.getLogger(ScriptActionHandler.class);
    private final Consumer<ScriptActionHandler> onRemoval;

    public ScriptActionHandler(Action module, String ruleUID, ScriptEngineManager scriptEngineManager, Consumer<ScriptActionHandler> onRemoval) {
        super(module, ruleUID, scriptEngineManager);
        this.onRemoval = onRemoval;
    }

    @Override
    public void dispose() {
        this.onRemoval.accept(this);
        super.dispose();
    }

    public @Nullable Map<String, Object> execute(Map<String, Object> context) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        this.getScriptEngine().ifPresent(scriptEngine -> {
            this.setExecutionContext((ScriptEngine)scriptEngine, context);
            try {
                Object result = scriptEngine.eval(this.script);
                resultMap.put("result", result);
            }
            catch (ScriptException e) {
                this.logger.error("Script execution of rule with UID '{}' failed: {}", new Object[]{this.ruleUID, e.getMessage(), this.logger.isDebugEnabled() ? e : null});
            }
            this.resetExecutionContext((ScriptEngine)scriptEngine, context);
        });
        return resultMap;
    }
}

