/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.automation.module.script.internal.handler;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import javax.script.ScriptContext;
import javax.script.ScriptEngine;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.openhab.core.automation.Module;
import org.openhab.core.automation.handler.BaseModuleHandler;
import org.openhab.core.automation.module.script.ScriptEngineContainer;
import org.openhab.core.automation.module.script.ScriptEngineManager;
import org.openhab.core.config.core.Configuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NonNullByDefault
public abstract class AbstractScriptModuleHandler<T extends Module>
extends BaseModuleHandler<T> {
    private final Logger logger = LoggerFactory.getLogger(AbstractScriptModuleHandler.class);
    public static final String SCRIPT_TYPE = "type";
    public static final String SCRIPT = "script";
    protected final ScriptEngineManager scriptEngineManager;
    private final String engineIdentifier;
    private Optional<ScriptEngine> scriptEngine = Optional.empty();
    private final String type;
    protected final String script;
    protected final String ruleUID;

    public AbstractScriptModuleHandler(T module, String ruleUID, ScriptEngineManager scriptEngineManager) {
        super(module);
        this.scriptEngineManager = scriptEngineManager;
        this.ruleUID = ruleUID;
        this.engineIdentifier = UUID.randomUUID().toString();
        this.type = AbstractScriptModuleHandler.getValidConfigParameter(SCRIPT_TYPE, module.getConfiguration(), module.getId());
        this.script = AbstractScriptModuleHandler.getValidConfigParameter(SCRIPT, module.getConfiguration(), module.getId());
    }

    private static String getValidConfigParameter(String parameter, Configuration config, String moduleId) {
        Object value = config.get(parameter);
        if (value != null && value instanceof String var4_5 && !string.trim().isEmpty()) {
            return string;
        }
        throw new IllegalStateException(String.format("Config parameter '%s' is missing in the configuration of module '%s'.", parameter, moduleId));
    }

    public void dispose() {
        this.scriptEngineManager.removeEngine(this.engineIdentifier);
    }

    public synchronized void resetScriptEngine() {
        this.scriptEngineManager.removeEngine(this.engineIdentifier);
        this.scriptEngine = Optional.empty();
    }

    public String getEngineIdentifier() {
        return this.engineIdentifier;
    }

    protected Optional<ScriptEngine> getScriptEngine() {
        return this.scriptEngine.isPresent() ? this.scriptEngine : this.createScriptEngine();
    }

    private Optional<ScriptEngine> createScriptEngine() {
        ScriptEngineContainer container = this.scriptEngineManager.createScriptEngine(this.type, this.engineIdentifier);
        if (container != null) {
            this.scriptEngine = Optional.ofNullable(container.getScriptEngine());
            return this.scriptEngine;
        }
        this.logger.debug("No engine available for script type '{}' in action '{}'.", (Object)this.type, (Object)this.module.getId());
        return Optional.empty();
    }

    protected void setExecutionContext(ScriptEngine engine, Map<String, ?> context) {
        ScriptContext executionContext = engine.getContext();
        HashMap contextNew = new HashMap(context);
        contextNew.put("ruleUID", this.ruleUID);
        executionContext.setAttribute("ctx", contextNew, 100);
        executionContext.setAttribute("ruleUID", this.ruleUID, 100);
        for (Map.Entry<String, ?> entry : context.entrySet()) {
            Object value = entry.getValue();
            String key = entry.getKey();
            int dotIndex = key.indexOf(46);
            if (dotIndex != -1) {
                key = key.substring(dotIndex + 1);
            }
            executionContext.setAttribute(key, value, 100);
        }
    }

    protected void resetExecutionContext(ScriptEngine engine, Map<String, ?> context) {
        ScriptContext executionContext = engine.getContext();
        for (Map.Entry<String, ?> entry : context.entrySet()) {
            String key = entry.getKey();
            int dotIndex = key.indexOf(46);
            if (dotIndex != -1) {
                key = key.substring(dotIndex + 1);
            }
            executionContext.removeAttribute(key, 100);
        }
    }
}

