/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.automation.module.script.internal.defaultscope;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.openhab.core.automation.module.script.defaultscope.ScriptThingActions;
import org.openhab.core.thing.Thing;
import org.openhab.core.thing.ThingRegistry;
import org.openhab.core.thing.ThingUID;
import org.openhab.core.thing.binding.ThingActions;
import org.openhab.core.thing.binding.ThingActionsScope;
import org.openhab.core.thing.binding.ThingHandler;

@NonNullByDefault
public class ScriptThingActionsImpl
implements ScriptThingActions {
    private static final Map<String, ThingActions> THING_ACTIONS_MAP = new HashMap<String, ThingActions>();
    private @Nullable ThingRegistry thingRegistry;

    ScriptThingActionsImpl(ThingRegistry thingRegistry) {
        this.thingRegistry = thingRegistry;
    }

    public void dispose() {
        this.thingRegistry = null;
    }

    @Override
    public @Nullable ThingActions get(@Nullable String scope, @Nullable String thingUid) {
        ThingHandler handler;
        ThingUID uid;
        Thing thing;
        ThingRegistry thingRegistry = this.thingRegistry;
        if (thingUid != null && scope != null && thingRegistry != null && (thing = thingRegistry.get(uid = new ThingUID(thingUid))) != null && (handler = thing.getHandler()) != null) {
            return THING_ACTIONS_MAP.get(ScriptThingActionsImpl.getKey(scope, thingUid));
        }
        return null;
    }

    void addThingActions(ThingActions thingActions) {
        String key = ScriptThingActionsImpl.getKey(thingActions);
        if (key != null) {
            THING_ACTIONS_MAP.put(key, thingActions);
        }
    }

    void removeThingActions(ThingActions thingActions) {
        String key = ScriptThingActionsImpl.getKey(thingActions);
        THING_ACTIONS_MAP.remove(key);
    }

    private static @Nullable String getKey(ThingActions thingActions) {
        String scope = ScriptThingActionsImpl.getScope(thingActions);
        String thingUID = ScriptThingActionsImpl.getThingUID(thingActions);
        if (thingUID == null) {
            return null;
        }
        return ScriptThingActionsImpl.getKey(scope, thingUID);
    }

    private static String getKey(String scope, String thingUID) {
        return String.valueOf(scope) + "-" + thingUID;
    }

    private static @Nullable String getThingUID(ThingActions actions) {
        ThingHandler thingHandler = actions.getThingHandler();
        if (thingHandler == null) {
            return null;
        }
        return thingHandler.getThing().getUID().getAsString();
    }

    private static String getScope(ThingActions actions) {
        ThingActionsScope scopeAnnotation = actions.getClass().getAnnotation(ThingActionsScope.class);
        return scopeAnnotation.name();
    }
}

