/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.automation.module.script.internal.defaultscope;

import java.time.ZonedDateTime;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.openhab.core.automation.module.script.defaultscope.ScriptBusEvent;
import org.openhab.core.events.Event;
import org.openhab.core.events.EventPublisher;
import org.openhab.core.items.GroupItem;
import org.openhab.core.items.Item;
import org.openhab.core.items.ItemNotFoundException;
import org.openhab.core.items.ItemRegistry;
import org.openhab.core.items.events.ItemEventFactory;
import org.openhab.core.types.Command;
import org.openhab.core.types.State;
import org.openhab.core.types.TimeSeries;
import org.openhab.core.types.TypeParser;
import org.slf4j.LoggerFactory;

@NonNullByDefault
public class ScriptBusEventImpl
implements ScriptBusEvent {
    private @Nullable ItemRegistry itemRegistry;
    private @Nullable EventPublisher eventPublisher;

    ScriptBusEventImpl(ItemRegistry itemRegistry, EventPublisher eventPublisher) {
        this.itemRegistry = itemRegistry;
        this.eventPublisher = eventPublisher;
    }

    public void dispose() {
        this.itemRegistry = null;
        this.eventPublisher = null;
    }

    @Override
    public @Nullable Object sendCommand(@Nullable Item item, @Nullable String commandString) {
        if (item != null) {
            return this.sendCommand(item.getName(), commandString);
        }
        return null;
    }

    @Override
    public @Nullable Object sendCommand(@Nullable Item item, @Nullable Number number) {
        if (item != null && number != null) {
            return this.sendCommand(item.getName(), number.toString());
        }
        return null;
    }

    @Override
    public @Nullable Object sendCommand(@Nullable String itemName, @Nullable String commandString) {
        EventPublisher eventPublisher = this.eventPublisher;
        ItemRegistry itemRegistry = this.itemRegistry;
        if (eventPublisher != null && itemRegistry != null && itemName != null && commandString != null) {
            try {
                Item item = itemRegistry.getItem(itemName);
                Command command = TypeParser.parseCommand((List)item.getAcceptedCommandTypes(), (String)commandString);
                if (command != null) {
                    eventPublisher.post((Event)ItemEventFactory.createCommandEvent((String)itemName, (Command)command));
                } else {
                    LoggerFactory.getLogger(ScriptBusEventImpl.class).warn("Command '{}' cannot be parsed for item '{}'.", (Object)commandString, (Object)item);
                }
            }
            catch (ItemNotFoundException e) {
                LoggerFactory.getLogger(ScriptBusEventImpl.class).warn("Item '{}' does not exist.", (Object)itemName);
            }
        }
        return null;
    }

    @Override
    public @Nullable Object sendCommand(@Nullable Item item, @Nullable Command command) {
        EventPublisher eventPublisher = this.eventPublisher;
        if (eventPublisher != null && item != null && command != null) {
            eventPublisher.post((Event)ItemEventFactory.createCommandEvent((String)item.getName(), (Command)command));
        }
        return null;
    }

    @Override
    public @Nullable Object postUpdate(@Nullable Item item, @Nullable Number state) {
        if (item != null && state != null) {
            return this.postUpdate(item.getName(), state.toString());
        }
        return null;
    }

    @Override
    public @Nullable Object postUpdate(@Nullable Item item, @Nullable String stateAsString) {
        if (item != null) {
            return this.postUpdate(item.getName(), stateAsString);
        }
        return null;
    }

    @Override
    public @Nullable Object postUpdate(@Nullable String itemName, @Nullable String stateString) {
        EventPublisher eventPublisher = this.eventPublisher;
        ItemRegistry itemRegistry = this.itemRegistry;
        if (eventPublisher != null && itemRegistry != null && itemName != null && stateString != null) {
            try {
                Item item = itemRegistry.getItem(itemName);
                State state = TypeParser.parseState((List)item.getAcceptedDataTypes(), (String)stateString);
                if (state != null) {
                    eventPublisher.post((Event)ItemEventFactory.createStateEvent((String)itemName, (State)state));
                } else {
                    LoggerFactory.getLogger(ScriptBusEventImpl.class).warn("State '{}' cannot be parsed for item '{}'.", (Object)stateString, (Object)itemName);
                }
            }
            catch (ItemNotFoundException e) {
                LoggerFactory.getLogger(ScriptBusEventImpl.class).warn("Item '{}' does not exist.", (Object)itemName);
            }
        }
        return null;
    }

    @Override
    public @Nullable Object postUpdate(@Nullable Item item, @Nullable State state) {
        EventPublisher eventPublisher = this.eventPublisher;
        if (eventPublisher != null && item != null && state != null) {
            eventPublisher.post((Event)ItemEventFactory.createStateEvent((String)item.getName(), (State)state));
        }
        return null;
    }

    @Override
    public @Nullable Object sendTimeSeries(@Nullable Item item, @Nullable TimeSeries timeSeries) {
        EventPublisher eventPublisher1 = this.eventPublisher;
        if (eventPublisher1 != null && item != null && timeSeries != null) {
            eventPublisher1.post((Event)ItemEventFactory.createTimeSeriesEvent((String)item.getName(), (TimeSeries)timeSeries, null));
        }
        return null;
    }

    @Override
    public @Nullable Object sendTimeSeries(@Nullable String itemName, @Nullable Map<ZonedDateTime, State> values, @Nullable String policy) {
        EventPublisher eventPublisher1 = this.eventPublisher;
        if (eventPublisher1 != null && itemName != null && values != null && policy != null) {
            try {
                TimeSeries timeSeries = new TimeSeries(TimeSeries.Policy.valueOf((String)policy));
                values.forEach((key, value) -> timeSeries.add(key.toInstant(), value));
                eventPublisher1.post((Event)ItemEventFactory.createTimeSeriesEvent((String)itemName, (TimeSeries)timeSeries, null));
            }
            catch (IllegalArgumentException e) {
                LoggerFactory.getLogger(ScriptBusEventImpl.class).warn("Policy '{}' does not exist.", (Object)policy);
            }
        }
        return null;
    }

    @Override
    public Map<Item, State> storeStates(Item ... items) {
        HashMap<Item, State> statesMap = new HashMap<Item, State>();
        if (items != null) {
            Item[] itemArray = items;
            int n = items.length;
            int n2 = 0;
            while (n2 < n) {
                Item item = itemArray[n2];
                if (item instanceof GroupItem var7_7) {
                    for (Item member : groupItem.getAllMembers()) {
                        statesMap.put(member, member.getState());
                    }
                } else {
                    statesMap.put(item, item.getState());
                }
                ++n2;
            }
        }
        return statesMap;
    }

    @Override
    public @Nullable Object restoreStates(@Nullable Map<Item, State> statesMap) {
        if (statesMap != null) {
            for (Map.Entry<Item, State> entry : statesMap.entrySet()) {
                if (entry.getValue() instanceof Command) {
                    this.sendCommand(entry.getKey(), (Command)entry.getValue());
                    continue;
                }
                this.postUpdate(entry.getKey(), entry.getValue());
            }
        }
        return null;
    }
}

