/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.automation.module.script.internal;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.script.ScriptEngine;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.openhab.core.automation.module.script.ScriptEngineFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NonNullByDefault
public class ScriptEngineFactoryHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger(ScriptEngineFactoryHelper.class);

    private ScriptEngineFactoryHelper() {
    }

    public static @Nullable Map.Entry<String, String> getParameterOption(ScriptEngineFactory engineFactory) {
        List<String> scriptTypes = engineFactory.getScriptTypes();
        if (!scriptTypes.isEmpty()) {
            ScriptEngine scriptEngine = engineFactory.createScriptEngine(scriptTypes.get(0));
            if (scriptEngine != null) {
                Map.Entry<String, String> parameterOption = Map.entry(ScriptEngineFactoryHelper.getPreferredMimeType(engineFactory), ScriptEngineFactoryHelper.getLanguageName(scriptEngine.getFactory()));
                LOGGER.trace("ParameterOptions: {}", parameterOption);
                return parameterOption;
            }
            LOGGER.trace("setScriptEngineFactory: engine was null");
        } else {
            LOGGER.trace("addScriptEngineFactory: scriptTypes was empty");
        }
        return null;
    }

    public static String getPreferredMimeType(ScriptEngineFactory factory) {
        List<String> scriptTypes = factory.getScriptTypes();
        if (scriptTypes.isEmpty()) {
            throw new IllegalStateException(String.valueOf(factory.getClass().getName()) + " does not support any scriptTypes. Please report it as a bug.");
        }
        ArrayList<String> mimeTypes = new ArrayList<String>(scriptTypes);
        mimeTypes.removeIf(mimeType -> !mimeType.contains("application") || "application/python".equals(mimeType));
        return mimeTypes.isEmpty() ? scriptTypes.get(0) : (String)mimeTypes.get(0);
    }

    public static String getLanguageName(javax.script.ScriptEngineFactory factory) {
        return String.format("%s (%s)", String.valueOf(factory.getLanguageName().substring(0, 1).toUpperCase()) + factory.getLanguageName().substring(1), factory.getLanguageVersion());
    }

    public static Optional<String> getPreferredExtension(ScriptEngineFactory factory) {
        return factory.getScriptTypes().stream().filter(type -> !type.contains("/")).min(Comparator.comparing(String::length));
    }
}

