/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.config.discovery.addon.process;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.openhab.core.addon.AddonDiscoveryMethod;
import org.openhab.core.addon.AddonInfo;
import org.openhab.core.addon.AddonMatchProperty;
import org.openhab.core.config.discovery.addon.AddonFinder;
import org.openhab.core.config.discovery.addon.BaseAddonFinder;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NonNullByDefault
@Component(service={AddonFinder.class}, name="process-addon-suggestion-finder")
public class ProcessAddonFinder
extends BaseAddonFinder {
    public static final String SERVICE_TYPE = "process";
    public static final String CFG_FINDER_PROCESS = "suggestionFinderProcess";
    public static final String SERVICE_NAME = "process-addon-suggestion-finder";
    private static final String COMMAND = "command";
    private final Logger logger = LoggerFactory.getLogger(ProcessAddonFinder.class);

    @Activate
    public ProcessAddonFinder() {
    }

    String getProcessCommandProcess(ProcessHandle h) {
        Optional<String> command = h.info().command();
        if (command.isPresent()) {
            return command.get();
        }
        Optional<String[]> args = h.info().arguments();
        if (!args.isPresent()) {
            return "";
        }
        String[] argsArray = args.get();
        if (argsArray.length < 1) {
            return "";
        }
        return argsArray[0];
    }

    public Set<AddonInfo> getSuggestedAddons() {
        this.logger.trace("ProcessAddonFinder::getSuggestedAddons");
        HashSet<AddonInfo> result = new HashSet<AddonInfo>();
        Set processList = Collections.emptySet();
        try {
            processList = ProcessHandle.allProcesses().map(this::getProcessCommandProcess).filter(Predicate.not(String::isEmpty)).collect(Collectors.toUnmodifiableSet());
        }
        catch (SecurityException | UnsupportedOperationException unused) {
            this.logger.info("Cannot obtain process list, suggesting add-ons based on running processes is not possible");
            return result;
        }
        block2: for (AddonInfo candidate : this.addonCandidates) {
            block3: for (AddonDiscoveryMethod method2 : candidate.getDiscoveryMethods().stream().filter(method -> SERVICE_TYPE.equals(method.getServiceType())).toList()) {
                List matchProperties = method2.getMatchProperties();
                List commands = matchProperties.stream().filter(amp -> COMMAND.equals(amp.getName())).collect(Collectors.toUnmodifiableList());
                if (matchProperties.size() != commands.size()) {
                    this.logger.warn("Add-on '{}' addon.xml file contains unsupported 'match-property'", (Object)candidate.getUID());
                }
                if (commands.isEmpty()) {
                    this.logger.warn("Add-on '{}' addon.xml file does not specify match property \"{}\"", (Object)candidate.getUID(), (Object)COMMAND);
                    continue block2;
                }
                this.logger.debug("Checking candidate: {}", (Object)candidate.getUID());
                for (AddonMatchProperty command : commands) {
                    this.logger.trace("Candidate {}, pattern \"{}\"", (Object)candidate.getUID(), (Object)command.getRegex());
                    boolean match = processList.stream().anyMatch(c -> command.getPattern().matcher((CharSequence)c).matches());
                    if (!match) continue;
                    result.add(candidate);
                    this.logger.debug("Suggested add-on found: {}", (Object)candidate.getUID());
                    continue block3;
                }
            }
        }
        return result;
    }

    public String getServiceName() {
        return SERVICE_NAME;
    }
}

