/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.config.discovery.internal;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.openhab.core.common.ThreadPoolManager;
import org.openhab.core.common.registry.Identifiable;
import org.openhab.core.common.registry.RegistryChangeListener;
import org.openhab.core.config.core.ConfigDescription;
import org.openhab.core.config.core.ConfigDescriptionParameter;
import org.openhab.core.config.core.ConfigDescriptionRegistry;
import org.openhab.core.config.core.ConfigUtil;
import org.openhab.core.config.core.Configuration;
import org.openhab.core.config.discovery.DiscoveryListener;
import org.openhab.core.config.discovery.DiscoveryResult;
import org.openhab.core.config.discovery.DiscoveryResultFlag;
import org.openhab.core.config.discovery.DiscoveryService;
import org.openhab.core.config.discovery.DiscoveryServiceRegistry;
import org.openhab.core.config.discovery.inbox.Inbox;
import org.openhab.core.config.discovery.inbox.InboxListener;
import org.openhab.core.config.discovery.inbox.InboxPredicates;
import org.openhab.core.config.discovery.inbox.events.InboxEventFactory;
import org.openhab.core.config.discovery.internal.DiscoveryResultImpl;
import org.openhab.core.events.Event;
import org.openhab.core.events.EventPublisher;
import org.openhab.core.storage.Storage;
import org.openhab.core.storage.StorageService;
import org.openhab.core.thing.Bridge;
import org.openhab.core.thing.ManagedThingProvider;
import org.openhab.core.thing.Thing;
import org.openhab.core.thing.ThingRegistry;
import org.openhab.core.thing.ThingRegistryChangeListener;
import org.openhab.core.thing.ThingTypeUID;
import org.openhab.core.thing.ThingUID;
import org.openhab.core.thing.binding.ThingFactory;
import org.openhab.core.thing.binding.ThingHandlerFactory;
import org.openhab.core.thing.type.ThingType;
import org.openhab.core.thing.type.ThingTypeRegistry;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, service={Inbox.class})
@NonNullByDefault
public final class PersistentInbox
implements Inbox,
DiscoveryListener,
ThingRegistryChangeListener {
    private final Logger logger = LoggerFactory.getLogger(PersistentInbox.class);
    private final Set<InboxListener> listeners = new CopyOnWriteArraySet<InboxListener>();
    private final DiscoveryServiceRegistry discoveryServiceRegistry;
    private final ThingRegistry thingRegistry;
    private final ManagedThingProvider managedThingProvider;
    private final ThingTypeRegistry thingTypeRegistry;
    private final ConfigDescriptionRegistry configDescRegistry;
    private final Storage<DiscoveryResult> discoveryResultStorage;
    private final Map<DiscoveryResult, Class<?>> resultDiscovererMap = new ConcurrentHashMap();
    @NonNullByDefault(value={})
    private ScheduledFuture<?> timeToLiveChecker;
    @NonNullByDefault(value={})
    private ScheduledFuture<?> delayedDiscoveryResultProcessor;
    private @Nullable EventPublisher eventPublisher;
    private final List<ThingHandlerFactory> thingHandlerFactories = new CopyOnWriteArrayList<ThingHandlerFactory>();
    private Map<ThingUID, DiscoveryResultWrapper> delayedDiscoveryResults = new ConcurrentHashMap<ThingUID, DiscoveryResultWrapper>();

    @Activate
    public PersistentInbox(@Reference StorageService storageService, @Reference DiscoveryServiceRegistry discoveryServiceRegistry, @Reference ThingRegistry thingRegistry, @Reference ManagedThingProvider thingProvider, @Reference ThingTypeRegistry thingTypeRegistry, @Reference ConfigDescriptionRegistry configDescriptionRegistry) {
        this.discoveryResultStorage = storageService.getStorage(DiscoveryResult.class.getName(), this.getClass().getClassLoader());
        this.discoveryServiceRegistry = discoveryServiceRegistry;
        this.thingRegistry = thingRegistry;
        this.managedThingProvider = thingProvider;
        this.thingTypeRegistry = thingTypeRegistry;
        this.configDescRegistry = configDescriptionRegistry;
    }

    @Activate
    protected void activate() {
        this.discoveryServiceRegistry.addDiscoveryListener(this);
        this.thingRegistry.addRegistryChangeListener((RegistryChangeListener)this);
        ScheduledExecutorService scheduler = ThreadPoolManager.getScheduledPool((String)"discovery");
        this.timeToLiveChecker = scheduler.scheduleWithFixedDelay(new TimeToLiveCheckingThread(this), 0L, 30L, TimeUnit.SECONDS);
        this.delayedDiscoveryResultProcessor = scheduler.scheduleWithFixedDelay(() -> Set.copyOf(this.delayedDiscoveryResults.values()).forEach(this::internalAdd), 0L, 15L, TimeUnit.SECONDS);
    }

    @Deactivate
    protected void deactivate() {
        this.thingRegistry.removeRegistryChangeListener((RegistryChangeListener)this);
        this.discoveryServiceRegistry.removeDiscoveryListener(this);
        this.listeners.clear();
        this.timeToLiveChecker.cancel(true);
        this.delayedDiscoveryResultProcessor.cancel(true);
        this.delayedDiscoveryResults.values().forEach(dr -> {
            boolean bl = dr.future.complete(false);
        });
    }

    @Override
    public @Nullable Thing approve(ThingUID thingUID, @Nullable String label, @Nullable String newThingId) {
        Thing newThing;
        if (thingUID == null) {
            throw new IllegalArgumentException("Thing UID must not be null");
        }
        List<DiscoveryResult> results = this.stream().filter(InboxPredicates.forThingUID(thingUID)).toList();
        if (results.isEmpty()) {
            throw new IllegalArgumentException("No Thing with UID " + thingUID.getAsString() + " in inbox");
        }
        if (newThingId != null && newThingId.contains(":")) {
            throw new IllegalArgumentException("New Thing ID " + newThingId + " must not contain multiple segments");
        }
        DiscoveryResult result = results.get(0);
        HashMap<String, String> properties = new HashMap<String, String>();
        HashMap<String, Object> configParams = new HashMap<String, Object>();
        this.getPropsAndConfigParams(result, properties, configParams);
        Configuration config = new Configuration(configParams);
        ThingTypeUID thingTypeUID = result.getThingTypeUID();
        ThingUID newThingUID = thingUID;
        if (newThingId != null) {
            String newUID = String.valueOf(thingUID.getAsString().substring(0, thingUID.getAsString().lastIndexOf(":") + 1)) + newThingId;
            try {
                newThingUID = new ThingUID(newUID);
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException("Invalid thing UID " + newUID, e);
            }
        }
        if ((newThing = ThingFactory.createThing((ThingUID)newThingUID, (Configuration)config, properties, (ThingUID)result.getBridgeUID(), (ThingTypeUID)thingTypeUID, this.thingHandlerFactories)) == null) {
            this.logger.warn("Cannot create thing. No binding found that supports creating a thing of type {}.", (Object)thingTypeUID);
            return null;
        }
        if (label != null && !label.isEmpty()) {
            newThing.setLabel(label);
        } else {
            newThing.setLabel(result.getLabel());
        }
        this.addThingSafely(newThing);
        return newThing;
    }

    @Override
    public synchronized CompletableFuture<Boolean> add(@Nullable DiscoveryResult discoveryResult) throws IllegalStateException {
        if (discoveryResult == null) {
            return CompletableFuture.completedFuture(false);
        }
        CompletableFuture<Boolean> future = new CompletableFuture<Boolean>();
        this.internalAdd(new DiscoveryResultWrapper(discoveryResult, future));
        return future;
    }

    private void internalAdd(DiscoveryResultWrapper discoveryResultWrapper) {
        DiscoveryResult discoveryResult = discoveryResultWrapper.discoveryResult;
        this.delayedDiscoveryResults.remove(discoveryResult.getThingUID());
        ThingType thingType = this.thingTypeRegistry.getThingType(discoveryResult.getThingTypeUID());
        if (thingType == null) {
            ++discoveryResultWrapper.retryCount;
            if (discoveryResultWrapper.retryCount >= 20) {
                this.logger.info("ThingTypeUID {} for discovery result with ThingUID {} not found, retried 20 times, aborting", (Object)discoveryResult.getThingTypeUID(), (Object)discoveryResult.getThingUID());
                discoveryResultWrapper.future.complete(false);
            } else {
                this.logger.trace("ThingTypeUID {} for discovery result with ThingUID {} not found, delaying add, retry {}/20", new Object[]{discoveryResult.getThingTypeUID(), discoveryResult.getThingUID(), discoveryResultWrapper.retryCount});
                this.delayedDiscoveryResults.put(discoveryResult.getThingUID(), discoveryResultWrapper);
            }
            return;
        }
        List<String> configurationParameters = this.getConfigDescParams(thingType).stream().map(ConfigDescriptionParameter::getName).toList();
        discoveryResult.normalizePropertiesOnConfigDescription(configurationParameters);
        ThingUID thingUID = discoveryResult.getThingUID();
        Thing thing = this.thingRegistry.get(thingUID);
        if (thing == null) {
            DiscoveryResult inboxResult = this.get(thingUID);
            if (inboxResult == null) {
                this.discoveryResultStorage.put(discoveryResult.getThingUID().toString(), (Object)discoveryResult);
                this.notifyListeners(discoveryResult, EventType.ADDED);
                this.logger.info("Added new thing '{}' to inbox.", (Object)thingUID);
                discoveryResultWrapper.future.complete(true);
            } else {
                if (inboxResult instanceof DiscoveryResultImpl var8_10) {
                    resultImpl.synchronize(discoveryResult);
                    this.discoveryResultStorage.put(discoveryResult.getThingUID().toString(), (Object)resultImpl);
                    this.notifyListeners((DiscoveryResult)resultImpl, EventType.UPDATED);
                    this.logger.debug("Updated discovery result for '{}'.", (Object)thingUID);
                    discoveryResultWrapper.future.complete(true);
                } else {
                    this.logger.warn("Cannot synchronize result with implementation class '{}'.", (Object)inboxResult.getClass().getName());
                }
            }
        } else if (this.managedThingProvider.get((Object)thingUID) != null) {
            this.logger.debug("Discovery result with thing '{}' not added as inbox entry. It is already present as thing in the ThingRegistry.", (Object)thingUID);
            boolean updated = this.synchronizeConfiguration(discoveryResult.getThingTypeUID(), discoveryResult.getProperties(), thing.getConfiguration());
            if (updated) {
                this.logger.debug("The configuration for thing '{}' is updated...", (Object)thingUID);
                this.managedThingProvider.update((Identifiable)thing);
            }
        }
        discoveryResultWrapper.future.complete(false);
    }

    private boolean synchronizeConfiguration(ThingTypeUID thingTypeUID, Map<String, Object> properties, Configuration config) {
        boolean configUpdated = false;
        Set<Map.Entry<String, Object>> propertySet = properties.entrySet();
        ThingType thingType = this.thingTypeRegistry.getThingType(thingTypeUID);
        List<ConfigDescriptionParameter> configDescParams = this.getConfigDescParams(thingType);
        for (Map.Entry<String, Object> propertyEntry : propertySet) {
            ConfigDescriptionParameter configDescParam;
            Object normalizedValue;
            String propertyKey = propertyEntry.getKey();
            Object propertyValue = propertyEntry.getValue();
            if (!config.containsKey(propertyKey) || Objects.equals(normalizedValue = ConfigUtil.normalizeType((Object)propertyValue, (ConfigDescriptionParameter)(configDescParam = this.getConfigDescriptionParam(configDescParams, propertyKey))), config.get(propertyKey))) continue;
            config.put(propertyKey, normalizedValue);
            configUpdated = true;
        }
        return configUpdated;
    }

    private @Nullable ConfigDescriptionParameter getConfigDescriptionParam(List<ConfigDescriptionParameter> configDescParams, String paramName) {
        for (ConfigDescriptionParameter configDescriptionParameter : configDescParams) {
            if (!configDescriptionParameter.getName().equals(paramName)) continue;
            return configDescriptionParameter;
        }
        return null;
    }

    @Override
    public void addInboxListener(@Nullable InboxListener listener) throws IllegalStateException {
        if (listener != null) {
            this.listeners.add(listener);
        }
    }

    @Override
    public List<DiscoveryResult> getAll() {
        return this.stream().toList();
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Override
    public Stream<DiscoveryResult> stream() {
        Storage<DiscoveryResult> discoveryResultStorage = this.discoveryResultStorage;
        if (discoveryResultStorage == null) {
            ScheduledFuture<?> timeToLiveChecker = this.timeToLiveChecker;
            this.logger.error("The OSGi lifecycle has been violated (storage: {}, ttl checker cancelled: {}).", this.discoveryResultStorage == null ? "null" : this.discoveryResultStorage, timeToLiveChecker == null ? "null" : Boolean.valueOf(timeToLiveChecker.isCancelled()));
            return Stream.empty();
        }
        @Nullable Collection values = discoveryResultStorage.getValues();
        if (values == null) {
            this.logger.warn("The storage service violates the nullness requirements (get values must not return null) (storage class: {}).", discoveryResultStorage.getClass());
            return Stream.empty();
        }
        return values.stream().filter(Objects::nonNull);
    }

    @Override
    public synchronized boolean remove(@Nullable ThingUID thingUID) throws IllegalStateException {
        DiscoveryResult discoveryResult;
        if (thingUID != null && (discoveryResult = this.get(thingUID)) != null) {
            if (!this.isInRegistry(thingUID)) {
                this.removeResultsForBridge(thingUID);
            }
            this.resultDiscovererMap.remove(discoveryResult);
            this.discoveryResultStorage.remove(thingUID.toString());
            this.notifyListeners(discoveryResult, EventType.REMOVED);
            return true;
        }
        return false;
    }

    @Override
    public void removeInboxListener(@Nullable InboxListener listener) throws IllegalStateException {
        if (listener != null) {
            this.listeners.remove(listener);
        }
    }

    @Override
    public void thingDiscovered(DiscoveryService source, DiscoveryResult result) {
        this.add(result).thenAccept(success -> {
            if (success.booleanValue()) {
                this.resultDiscovererMap.put(result, source.getClass());
            }
        });
    }

    @Override
    public void thingRemoved(DiscoveryService source, ThingUID thingUID) {
        this.remove(thingUID);
    }

    @Override
    public @Nullable Collection<ThingUID> removeOlderResults(DiscoveryService source, long timestamp, @Nullable Collection<ThingTypeUID> thingTypeUIDs, @Nullable ThingUID bridgeUID) {
        HashSet<ThingUID> removedThings = new HashSet<ThingUID>();
        for (DiscoveryResult discoveryResult : this.getAll()) {
            Class<?> discoverer = this.resultDiscovererMap.get(discoveryResult);
            if (thingTypeUIDs == null || !thingTypeUIDs.contains(discoveryResult.getThingTypeUID()) || discoveryResult.getTimestamp() >= timestamp || discoverer != null && source.getClass() != discoverer) continue;
            ThingUID thingUID = discoveryResult.getThingUID();
            if (bridgeUID != null && !bridgeUID.equals((Object)discoveryResult.getBridgeUID())) continue;
            removedThings.add(thingUID);
            this.remove(thingUID);
            this.logger.debug("Removed thing '{}' from inbox because it was older than {}.", (Object)thingUID, (Object)new Date(timestamp));
        }
        return removedThings;
    }

    public void added(Thing thing) {
        if (this.remove(thing.getUID())) {
            this.logger.debug("Discovery result for thing '{}' removed from inbox, because it was added as a Thing to the ThingRegistry.", (Object)thing.getUID());
        }
    }

    public void removed(Thing thing) {
        if (thing instanceof Bridge) {
            this.removeResultsForBridge(thing.getUID());
        }
    }

    public void updated(Thing oldThing, Thing thing) {
    }

    @Override
    public void setFlag(ThingUID thingUID, @Nullable DiscoveryResultFlag flag) {
        DiscoveryResult result = this.get(thingUID);
        if (result instanceof DiscoveryResultImpl var4_5) {
            resultImpl.setFlag(flag == null ? DiscoveryResultFlag.NEW : flag);
            this.discoveryResultStorage.put(resultImpl.getThingUID().toString(), (Object)resultImpl);
            this.notifyListeners((DiscoveryResult)resultImpl, EventType.UPDATED);
        } else if (result == null) {
            this.logger.warn("Cannot set flag for result '{}' because it can't be found in storage", (Object)thingUID);
        } else {
            this.logger.warn("Cannot set flag for result of instance type '{}'", (Object)result.getClass().getName());
        }
    }

    private @Nullable DiscoveryResult get(ThingUID thingUID) {
        if (thingUID != null) {
            return (DiscoveryResult)this.discoveryResultStorage.get(thingUID.toString());
        }
        return null;
    }

    private void notifyListeners(DiscoveryResult result, EventType type) {
        DiscoveryResult resultForEvent;
        for (InboxListener listener : this.listeners) {
            try {
                switch (type) {
                    case ADDED: {
                        listener.thingAdded(this, result);
                        break;
                    }
                    case REMOVED: {
                        listener.thingRemoved(this, result);
                        break;
                    }
                    case UPDATED: {
                        listener.thingUpdated(this, result);
                    }
                }
            }
            catch (Exception ex) {
                this.logger.error("Cannot notify the InboxListener '{}' about a Thing {} event!", new Object[]{listener.getClass().getName(), type.name(), ex});
            }
        }
        if (type == EventType.REMOVED) {
            resultForEvent = result;
        } else {
            resultForEvent = this.get(result.getThingUID());
            if (resultForEvent == null) {
                return;
            }
        }
        this.postEvent(resultForEvent, type);
    }

    private void postEvent(DiscoveryResult result, EventType eventType) {
        if (this.eventPublisher != null) {
            try {
                switch (eventType) {
                    case ADDED: {
                        this.eventPublisher.post((Event)InboxEventFactory.createAddedEvent(result));
                        break;
                    }
                    case REMOVED: {
                        this.eventPublisher.post((Event)InboxEventFactory.createRemovedEvent(result));
                        break;
                    }
                    case UPDATED: {
                        this.eventPublisher.post((Event)InboxEventFactory.createUpdatedEvent(result));
                        break;
                    }
                }
            }
            catch (Exception ex) {
                this.logger.error("Could not post event of type '{}'.", (Object)eventType.name(), (Object)ex);
            }
        }
    }

    private boolean isInRegistry(ThingUID thingUID) {
        return this.thingRegistry.get(thingUID) != null;
    }

    private void removeResultsForBridge(ThingUID bridgeUID) {
        for (ThingUID thingUID : this.getResultsForBridge(bridgeUID)) {
            DiscoveryResult discoveryResult = this.get(thingUID);
            if (discoveryResult == null) continue;
            this.discoveryResultStorage.remove(thingUID.toString());
            this.notifyListeners(discoveryResult, EventType.REMOVED);
        }
    }

    private List<ThingUID> getResultsForBridge(ThingUID bridgeUID) {
        ArrayList<ThingUID> thingsForBridge = new ArrayList<ThingUID>();
        for (DiscoveryResult result : this.discoveryResultStorage.getValues()) {
            if (!bridgeUID.equals((Object)result.getBridgeUID())) continue;
            thingsForBridge.add(result.getThingUID());
        }
        return thingsForBridge;
    }

    private void getPropsAndConfigParams(DiscoveryResult discoveryResult, Map<String, String> props, Map<String, Object> configParams) {
        List<ConfigDescriptionParameter> configDescParams = this.getConfigDescParams(discoveryResult);
        Set<String> paramNames = this.getConfigDescParamNames(configDescParams);
        Map<String, Object> resultProps = discoveryResult.getProperties();
        for (Map.Entry<String, Object> resultEntry : resultProps.entrySet()) {
            String resultKey = resultEntry.getKey();
            Object resultValue = resultEntry.getValue();
            if (paramNames.contains(resultKey)) {
                ConfigDescriptionParameter param = this.getConfigDescriptionParam(configDescParams, resultKey);
                Object normalizedValue = ConfigUtil.normalizeType((Object)resultValue, (ConfigDescriptionParameter)param);
                configParams.put(resultKey, normalizedValue);
                continue;
            }
            props.put(resultKey, String.valueOf(resultValue));
        }
    }

    private Set<String> getConfigDescParamNames(List<ConfigDescriptionParameter> configDescParams) {
        HashSet<String> paramNames = new HashSet<String>();
        if (configDescParams != null) {
            for (ConfigDescriptionParameter param : configDescParams) {
                paramNames.add(param.getName());
            }
        }
        return paramNames;
    }

    private List<ConfigDescriptionParameter> getConfigDescParams(DiscoveryResult discoveryResult) {
        ThingType thingType = this.thingTypeRegistry.getThingType(discoveryResult.getThingTypeUID());
        return this.getConfigDescParams(thingType);
    }

    private List<ConfigDescriptionParameter> getConfigDescParams(@Nullable ThingType thingType) {
        ConfigDescription desc;
        URI descURI;
        if (thingType != null && thingType.getConfigDescriptionURI() != null && (descURI = thingType.getConfigDescriptionURI()) != null && (desc = this.configDescRegistry.getConfigDescription(descURI)) != null) {
            return desc.getParameters();
        }
        return List.of();
    }

    private void addThingSafely(Thing thing) {
        ThingUID thingUID = thing.getUID();
        if (this.thingRegistry.get(thingUID) != null) {
            this.thingRegistry.remove(thingUID);
        }
        this.thingRegistry.add((Identifiable)thing);
    }

    void setTimeToLiveCheckingInterval(int interval) {
        this.timeToLiveChecker.cancel(true);
        this.timeToLiveChecker = ThreadPoolManager.getScheduledPool((String)"discovery").scheduleWithFixedDelay(new TimeToLiveCheckingThread(this), 0L, interval, TimeUnit.SECONDS);
    }

    void setDiscoveryResultAddRetryInterval(int interval) {
        this.delayedDiscoveryResultProcessor.cancel(true);
        this.delayedDiscoveryResultProcessor = ThreadPoolManager.getScheduledPool((String)"discovery").scheduleWithFixedDelay(() -> Set.copyOf(this.delayedDiscoveryResults.values()).forEach(this::internalAdd), 0L, interval, TimeUnit.SECONDS);
    }

    @Reference(cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC)
    protected void setEventPublisher(EventPublisher eventPublisher) {
        this.eventPublisher = eventPublisher;
    }

    protected void unsetEventPublisher(EventPublisher eventPublisher) {
        this.eventPublisher = null;
    }

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    protected void addThingHandlerFactory(ThingHandlerFactory thingHandlerFactory) {
        this.thingHandlerFactories.add(thingHandlerFactory);
    }

    protected void removeThingHandlerFactory(ThingHandlerFactory thingHandlerFactory) {
        this.thingHandlerFactories.remove(thingHandlerFactory);
    }

    private static class DiscoveryResultWrapper {
        public final CompletableFuture<Boolean> future;
        public final DiscoveryResult discoveryResult;
        public int retryCount = 0;

        public DiscoveryResultWrapper(DiscoveryResult discoveryResult, CompletableFuture<Boolean> future) {
            this.discoveryResult = discoveryResult;
            this.future = future;
        }
    }

    private static enum EventType {
        ADDED,
        REMOVED,
        UPDATED;

    }

    private class TimeToLiveCheckingThread
    implements Runnable {
        private final PersistentInbox inbox;

        public TimeToLiveCheckingThread(PersistentInbox inbox) {
            this.inbox = inbox;
        }

        @Override
        public void run() {
            long now = new Date().getTime();
            for (DiscoveryResult result : this.inbox.getAll()) {
                if (!this.isResultExpired(result, now)) continue;
                PersistentInbox.this.logger.debug("Inbox entry for thing '{}' is expired and will be removed.", (Object)result.getThingUID());
                PersistentInbox.this.remove(result.getThingUID());
            }
        }

        private boolean isResultExpired(DiscoveryResult result, long now) {
            if (result.getTimeToLive() == -1L) {
                return false;
            }
            return result.getTimestamp() + result.getTimeToLive() * 1000L < now;
        }
    }
}

