/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.config.discovery.internal;

import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.openhab.core.config.discovery.DiscoveryResult;
import org.openhab.core.config.discovery.DiscoveryResultFlag;
import org.openhab.core.thing.ThingTypeUID;
import org.openhab.core.thing.ThingUID;

@NonNullByDefault
public class DiscoveryResultImpl
implements DiscoveryResult {
    private @Nullable ThingUID bridgeUID;
    @NonNullByDefault(value={})
    private ThingUID thingUID;
    private @Nullable ThingTypeUID thingTypeUID;
    private Map<String, Object> properties = Map.of();
    private @Nullable String representationProperty;
    @NonNullByDefault(value={})
    private DiscoveryResultFlag flag;
    @NonNullByDefault(value={})
    private String label;
    private long timestamp;
    private long timeToLive = -1L;

    DiscoveryResultImpl() {
    }

    @Deprecated
    public DiscoveryResultImpl(@Nullable ThingTypeUID thingTypeUID, ThingUID thingUID, @Nullable ThingUID bridgeUID, @Nullable Map<String, Object> properties, @Nullable String representationProperty, @Nullable String label, long timeToLive) throws IllegalArgumentException {
        if (thingUID == null) {
            throw new IllegalArgumentException("The thing UID must not be null!");
        }
        if (timeToLive < 1L && timeToLive != -1L) {
            throw new IllegalArgumentException("The ttl must not be 0 or negative!");
        }
        this.thingUID = thingUID;
        this.thingTypeUID = thingTypeUID;
        this.bridgeUID = bridgeUID;
        this.properties = properties == null ? Map.of() : Collections.unmodifiableMap(properties);
        this.representationProperty = representationProperty;
        this.label = label == null ? "" : label;
        this.timestamp = new Date().getTime();
        this.timeToLive = timeToLive;
        this.flag = DiscoveryResultFlag.NEW;
    }

    @Override
    public ThingUID getThingUID() {
        return this.thingUID;
    }

    @Override
    public ThingTypeUID getThingTypeUID() {
        ThingTypeUID localThingTypeUID = this.thingTypeUID;
        if (localThingTypeUID != null) {
            return localThingTypeUID;
        }
        String[] segments = this.thingUID.getAsString().split(":");
        if (!segments[1].isEmpty()) {
            return new ThingTypeUID(this.thingUID.getBindingId(), segments[1]);
        }
        throw new IllegalArgumentException("ThingTypeUID of thing '" + this.thingUID.getAsString() + "' is null.");
    }

    @Override
    public String getBindingId() {
        return this.thingUID.getBindingId();
    }

    @Override
    public Map<String, Object> getProperties() {
        return this.properties;
    }

    @Override
    public @Nullable String getRepresentationProperty() {
        return this.representationProperty;
    }

    @Override
    public DiscoveryResultFlag getFlag() {
        return this.flag;
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    @Override
    public @Nullable ThingUID getBridgeUID() {
        return this.bridgeUID;
    }

    public void synchronize(@Nullable DiscoveryResult sourceResult) {
        if (sourceResult != null && this.thingUID.equals((Object)sourceResult.getThingUID())) {
            this.properties = sourceResult.getProperties();
            this.representationProperty = sourceResult.getRepresentationProperty();
            this.label = sourceResult.getLabel();
            this.timestamp = new Date().getTime();
            this.timeToLive = sourceResult.getTimeToLive();
        }
    }

    @Override
    public void normalizePropertiesOnConfigDescription(List<String> configurationParameters) {
        this.properties = this.properties.entrySet().stream().map(e -> {
            if (!configurationParameters.contains(e.getKey())) {
                return Map.entry((String)e.getKey(), String.valueOf(e.getValue()));
            }
            return e;
        }).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    public void setFlag(@Nullable DiscoveryResultFlag flag) {
        this.flag = flag == null ? DiscoveryResultFlag.NEW : flag;
    }

    public int hashCode() {
        return 31 + this.thingUID.hashCode();
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        DiscoveryResultImpl other = (DiscoveryResultImpl)obj;
        return !(this.thingUID == null ? other.thingUID != null : !this.thingUID.equals((Object)other.thingUID));
    }

    public String toString() {
        return "DiscoveryResult [thingUID=" + this.thingUID + ", properties=" + this.properties + ", representationProperty=" + this.representationProperty + ", flag=" + (Object)((Object)this.flag) + ", label=" + this.label + ", bridgeUID=" + this.bridgeUID + ", ttl=" + this.timeToLive + ", timestamp=" + this.timestamp + "]";
    }

    @Override
    public long getTimestamp() {
        return this.timestamp;
    }

    @Override
    public long getTimeToLive() {
        return this.timeToLive;
    }
}

