/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.config.discovery;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.openhab.core.config.discovery.DiscoveryResult;
import org.openhab.core.config.discovery.internal.DiscoveryResultImpl;
import org.openhab.core.thing.ThingTypeUID;
import org.openhab.core.thing.ThingUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NonNullByDefault
public class DiscoveryResultBuilder {
    private Logger logger = LoggerFactory.getLogger(DiscoveryResultBuilder.class);
    private final ThingUID thingUID;
    private @Nullable ThingUID bridgeUID;
    private final Map<String, Object> properties = new HashMap<String, Object>();
    private @Nullable String representationProperty;
    private @Nullable String label;
    private long ttl = -1L;
    private @Nullable ThingTypeUID thingTypeUID;

    private DiscoveryResultBuilder(ThingUID thingUID) {
        this.thingUID = thingUID;
    }

    public static DiscoveryResultBuilder create(ThingUID thingUID) {
        return new DiscoveryResultBuilder(thingUID);
    }

    public DiscoveryResultBuilder withThingType(@Nullable ThingTypeUID thingTypeUID) {
        this.thingTypeUID = thingTypeUID;
        return this;
    }

    public DiscoveryResultBuilder withProperties(@Nullable Map<String, Object> properties) {
        if (properties != null) {
            this.properties.putAll(properties);
        }
        return this;
    }

    public DiscoveryResultBuilder withProperty(String key, Object value) {
        this.properties.put(key, value);
        return this;
    }

    public DiscoveryResultBuilder withRepresentationProperty(@Nullable String representationProperty) {
        this.representationProperty = representationProperty;
        return this;
    }

    public DiscoveryResultBuilder withBridge(@Nullable ThingUID bridgeUID) {
        this.validateThingUID(bridgeUID);
        this.bridgeUID = bridgeUID;
        return this;
    }

    public DiscoveryResultBuilder withLabel(@Nullable String label) {
        this.label = label;
        return this;
    }

    public DiscoveryResultBuilder withTTL(long ttl) {
        this.ttl = ttl;
        return this;
    }

    public DiscoveryResult build() {
        String[] segments;
        if (this.representationProperty != null && !this.properties.containsKey(this.representationProperty)) {
            this.logger.warn("Representation property '{}' of discovery result for thing '{}' is missing in properties map. It has to be fixed by the bindings developer.\n{}", new Object[]{this.representationProperty, this.thingUID, this.getStackTrace(Thread.currentThread())});
        }
        if (this.thingTypeUID == null && !(segments = this.thingUID.getAsString().split(":"))[1].isEmpty()) {
            this.thingTypeUID = new ThingTypeUID(this.thingUID.getBindingId(), segments[1]);
        }
        return new DiscoveryResultImpl(this.thingTypeUID, this.thingUID, this.bridgeUID, this.properties, this.representationProperty, this.label, this.ttl);
    }

    private void validateThingUID(@Nullable ThingUID bridgeUID) {
        if (!(bridgeUID == null || this.thingUID.getBindingId().equals(bridgeUID.getBindingId()) && this.thingUID.getBridgeIds().contains(bridgeUID.getId()))) {
            throw new IllegalArgumentException("Thing UID '" + this.thingUID + "' does not match bridge UID '" + bridgeUID + "'");
        }
    }

    private String getStackTrace(Thread thread) {
        StackTraceElement[] elements = thread.getStackTrace();
        return Arrays.stream(elements).map(element -> "\tat " + element.toString()).collect(Collectors.joining("\n"));
    }
}

