/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.util;

import java.security.SecureRandom;
import java.util.ArrayList;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;

@NonNullByDefault
public class StringUtils {
    public static @Nullable String chomp(@Nullable String str) {
        if (str == null || str.isEmpty()) {
            return str;
        }
        if (str.endsWith("\r\n")) {
            return str.substring(0, str.length() - 2);
        }
        if (str.endsWith("\r") || str.endsWith("\n")) {
            return str.substring(0, str.length() - 1);
        }
        return str;
    }

    public static @Nullable String escapeXml(@Nullable String str) {
        if (str == null || str.isEmpty()) {
            return str;
        }
        return str.replace("&", "&amp;").replace("<", "&lt;").replace(">", "&gt;").replace("\"", "&quot;").replace("'", "&apos;");
    }

    public static @Nullable String capitalize(@Nullable String str) {
        if (str == null || str.isEmpty()) {
            return str;
        }
        StringBuilder sb = new StringBuilder(str);
        sb.setCharAt(0, Character.toUpperCase(str.charAt(0)));
        return sb.toString();
    }

    public static @Nullable String capitalizeByUnderscore(@Nullable String str) {
        if (str == null || str.isEmpty()) {
            return str;
        }
        String delimiter = "_";
        StringBuilder capitalizedFully = new StringBuilder();
        String[] stringArray = str.split("_");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String splitStr = stringArray[n2];
            if (splitStr.length() > 0) {
                capitalizedFully.append(splitStr.substring(0, 1).toUpperCase());
            }
            if (splitStr.length() > 1) {
                capitalizedFully.append(splitStr.substring(1).toLowerCase());
            }
            capitalizedFully.append("_");
            ++n2;
        }
        capitalizedFully.setLength(Math.max(capitalizedFully.length() - 1, 0));
        return capitalizedFully.toString();
    }

    public static @Nullable String capitalizeByWhitespace(@Nullable String str) {
        if (str == null || str.isEmpty()) {
            return str;
        }
        StringBuilder processed = new StringBuilder();
        String[] stringArray = str.split("\\s+");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String splitted = stringArray[n2];
            if (splitted.length() > 1) {
                processed.append(splitted.substring(0, 1).toUpperCase());
                processed.append(splitted.substring(1));
            } else {
                processed.append(splitted.toUpperCase());
            }
            processed.append(" ");
            ++n2;
        }
        processed.setLength(Math.max(processed.length() - 1, 0));
        return processed.toString();
    }

    public static String padLeft(@Nullable String str, int minSize, String padString) {
        String paddedString = str == null ? "" : str;
        return String.format("%" + minSize + "s", paddedString).replace(" ", padString);
    }

    public static String getRandomString(int length, String charset) {
        StringBuilder sb = new StringBuilder(length);
        SecureRandom secureRandom = new SecureRandom();
        int i = 0;
        while (i < length) {
            int index = secureRandom.nextInt(charset.length());
            sb.append(charset.charAt(index));
            ++i;
        }
        return sb.toString();
    }

    public static String getRandomAlphabetic(int length) {
        return StringUtils.getRandomString(length, "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvxyz");
    }

    public static String getRandomHex(int length) {
        return StringUtils.getRandomString(length, "0123456789ABCDEF");
    }

    public static String getRandomAlphanumeric(int length) {
        return StringUtils.getRandomString(length, "ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789abcdefghijklmnopqrstuvxyz");
    }

    public static String[] splitByCharacterType(@Nullable String str) {
        if (str == null || str.isBlank()) {
            return new String[0];
        }
        ArrayList<String> cache = new ArrayList<String>();
        char[] inputAsCharArray = str.toCharArray();
        int prevType = Character.getType(inputAsCharArray[0]);
        int prevTypeStart = 0;
        int i = prevTypeStart + 1;
        while (i < inputAsCharArray.length) {
            int curType = Character.getType(inputAsCharArray[i]);
            if (prevType != curType) {
                if (curType == 2 && prevType == 1) {
                    int tmpStart = i - 1;
                    if (tmpStart != prevTypeStart) {
                        cache.add(new String(inputAsCharArray, prevTypeStart, tmpStart - prevTypeStart));
                        prevTypeStart = tmpStart;
                    }
                } else {
                    cache.add(new String(inputAsCharArray, prevTypeStart, i - prevTypeStart));
                    prevTypeStart = i;
                }
                prevType = curType;
            }
            ++i;
        }
        cache.add(new String(inputAsCharArray, prevTypeStart, inputAsCharArray.length - prevTypeStart));
        return (String[])cache.toArray(String[]::new);
    }

    public static @Nullable String unEscapeXml(@Nullable String str) {
        if (str == null || str.isEmpty()) {
            return str;
        }
        return str.replace("&amp;", "&").replace("&lt;", "<").replace("&gt;", ">").replace("&quot;", "\"").replace("&apos;", "'");
    }
}

