/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.util;

import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.openhab.core.library.types.DecimalType;
import org.openhab.core.library.types.HSBType;
import org.openhab.core.library.types.PercentType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NonNullByDefault
public class ColorUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(ColorUtil.class);
    private static final MathContext COLOR_MATH_CONTEXT = new MathContext(5, RoundingMode.HALF_UP);
    private static final BigDecimal BIG_DECIMAL_360 = BigDecimal.valueOf(360L);
    private static final BigDecimal BIG_DECIMAL_255 = BigDecimal.valueOf(255L);
    private static final BigDecimal BIG_DECIMAL_240 = BigDecimal.valueOf(240L);
    private static final BigDecimal BIG_DECIMAL_120 = BigDecimal.valueOf(120L);
    private static final BigDecimal BIG_DECIMAL_100 = BigDecimal.valueOf(100L);
    private static final BigDecimal BIG_DECIMAL_60 = BigDecimal.valueOf(60L);
    private static final BigDecimal BIG_DECIMAL_50 = BigDecimal.valueOf(50L);
    private static final BigDecimal BIG_DECIMAL_5 = BigDecimal.valueOf(5L);
    private static final BigDecimal BIG_DECIMAL_3 = BigDecimal.valueOf(3L);
    private static final BigDecimal BIG_DECIMAL_2 = BigDecimal.valueOf(2L);
    private static final BigDecimal BIG_DECIMAL_2_POINT_55 = new BigDecimal("2.55");
    public static final Gamut DEFAULT_GAMUT = new Gamut(new double[]{0.9961, 1.0E-4}, new double[]{0.0, 0.9961}, new double[]{0.0, 1.0E-4});

    private ColorUtil() {
    }

    public static int[] hsbToRgb(HSBType hsb) {
        PercentType[] rgbPercent = ColorUtil.hsbToRgbPercent(hsb);
        return new int[]{ColorUtil.convertColorPercentToByte(rgbPercent[0]), ColorUtil.convertColorPercentToByte(rgbPercent[1]), ColorUtil.convertColorPercentToByte(rgbPercent[2])};
    }

    public static int[] hsbToRgbw(HSBType hsb) {
        PercentType[] rgbPercent = ColorUtil.hsbToRgbwPercent(hsb);
        return new int[]{ColorUtil.convertColorPercentToByte(rgbPercent[0]), ColorUtil.convertColorPercentToByte(rgbPercent[1]), ColorUtil.convertColorPercentToByte(rgbPercent[2]), ColorUtil.convertColorPercentToByte(rgbPercent[3])};
    }

    public static PercentType[] hsbToRgbPercent(HSBType hsb) {
        PercentType red = null;
        PercentType green = null;
        PercentType blue = null;
        BigDecimal h = hsb.getHue().toBigDecimal().divide(BIG_DECIMAL_100, 10, RoundingMode.HALF_UP);
        BigDecimal s = hsb.getSaturation().toBigDecimal().divide(BIG_DECIMAL_100);
        int hInt = h.multiply(BIG_DECIMAL_5).divide(BIG_DECIMAL_3, 0, RoundingMode.DOWN).intValue();
        BigDecimal f = h.multiply(BIG_DECIMAL_5).divide(BIG_DECIMAL_3, 10, RoundingMode.HALF_UP).remainder(BigDecimal.ONE);
        BigDecimal value = hsb.getBrightness().toBigDecimal();
        PercentType a = new PercentType(value.multiply(BigDecimal.ONE.subtract(s)));
        PercentType b = new PercentType(value.multiply(BigDecimal.ONE.subtract(s.multiply(f))));
        PercentType c = new PercentType(value.multiply(BigDecimal.ONE.subtract(BigDecimal.ONE.subtract(f).multiply(s))));
        switch (hInt) {
            case 0: 
            case 6: {
                red = hsb.getBrightness();
                green = c;
                blue = a;
                break;
            }
            case 1: {
                red = b;
                green = hsb.getBrightness();
                blue = a;
                break;
            }
            case 2: {
                red = a;
                green = hsb.getBrightness();
                blue = c;
                break;
            }
            case 3: {
                red = a;
                green = b;
                blue = hsb.getBrightness();
                break;
            }
            case 4: {
                red = c;
                green = a;
                blue = hsb.getBrightness();
                break;
            }
            case 5: {
                red = hsb.getBrightness();
                green = a;
                blue = b;
                break;
            }
            default: {
                throw new IllegalArgumentException("Could not convert to RGB.");
            }
        }
        return new PercentType[]{red, green, blue};
    }

    public static PercentType[] hsbToRgbwPercent(HSBType hsb) {
        BigDecimal inBlue;
        BigDecimal inGreen;
        PercentType[] rgb = ColorUtil.hsbToRgbPercent(hsb);
        BigDecimal inRed = rgb[0].toBigDecimal();
        BigDecimal maxColor = inRed.max((inGreen = rgb[1].toBigDecimal()).max(inBlue = rgb[2].toBigDecimal()));
        if (BigDecimal.ZERO.equals(maxColor)) {
            return new PercentType[]{PercentType.ZERO, PercentType.ZERO, PercentType.ZERO, PercentType.ZERO};
        }
        BigDecimal multiplier = BIG_DECIMAL_100.divide(maxColor, 0, RoundingMode.DOWN);
        BigDecimal hR = inRed.multiply(multiplier);
        BigDecimal hG = inGreen.multiply(multiplier);
        BigDecimal hB = inBlue.multiply(multiplier);
        BigDecimal whitenessMax = hR.max(hG.max(hB));
        BigDecimal whitenessMin = hR.min(hG.min(hB));
        BigDecimal luminance = whitenessMax.add(whitenessMin).divide(BIG_DECIMAL_2).subtract(BIG_DECIMAL_50).multiply(BIG_DECIMAL_100.divide(BIG_DECIMAL_50)).divide(multiplier);
        BigDecimal outRed = inRed.subtract(luminance).max(BigDecimal.ZERO);
        BigDecimal outGreen = inGreen.subtract(luminance).max(BigDecimal.ZERO);
        BigDecimal outBlue = inBlue.subtract(luminance).max(BigDecimal.ZERO);
        BigDecimal outWhite = luminance.max(BigDecimal.ZERO);
        return new PercentType[]{new PercentType(outRed), new PercentType(outGreen), new PercentType(outBlue), new PercentType(outWhite)};
    }

    public static int hsbTosRgb(HSBType hsb) {
        int[] rgb = ColorUtil.hsbToRgb(hsb);
        return 0xFF000000 | (rgb[0] & 0xFF) << 16 | (rgb[1] & 0xFF) << 8 | (rgb[2] & 0xFF) << 0;
    }

    public static double[] hsbToXY(HSBType hsb) {
        return ColorUtil.hsbToXY(hsb, DEFAULT_GAMUT);
    }

    public static double[] hsbToXY(HSBType hsb, Gamut gamut) {
        double Z;
        double Y;
        double b;
        double g;
        PercentType[] rgb = ColorUtil.hsbToRgbPercent(hsb);
        double r = ColorUtil.inverseCompand(rgb[0].doubleValue() / PercentType.HUNDRED.doubleValue());
        double X = r * 0.664511 + (g = ColorUtil.inverseCompand(rgb[1].doubleValue() / PercentType.HUNDRED.doubleValue())) * 0.154324 + (b = ColorUtil.inverseCompand(rgb[2].doubleValue() / PercentType.HUNDRED.doubleValue())) * 0.162028;
        double sum = X + (Y = r * 0.283881 + g * 0.668433 + b * 0.047685) + (Z = r * 8.8E-5 + g * 0.07231 + b * 0.986039);
        Point p = sum == 0.0 ? new Point() : new Point(X / sum, Y / sum);
        Point q = gamut.closest(p);
        double[] xyY = new double[]{(double)((int)(q.x * 10000.0)) / 10000.0, (double)((int)(q.y * 10000.0)) / 10000.0, (double)((int)(Y * 10000.0)) / 10000.0};
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("HSB: {} - RGB: {} - XYZ: {} {} {} - xyY: {}", new Object[]{hsb, ColorUtil.hsbToRgbPercent(hsb), X, Y, Z, xyY});
        }
        return xyY;
    }

    public static HSBType rgbToHsb(int[] rgbw) throws IllegalArgumentException {
        if (rgbw.length == 4) {
            if (!(ColorUtil.inByteRange(rgbw[0]) && ColorUtil.inByteRange(rgbw[1]) && ColorUtil.inByteRange(rgbw[2]) && ColorUtil.inByteRange(rgbw[3]))) {
                throw new IllegalArgumentException("rgbToHsb requires 3 or 4 values between 0 and 255");
            }
            return ColorUtil.rgbwToHsb(new PercentType[]{ColorUtil.convertByteToColorPercent(rgbw[0]), ColorUtil.convertByteToColorPercent(rgbw[1]), ColorUtil.convertByteToColorPercent(rgbw[2]), ColorUtil.convertByteToColorPercent(rgbw[3])});
        }
        if (!(rgbw.length == 3 && ColorUtil.inByteRange(rgbw[0]) && ColorUtil.inByteRange(rgbw[1]) && ColorUtil.inByteRange(rgbw[2]))) {
            throw new IllegalArgumentException("rgbToHsb requires 3 or 4 values between 0 and 255");
        }
        return ColorUtil.rgbToHsb(new PercentType[]{ColorUtil.convertByteToColorPercent(rgbw[0]), ColorUtil.convertByteToColorPercent(rgbw[1]), ColorUtil.convertByteToColorPercent(rgbw[2])});
    }

    private static HSBType rgbwToHsb(PercentType[] rgbw) {
        BigDecimal inBlue;
        BigDecimal inGreen;
        if (rgbw.length != 4) {
            throw new IllegalArgumentException("RGBW requires 4 values");
        }
        BigDecimal luminance = BigDecimal.valueOf(rgbw[3].doubleValue() / PercentType.HUNDRED.doubleValue() * 255.0);
        BigDecimal inRed = BigDecimal.valueOf(rgbw[0].doubleValue() / PercentType.HUNDRED.doubleValue() * 255.0).add(luminance);
        BigDecimal maxColor = BIG_DECIMAL_255.min(inRed.max((inGreen = BigDecimal.valueOf(rgbw[1].doubleValue() / PercentType.HUNDRED.doubleValue() * 255.0).add(luminance)).max(inBlue = BigDecimal.valueOf(rgbw[2].doubleValue() / PercentType.HUNDRED.doubleValue() * 255.0).add(luminance))).max(BigDecimal.ZERO));
        if (BigDecimal.ZERO.compareTo(maxColor) == 0) {
            return HSBType.BLACK;
        }
        BigDecimal multiplier = BIG_DECIMAL_255.divide(maxColor, 0, RoundingMode.DOWN);
        BigDecimal outRed = inRed.divide(multiplier).min(BIG_DECIMAL_255).max(BigDecimal.ZERO);
        BigDecimal outGreen = inGreen.divide(multiplier).min(BIG_DECIMAL_255).max(BigDecimal.ZERO);
        BigDecimal outBlue = inBlue.divide(multiplier).min(BIG_DECIMAL_255).max(BigDecimal.ZERO);
        return HSBType.fromRGB(outRed.intValue(), outGreen.intValue(), outBlue.intValue());
    }

    public static HSBType rgbToHsb(PercentType[] rgb) throws IllegalArgumentException {
        if (rgb.length == 4) {
            return ColorUtil.rgbwToHsb(rgb);
        }
        if (rgb.length != 3) {
            throw new IllegalArgumentException("RGB array needs exactly three values!");
        }
        BigDecimal r = rgb[0].toBigDecimal();
        BigDecimal g = rgb[1].toBigDecimal();
        BigDecimal b = rgb[2].toBigDecimal();
        BigDecimal max = r.max(g).max(b);
        BigDecimal min = r.min(g).min(b);
        BigDecimal span = max.subtract(min);
        if (max.compareTo(BigDecimal.ZERO) == 0) {
            return new HSBType();
        }
        if (span.compareTo(BigDecimal.ZERO) == 0) {
            return new HSBType(new DecimalType(), new PercentType(), new PercentType(max));
        }
        PercentType saturation = new PercentType(span.divide(max, COLOR_MATH_CONTEXT).multiply(BIG_DECIMAL_100));
        PercentType brightness = new PercentType(max);
        BigDecimal scale = span.divide(BIG_DECIMAL_60, COLOR_MATH_CONTEXT);
        BigDecimal redAngle = max.subtract(r).divide(scale, COLOR_MATH_CONTEXT);
        BigDecimal greenAngle = max.subtract(g).divide(scale, COLOR_MATH_CONTEXT);
        BigDecimal blueAngle = max.subtract(b).divide(scale, COLOR_MATH_CONTEXT);
        BigDecimal hue = r.compareTo(max) == 0 ? blueAngle.subtract(greenAngle) : (g.compareTo(max) == 0 ? BIG_DECIMAL_120.add(redAngle).subtract(blueAngle) : BIG_DECIMAL_240.add(greenAngle).subtract(redAngle));
        if (hue.compareTo(BigDecimal.ZERO) < 0) {
            hue = hue.add(BIG_DECIMAL_360);
        } else if (hue.compareTo(BIG_DECIMAL_360) > 0) {
            hue = hue.subtract(BIG_DECIMAL_360);
        }
        return new HSBType(new DecimalType(hue), saturation, brightness);
    }

    public static HSBType xyToHsb(double[] xy) throws IllegalArgumentException {
        return ColorUtil.xyToHsb(xy, DEFAULT_GAMUT);
    }

    public static HSBType xyToHsb(double[] xy, Gamut gamut) throws IllegalArgumentException {
        double max;
        double b;
        double g;
        double z;
        double Z;
        double x;
        double y;
        if (xy.length < 2 || xy.length > 3 || !ColorUtil.inRange(xy[0]) || !ColorUtil.inRange(xy[1]) || xy.length == 3 && !ColorUtil.inRange(xy[2])) {
            throw new IllegalArgumentException("xy array only allows two or three values between 0.0 and 1.0.");
        }
        Point p = gamut.closest(new Point(xy[0], xy[1]));
        double Y = xy.length == 3 ? xy[2] : 1.0;
        double X = Y / (y = p.y == 0.0 ? 1.0E-6 : p.y) * (x = p.x);
        double r = X * 1.656492 + Y * -0.354851 + (Z = Y / y * (z = 1.0 - x - y)) * -0.255038;
        double min = Math.min(r, Math.min(g = X * -0.707196 + Y * 1.655397 + Z * 0.036152, b = X * 0.051713 + Y * -0.121364 + Z * 1.01153));
        if (min < 0.0) {
            r -= min;
            g -= min;
            b -= min;
        }
        if ((max = Math.max(r, Math.max(g, b))) > 1.0) {
            r /= max;
            g /= max;
            b /= max;
        }
        if ((max = Math.max(r = ColorUtil.compand(r), Math.max(g = ColorUtil.compand(g), b = ColorUtil.compand(b)))) > 1.0) {
            r /= max;
            g /= max;
            b /= max;
        }
        LOGGER.trace("xy: {} - XYZ: {} {} {} - RGB: {} {} {}", new Object[]{xy, X, Y, Z, r, g, b});
        return ColorUtil.rgbToHsb(new PercentType[]{ColorUtil.convertDoubleToColorPercent(r), ColorUtil.convertDoubleToColorPercent(g), ColorUtil.convertDoubleToColorPercent(b)});
    }

    private static double inverseCompand(double value) {
        return value > 0.04045 ? Math.pow((value + 0.055) / 1.055, 2.4) : value / 12.92;
    }

    public static double compand(double value) {
        return value <= 0.0031308 ? 12.92 * value : 1.055 * Math.pow(value, 0.4166666666666667) - 0.055;
    }

    private static boolean inByteRange(int val) {
        return val >= 0 && val <= 255;
    }

    private static boolean inRange(double val) {
        return val >= 0.0 && val <= 1.0;
    }

    private static int convertColorPercentToByte(PercentType percent) {
        return percent.toBigDecimal().multiply(BIG_DECIMAL_255).divide(BIG_DECIMAL_100, 0, RoundingMode.HALF_UP).intValue();
    }

    private static PercentType convertByteToColorPercent(int b) {
        return new PercentType(new BigDecimal(b).divide(BIG_DECIMAL_2_POINT_55, COLOR_MATH_CONTEXT));
    }

    private static PercentType convertDoubleToColorPercent(double d) {
        return new PercentType(new BigDecimal(d).multiply(BIG_DECIMAL_100, COLOR_MATH_CONTEXT));
    }

    public record Gamut(double[] r, double[] g, double[] b) {
        public Point closest(Point p) {
            Point r = new Point(this.r[0], this.r[1]);
            Point g = new Point(this.g[0], this.g[1]);
            Point b = new Point(this.b[0], this.b[1]);
            Point v1 = new Point(g.x - r.x, g.y - r.y);
            Point v2 = new Point(b.x - r.x, b.y - r.y);
            Point q = new Point(p.x - r.x, p.y - r.y);
            double v = v1.crossProduct(v2);
            double s = q.crossProduct(v2) / v;
            double t = v1.crossProduct(q) / v;
            if (s >= 0.0 && t >= 0.0 && s + t <= 1.0) {
                return p;
            }
            Point pRG = p.closest(r, g);
            Point pGB = p.closest(g, b);
            Point pBR = p.closest(b, r);
            double dRG = p.distance(pRG);
            double dGB = p.distance(pGB);
            double dBR = p.distance(pBR);
            double min = dRG;
            Point retVal = pRG;
            if (dGB < min) {
                min = dGB;
                retVal = pGB;
            }
            if (dBR < min) {
                retVal = pBR;
            }
            return retVal;
        }
    }

    private static class Point {
        public final double x;
        public final double y;

        public Point() {
            this(0.0, 0.0);
        }

        public Point(double x, double y) {
            this.x = x;
            this.y = y;
        }

        public double distance(Point other) {
            double dx = this.x - other.x;
            double dy = this.y - other.y;
            return Math.sqrt(dx * dx + dy * dy);
        }

        public double crossProduct(Point other) {
            return this.x * other.y - this.y * other.x;
        }

        public Point closest(Point a, Point b) {
            Point ap = new Point(this.x - a.x, this.y - a.y);
            Point ab = new Point(b.x - a.x, b.y - a.y);
            double t = Math.min(1.0, Math.max(0.0, (ap.x * ab.x + ap.y * ab.y) / (ab.x * ab.x + ab.y * ab.y)));
            return new Point(a.x + t * ab.x, a.y + t * ab.y);
        }
    }
}

