/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.types;

import java.math.BigDecimal;
import java.util.Collections;
import java.util.List;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.openhab.core.types.StateOption;

@NonNullByDefault
public class StateDescription {
    protected final @Nullable BigDecimal minimum;
    protected final @Nullable BigDecimal maximum;
    protected final @Nullable BigDecimal step;
    protected final @Nullable String pattern;
    protected final boolean readOnly;
    protected final List<StateOption> options;

    protected StateDescription(@Nullable BigDecimal minimum, @Nullable BigDecimal maximum, @Nullable BigDecimal step, @Nullable String pattern, boolean readOnly, @Nullable List<StateOption> options) {
        this.minimum = minimum;
        this.maximum = maximum;
        this.step = step;
        this.pattern = pattern;
        this.readOnly = readOnly;
        this.options = options == null ? List.of() : Collections.unmodifiableList(options);
    }

    public @Nullable BigDecimal getMinimum() {
        return this.minimum;
    }

    public @Nullable BigDecimal getMaximum() {
        return this.maximum;
    }

    public @Nullable BigDecimal getStep() {
        return this.step;
    }

    public @Nullable String getPattern() {
        return this.pattern;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public List<StateOption> getOptions() {
        return this.options;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.minimum != null ? this.minimum.hashCode() : 0);
        result = 31 * result + (this.maximum != null ? this.maximum.hashCode() : 0);
        result = 31 * result + (this.step != null ? this.step.hashCode() : 0);
        result = 31 * result + (this.pattern != null ? this.pattern.hashCode() : 0);
        result = 31 * result + (this.readOnly ? 1231 : 1237);
        result = 31 * result + this.options.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        StateDescription other = (StateDescription)obj;
        return (this.minimum != null ? this.minimum.equals(other.minimum) : other.minimum == null) && (this.maximum != null ? this.maximum.equals(other.maximum) : other.maximum == null) && (this.step != null ? this.step.equals(other.step) : other.step == null) && (this.pattern != null ? this.pattern.equals(other.pattern) : other.pattern == null) && this.readOnly == other.readOnly && this.options.equals(other.options);
    }

    public String toString() {
        return "StateDescription [minimum=" + this.minimum + ", maximum=" + this.maximum + ", step=" + this.step + ", pattern=" + this.pattern + ", readOnly=" + this.readOnly + ", channelStateOptions=" + this.options + "]";
    }
}

