/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.service;

import java.util.AbstractMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.openhab.core.common.NamedThreadFactory;
import org.openhab.core.events.EventPublisher;
import org.openhab.core.events.system.StartlevelEvent;
import org.openhab.core.events.system.SystemEventFactory;
import org.openhab.core.internal.common.WrappedScheduledExecutorService;
import org.openhab.core.service.ReadyMarker;
import org.openhab.core.service.ReadyMarkerFilter;
import org.openhab.core.service.ReadyService;
import org.osgi.framework.BundleContext;
import org.osgi.framework.startlevel.FrameworkStartLevel;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NonNullByDefault
@Component(immediate=true, service={StartLevelService.class}, configurationPid={"org.openhab.startlevel"}, configurationPolicy=ConfigurationPolicy.REQUIRE)
public class StartLevelService {
    public static final String STARTLEVEL_MARKER_TYPE = "startlevel";
    public static final int STARTLEVEL_OSGI = 10;
    public static final int STARTLEVEL_MODEL = 20;
    public static final int STARTLEVEL_STATES = 30;
    public static final int STARTLEVEL_RULES = 40;
    public static final int STARTLEVEL_RULEENGINE = 50;
    public static final int STARTLEVEL_UI = 70;
    public static final int STARTLEVEL_THINGS = 80;
    public static final int STARTLEVEL_COMPLETE = 100;
    private final Logger logger = LoggerFactory.getLogger(StartLevelService.class);
    private final BundleContext bundleContext;
    private final ReadyService readyService;
    private final EventPublisher eventPublisher;
    private final Set<ReadyMarker> markers = ConcurrentHashMap.newKeySet();
    private final Map<String, ReadyService.ReadyTracker> trackers = new ConcurrentHashMap<String, ReadyService.ReadyTracker>();
    private final Map<Integer, ReadyMarker> slmarker = new ConcurrentHashMap<Integer, ReadyMarker>();
    private @Nullable ScheduledFuture<?> job;
    private final ScheduledExecutorService scheduler = new WrappedScheduledExecutorService(1, new NamedThreadFactory("startlevel"));
    private int openHABStartLevel = 0;
    private Map<Integer, Set<ReadyMarker>> startlevels = Map.of();

    @Activate
    public StartLevelService(BundleContext bundleContext, @Reference ReadyService readyService, @Reference EventPublisher eventPublisher) {
        this.bundleContext = bundleContext;
        this.readyService = readyService;
        this.eventPublisher = eventPublisher;
    }

    @Activate
    protected void activate(Map<String, Object> configuration) {
        this.modified(configuration);
        this.job = this.scheduler.scheduleWithFixedDelay(() -> {
            this.handleOSGiStartlevel();
            if (this.openHABStartLevel >= 10) {
                for (Integer level : new TreeSet<Integer>(this.startlevels.keySet())) {
                    if (this.openHABStartLevel >= level) continue;
                    boolean reached = this.isStartLevelReached(this.startlevels.get(level));
                    if (reached) {
                        this.setStartLevel(level);
                        continue;
                    }
                    return;
                }
                if (this.openHABStartLevel < 100) {
                    this.setStartLevel(100);
                }
            }
        }, 0L, 5L, TimeUnit.SECONDS);
    }

    public int getStartLevel() {
        return this.openHABStartLevel;
    }

    private boolean isStartLevelReached(@Nullable Set<ReadyMarker> markerSet) {
        if (markerSet == null) {
            return true;
        }
        for (ReadyMarker m : markerSet) {
            if (this.markers.contains(m)) continue;
            return false;
        }
        return true;
    }

    private void handleOSGiStartlevel() {
        FrameworkStartLevel sl = (FrameworkStartLevel)this.bundleContext.getBundle(0L).adapt(FrameworkStartLevel.class);
        int defaultStartLevel = sl.getInitialBundleStartLevel();
        int startLevel = sl.getStartLevel();
        if (startLevel >= defaultStartLevel && this.openHABStartLevel < 10) {
            this.setStartLevel(10);
        } else if (startLevel < defaultStartLevel && this.openHABStartLevel >= 10) {
            this.setStartLevel(0);
        }
    }

    @Modified
    protected void modified(Map<String, Object> configuration) {
        this.slmarker.clear();
        this.trackers.values().forEach(this.readyService::unregisterTracker);
        this.trackers.clear();
        this.startlevels = this.parseConfig(configuration);
        this.startlevels.keySet().forEach(sl -> {
            ReadyMarker readyMarker = this.slmarker.put((Integer)sl, new ReadyMarker(STARTLEVEL_MARKER_TYPE, Integer.toString(sl)));
        });
        this.slmarker.put(100, new ReadyMarker(STARTLEVEL_MARKER_TYPE, Integer.toString(100)));
        this.startlevels.values().stream().forEach(ms -> ms.forEach(this::registerTracker));
    }

    private void registerTracker(ReadyMarker e) {
        String type = e.getType();
        if (!this.trackers.containsKey(type)) {
            ReadyService.ReadyTracker tracker = new ReadyService.ReadyTracker(){

                @Override
                public void onReadyMarkerRemoved(ReadyMarker readyMarker) {
                    StartLevelService.this.markers.remove(readyMarker);
                }

                @Override
                public void onReadyMarkerAdded(ReadyMarker readyMarker) {
                    StartLevelService.this.markers.add(readyMarker);
                }
            };
            this.readyService.registerTracker(tracker, new ReadyMarkerFilter().withType(type));
            this.trackers.put(type, tracker);
        }
    }

    private Map<Integer, Set<ReadyMarker>> parseConfig(Map<String, Object> configuration) {
        return configuration.entrySet().stream().filter(this::hasIntegerKey).map(e -> new AbstractMap.SimpleEntry<Integer, Set<ReadyMarker>>(Integer.valueOf((String)e.getKey()), this.markerSet(e.getValue()))).sorted(Map.Entry.comparingByKey().reversed()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (e1, e2) -> e1, LinkedHashMap::new));
    }

    private Set<ReadyMarker> markerSet(Object value) {
        HashSet<ReadyMarker> markerSet = new HashSet<ReadyMarker>();
        if (value instanceof String var3_4) {
            String[] stringArray = segments = string.split(",");
            int n = segments.length;
            int n2 = 0;
            while (n2 < n) {
                String segment = stringArray[n2];
                if (segment.contains(":")) {
                    String[] markerParts = segment.strip().split(":");
                    markerSet.add(new ReadyMarker(markerParts[0], markerParts[1]));
                } else {
                    this.logger.warn("Ignoring invalid configuration value '{}'", value);
                }
                ++n2;
            }
        }
        return markerSet;
    }

    private boolean hasIntegerKey(Map.Entry<String, Object> entry) {
        try {
            Integer.valueOf(entry.getKey());
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    @Deactivate
    protected void deactivate() {
        this.slmarker.clear();
        this.trackers.values().forEach(this.readyService::unregisterTracker);
        ScheduledFuture<?> job = this.job;
        if (job != null) {
            job.cancel(true);
        }
    }

    private void setStartLevel(int level) {
        ReadyMarker marker = this.slmarker.get(level);
        if (marker != null) {
            this.readyService.markReady(marker);
        }
        this.openHABStartLevel = level;
        this.scheduler.submit(() -> {
            StartlevelEvent startlevelEvent = SystemEventFactory.createStartlevelEvent(level);
            this.eventPublisher.post(startlevelEvent);
            this.logger.debug("Reached start level {}", (Object)level);
        });
    }
}

