/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.net;

import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InterfaceAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.openhab.core.common.SafeCaller;
import org.openhab.core.common.ThreadPoolManager;
import org.openhab.core.net.CidrAddress;
import org.openhab.core.net.NetworkAddressChangeListener;
import org.openhab.core.net.NetworkAddressService;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(configurationPid={"org.openhab.network"}, property={"service.pid=org.openhab.network", "service.config.description.uri=system:network", "service.config.label=Network Settings", "service.config.category=system"})
@NonNullByDefault
public class NetUtil
implements NetworkAddressService {
    private static final String PRIMARY_ADDRESS = "primaryAddress";
    private static final String BROADCAST_ADDRESS = "broadcastAddress";
    private static final String POLL_INTERVAL = "pollInterval";
    private static final String USE_ONLY_ONE_ADDRESS = "useOnlyOneAddress";
    private static final String USE_IPV6 = "useIPv6";
    private static final Logger LOGGER = LoggerFactory.getLogger(NetUtil.class);
    public static final int POLL_INTERVAL_SECONDS = 60;
    private static final Pattern IPV4_PATTERN = Pattern.compile("^(([01]?\\d\\d?|2[0-4]\\d|25[0-5])\\.){3}([01]?\\d\\d?|2[0-4]\\d|25[0-5])$");
    private @Nullable String primaryAddress;
    private @Nullable String configuredBroadcastAddress;
    private boolean useOnlyOneAddress;
    private boolean useIPv6;
    private Set<NetworkAddressChangeListener> networkAddressChangeListeners = ConcurrentHashMap.newKeySet();
    private Collection<CidrAddress> lastKnownInterfaceAddresses = List.of();
    private final ScheduledExecutorService scheduledExecutorService = ThreadPoolManager.getScheduledPool("common");
    private @Nullable ScheduledFuture<?> networkInterfacePollFuture = null;
    private final SafeCaller safeCaller;

    @Activate
    public NetUtil(@Reference SafeCaller safeCaller) {
        this.safeCaller = safeCaller;
    }

    @Activate
    protected void activate(Map<String, Object> props) {
        this.lastKnownInterfaceAddresses = List.of();
        this.modified(props);
    }

    @Deactivate
    protected void deactivate() {
        this.lastKnownInterfaceAddresses = List.of();
        this.networkAddressChangeListeners = ConcurrentHashMap.newKeySet();
        if (this.networkInterfacePollFuture != null) {
            this.networkInterfacePollFuture.cancel(true);
            this.networkInterfacePollFuture = null;
        }
    }

    @Modified
    public synchronized void modified(Map<String, Object> config) {
        String primaryAddressConf = (String)config.get(PRIMARY_ADDRESS);
        String oldPrimaryAddress = this.primaryAddress;
        this.primaryAddress = primaryAddressConf == null || primaryAddressConf.isEmpty() || !NetUtil.isValidIPConfig(primaryAddressConf) ? this.getFirstLocalIPv4Address() : primaryAddressConf;
        this.notifyPrimaryAddressChange(oldPrimaryAddress, this.primaryAddress);
        String broadcastAddressConf = (String)config.get(BROADCAST_ADDRESS);
        this.configuredBroadcastAddress = broadcastAddressConf == null || broadcastAddressConf.isEmpty() || !NetUtil.isValidIPConfig(broadcastAddressConf) ? this.getPrimaryBroadcastAddress() : broadcastAddressConf;
        this.useOnlyOneAddress = this.getConfigParameter(config, USE_ONLY_ONE_ADDRESS, false);
        this.useIPv6 = this.getConfigParameter(config, USE_IPV6, true);
        Object pollIntervalSecondsObj = null;
        int pollIntervalSeconds = 60;
        try {
            pollIntervalSecondsObj = config.get(POLL_INTERVAL);
            if (pollIntervalSecondsObj != null) {
                pollIntervalSeconds = Integer.parseInt(pollIntervalSecondsObj.toString());
            }
        }
        catch (NumberFormatException e) {
            LOGGER.warn("Cannot parse value {} from key {}, will use default {}", new Object[]{pollIntervalSecondsObj, POLL_INTERVAL, pollIntervalSeconds});
        }
        this.scheduleToPollNetworkInterface(pollIntervalSeconds);
    }

    @Override
    public @Nullable String getPrimaryIpv4HostAddress() {
        String primaryIP;
        if (this.primaryAddress != null) {
            String[] addrString = this.primaryAddress.split("/");
            if (addrString.length > 1) {
                String ip = this.getIPv4inSubnet(addrString[0], addrString[1]);
                if (ip == null) {
                    LOGGER.warn("Invalid address '{}', will use first interface instead.", (Object)this.primaryAddress);
                    primaryIP = this.getFirstLocalIPv4Address();
                } else {
                    primaryIP = ip;
                }
            } else {
                primaryIP = addrString[0];
            }
        } else {
            primaryIP = null;
        }
        return primaryIP;
    }

    @Override
    public boolean isUseOnlyOneAddress() {
        return this.useOnlyOneAddress;
    }

    @Override
    public boolean isUseIPv6() {
        return this.useIPv6;
    }

    @Override
    public void addNetworkAddressChangeListener(NetworkAddressChangeListener listener) {
        this.networkAddressChangeListeners.add(listener);
    }

    @Override
    public void removeNetworkAddressChangeListener(NetworkAddressChangeListener listener) {
        this.networkAddressChangeListeners.remove(listener);
    }

    private @Nullable String getFirstLocalIPv4Address() {
        try {
            String hostAddress = null;
            Enumeration<NetworkInterface> interfaces = NetworkInterface.getNetworkInterfaces();
            while (interfaces.hasMoreElements()) {
                NetworkInterface current = interfaces.nextElement();
                if (!current.isUp() || current.isLoopback() || current.isVirtual() || current.isPointToPoint()) continue;
                Enumeration<InetAddress> addresses = current.getInetAddresses();
                while (addresses.hasMoreElements()) {
                    InetAddress currentAddr = addresses.nextElement();
                    if (currentAddr.isLoopbackAddress() || currentAddr instanceof Inet6Address) continue;
                    if (hostAddress != null) {
                        LOGGER.warn("Found multiple local interfaces - ignoring {}", (Object)currentAddr.getHostAddress());
                        continue;
                    }
                    hostAddress = currentAddr.getHostAddress();
                }
            }
            return hostAddress;
        }
        catch (SocketException ex) {
            LOGGER.error("Could not retrieve network interface: {}", (Object)ex.getMessage(), (Object)ex);
            return null;
        }
    }

    public static List<String> getAllBroadcastAddresses() {
        LinkedList<String> broadcastAddresses = new LinkedList<String>();
        try {
            Enumeration<NetworkInterface> networkInterfaces = NetworkInterface.getNetworkInterfaces();
            while (networkInterfaces.hasMoreElements()) {
                NetworkInterface networkInterface = networkInterfaces.nextElement();
                List<InterfaceAddress> interfaceAddresses = networkInterface.getInterfaceAddresses();
                for (InterfaceAddress interfaceAddress : interfaceAddresses) {
                    InetAddress broadcast;
                    InetAddress addr = interfaceAddress.getAddress();
                    if (!(addr instanceof Inet4Address) || addr.isLinkLocalAddress() || addr.isLoopbackAddress() || (broadcast = interfaceAddress.getBroadcast()) == null) continue;
                    broadcastAddresses.add(broadcast.getHostAddress());
                }
            }
        }
        catch (SocketException ex) {
            LOGGER.error("Could not find broadcast address: {}", (Object)ex.getMessage(), (Object)ex);
        }
        return broadcastAddresses;
    }

    @Override
    public @Nullable String getConfiguredBroadcastAddress() {
        String broadcastAddr = this.configuredBroadcastAddress != null ? this.configuredBroadcastAddress : null;
        return broadcastAddr;
    }

    private @Nullable String getPrimaryBroadcastAddress() {
        String primaryIp = this.getPrimaryIpv4HostAddress();
        String broadcastAddress = null;
        if (primaryIp != null) {
            try {
                Short prefix = NetUtil.getAllInterfaceAddresses().stream().filter(a -> a.getAddress().getHostAddress().equals(primaryIp)).map(CidrAddress::getPrefix).findFirst().get().shortValue();
                broadcastAddress = NetUtil.getIpv4NetBroadcastAddress(primaryIp, prefix);
            }
            catch (IllegalArgumentException ex) {
                LOGGER.error("Invalid IP address parameter: {}", (Object)ex.getMessage(), (Object)ex);
            }
        }
        if (broadcastAddress == null) {
            broadcastAddress = NetUtil.getFirstIpv4BroadcastAddress();
            LOGGER.warn("Could not find broadcast address of primary IP, using broadcast address {} of first interface instead", (Object)broadcastAddress);
        }
        return broadcastAddress;
    }

    private static @Nullable String getFirstIpv4BroadcastAddress() {
        List<String> broadcastAddresses = NetUtil.getAllBroadcastAddresses();
        if (!broadcastAddresses.isEmpty()) {
            return broadcastAddresses.get(0);
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    public static Collection<CidrAddress> getAllInterfaceAddresses() {
        interfaceIPs = new ArrayList<CidrAddress>();
        try {
            en = NetworkInterface.getNetworkInterfaces();
            if (true) ** GOTO lbl24
        }
        catch (SocketException ex) {
            NetUtil.LOGGER.error("Could not find interface IP addresses: {}", (Object)ex.getMessage(), (Object)ex);
            return interfaceIPs;
        }
        do {
            networkInterface = en.nextElement();
            try {
                if (!networkInterface.isUp()) continue;
                if (networkInterface.isLoopback()) {
                }
            }
            catch (SocketException ignored) {}
            continue;
            for (InterfaceAddress cidr : networkInterface.getInterfaceAddresses()) {
                address = cidr.getAddress();
                if (!NetUtil.$assertionsDisabled && address == null) {
                    throw new AssertionError();
                }
                interfaceIPs.add(new CidrAddress(address, cidr.getNetworkPrefixLength()));
            }
lbl24:
            // 5 sources

        } while (en.hasMoreElements());
        return interfaceIPs;
    }

    public static String networkPrefixLengthToNetmask(int prefixLength) {
        if (prefixLength > 32 || prefixLength < 1) {
            throw new IllegalArgumentException("Network prefix length is not within bounds");
        }
        int ipv4Netmask = -1;
        byte[] octets = new byte[]{(byte)((ipv4Netmask <<= 32 - prefixLength) >>> 24), (byte)(ipv4Netmask >>> 16), (byte)(ipv4Netmask >>> 8), (byte)ipv4Netmask};
        String result = "";
        int i = 0;
        while (i < 4) {
            result = String.valueOf(result) + (octets[i] & 0xFF);
            if (i < 3) {
                result = String.valueOf(result) + ".";
            }
            ++i;
        }
        return result;
    }

    public static String getIpv4NetAddress(String ipAddressString, short netMask) {
        String errorString = "IP '" + ipAddressString + "' is not a valid IPv4 address";
        if (!NetUtil.isValidIPConfig(ipAddressString)) {
            throw new IllegalArgumentException(errorString);
        }
        if (netMask < 1 || netMask > 32) {
            throw new IllegalArgumentException("Netmask '" + netMask + "' is out of bounds (1-32)");
        }
        String subnetMaskString = NetUtil.networkPrefixLengthToNetmask(netMask);
        String[] netMaskOctets = subnetMaskString.split("\\.");
        String[] ipv4AddressOctets = ipAddressString.split("\\.");
        String netAddress = "";
        try {
            int i = 0;
            while (i < 4) {
                netAddress = String.valueOf(netAddress) + (Integer.parseInt(ipv4AddressOctets[i]) & Integer.parseInt(netMaskOctets[i]));
                if (i < 3) {
                    netAddress = String.valueOf(netAddress) + ".";
                }
                ++i;
            }
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException(errorString);
        }
        return netAddress;
    }

    public static String getIpv4NetBroadcastAddress(String ipAddressString, short prefix) {
        String errorString = "IP '" + ipAddressString + "' is not a valid IPv4 address";
        if (!NetUtil.isValidIPConfig(ipAddressString)) {
            throw new IllegalArgumentException(errorString);
        }
        if (prefix < 1 || prefix > 32) {
            throw new IllegalArgumentException("Prefix '" + prefix + "' is out of bounds (1-32)");
        }
        try {
            byte[] addr = InetAddress.getByName(ipAddressString).getAddress();
            byte[] netmask = InetAddress.getByName(NetUtil.networkPrefixLengthToNetmask(prefix)).getAddress();
            byte[] broadcast = new byte[]{(byte)(~netmask[0] | addr[0]), (byte)(~netmask[1] | addr[1]), (byte)(~netmask[2] | addr[2]), (byte)(~netmask[3] | addr[3])};
            return InetAddress.getByAddress(broadcast).getHostAddress();
        }
        catch (UnknownHostException ex) {
            throw new IllegalArgumentException(errorString);
        }
    }

    private @Nullable String getIPv4inSubnet(String ipAddress, String subnetMask) {
        try {
            Enumeration<NetworkInterface> interfaces = NetworkInterface.getNetworkInterfaces();
            while (interfaces.hasMoreElements()) {
                NetworkInterface current = interfaces.nextElement();
                if (!current.isUp() || current.isLoopback() || current.isVirtual() || current.isPointToPoint()) continue;
                for (InterfaceAddress ifAddr : current.getInterfaceAddresses()) {
                    String configuredSubnetString;
                    String ipv4AddressOnInterface;
                    String subnetStringOnInterface;
                    InetAddress addr = ifAddr.getAddress();
                    if (addr.isLoopbackAddress() || addr instanceof Inet6Address || !(subnetStringOnInterface = String.valueOf(NetUtil.getIpv4NetAddress(ipv4AddressOnInterface = addr.getHostAddress(), ifAddr.getNetworkPrefixLength())) + "/" + ifAddr.getNetworkPrefixLength()).equals(configuredSubnetString = String.valueOf(NetUtil.getIpv4NetAddress(ipAddress, Short.parseShort(subnetMask))) + "/" + subnetMask)) continue;
                    return ipv4AddressOnInterface;
                }
            }
        }
        catch (SocketException ex) {
            LOGGER.error("Could not retrieve network interface: {}", (Object)ex.getMessage(), (Object)ex);
        }
        return null;
    }

    public static boolean isValidIPConfig(String ipAddress) {
        if (ipAddress.contains("/")) {
            String[] parts = ipAddress.split("/");
            boolean ipMatches = IPV4_PATTERN.matcher(parts[0]).matches();
            int netMask = Integer.parseInt(parts[1]);
            boolean netMaskMatches = false;
            if (netMask > 0 || netMask < 32) {
                netMaskMatches = true;
            }
            return ipMatches && netMaskMatches;
        }
        return IPV4_PATTERN.matcher(ipAddress).matches();
    }

    private void scheduleToPollNetworkInterface(int intervalInSeconds) {
        if (this.networkInterfacePollFuture != null) {
            this.networkInterfacePollFuture.cancel(true);
            this.networkInterfacePollFuture = null;
        }
        this.networkInterfacePollFuture = this.scheduledExecutorService.scheduleWithFixedDelay(this::pollAndNotifyNetworkInterfaceAddress, 1L, intervalInSeconds, TimeUnit.SECONDS);
    }

    private void pollAndNotifyNetworkInterfaceAddress() {
        Collection<CidrAddress> newInterfaceAddresses = NetUtil.getAllInterfaceAddresses();
        if (this.networkAddressChangeListeners.isEmpty()) {
            this.lastKnownInterfaceAddresses = newInterfaceAddresses;
            return;
        }
        List<CidrAddress> added = newInterfaceAddresses.stream().filter(newInterfaceAddr -> !this.lastKnownInterfaceAddresses.contains(newInterfaceAddr)).toList();
        List<CidrAddress> removed = this.lastKnownInterfaceAddresses.stream().filter(lastKnownInterfaceAddr -> !newInterfaceAddresses.contains(lastKnownInterfaceAddr)).toList();
        this.lastKnownInterfaceAddresses = newInterfaceAddresses;
        if (!added.isEmpty() || !removed.isEmpty()) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("added {} network interfaces: {}", (Object)added.size(), (Object)Arrays.deepToString(added.toArray()));
                LOGGER.debug("removed {} network interfaces: {}", (Object)removed.size(), (Object)Arrays.deepToString(removed.toArray()));
            }
            this.notifyListeners(added, removed);
        }
    }

    private void notifyListeners(List<CidrAddress> added, List<CidrAddress> removed) {
        List<CidrAddress> unmodifiableAddedList = Collections.unmodifiableList(added);
        List<CidrAddress> unmodifiableRemovedList = Collections.unmodifiableList(removed);
        for (NetworkAddressChangeListener listener : this.networkAddressChangeListeners) {
            NetworkAddressChangeListener safeListener = this.safeCaller.create(listener, NetworkAddressChangeListener.class).withTimeout(15000L).onException(exception -> LOGGER.debug("NetworkAddressChangeListener exception", exception)).build();
            safeListener.onChanged(unmodifiableAddedList, unmodifiableRemovedList);
        }
    }

    private void notifyPrimaryAddressChange(@Nullable String oldPrimaryAddress, @Nullable String newPrimaryAddress) {
        if (!Objects.equals(oldPrimaryAddress, newPrimaryAddress)) {
            for (NetworkAddressChangeListener listener : this.networkAddressChangeListeners) {
                NetworkAddressChangeListener safeListener = this.safeCaller.create(listener, NetworkAddressChangeListener.class).withTimeout(15000L).onException(exception -> LOGGER.debug("NetworkAddressChangeListener exception", exception)).build();
                safeListener.onPrimaryAddressChanged(oldPrimaryAddress, newPrimaryAddress);
            }
        }
    }

    private boolean getConfigParameter(Map<String, Object> parameters, String parameter, boolean defaultValue) {
        if (parameters == null) {
            return defaultValue;
        }
        Object value = parameters.get(parameter);
        if (value == null) {
            return defaultValue;
        }
        if (value instanceof Boolean var5_6) {
            return boolean1.booleanValue();
        }
        if (value instanceof String var7_8) {
            return Boolean.valueOf((String)string);
        }
        return defaultValue;
    }
}

