/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.library.types;

import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParsePosition;
import java.time.Instant;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.IllegalFormatConversionException;
import java.util.Locale;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import javax.measure.Dimension;
import javax.measure.IncommensurableException;
import javax.measure.Quantity;
import javax.measure.UnconvertibleException;
import javax.measure.Unit;
import javax.measure.UnitConverter;
import javax.measure.format.MeasurementParseException;
import javax.measure.format.UnitFormat;
import javax.measure.quantity.Dimensionless;
import org.eclipse.jdt.annotation.DefaultLocation;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.openhab.core.internal.library.unit.UnitInitializer;
import org.openhab.core.library.types.DecimalType;
import org.openhab.core.library.types.HSBType;
import org.openhab.core.library.types.OnOffType;
import org.openhab.core.library.types.OpenClosedType;
import org.openhab.core.library.types.PercentType;
import org.openhab.core.library.types.UpDownType;
import org.openhab.core.library.unit.MetricPrefix;
import org.openhab.core.library.unit.Units;
import org.openhab.core.types.Command;
import org.openhab.core.types.PrimitiveType;
import org.openhab.core.types.State;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tech.units.indriya.AbstractUnit;
import tech.units.indriya.ComparableQuantity;
import tech.units.indriya.format.NumberDelimiterQuantityFormat;
import tech.units.indriya.format.SimpleUnitFormat;
import tech.units.indriya.quantity.Quantities;
import tech.uom.lib.common.function.QuantityFunctions;

@NonNullByDefault(value={DefaultLocation.PARAMETER, DefaultLocation.RETURN_TYPE, DefaultLocation.FIELD, DefaultLocation.TYPE_ARGUMENT})
public class QuantityType<T extends Quantity<T>>
extends Number
implements PrimitiveType,
State,
Command,
Comparable<QuantityType<T>> {
    private static final long serialVersionUID = 8828949721938234629L;
    private static final BigDecimal BIG_DECIMAL_HUNDRED = BigDecimal.valueOf(100L);
    public static final QuantityType<Dimensionless> ZERO = new QuantityType(0, AbstractUnit.ONE);
    public static final QuantityType<Dimensionless> ONE = new QuantityType(1, AbstractUnit.ONE);
    private static final Pattern UNIT_PATTERN = Pattern.compile("\\s+|(?<=\\d)(?=\\D(?![+\\-]?\\d))");
    private final transient Logger logger = LoggerFactory.getLogger(QuantityType.class);
    private final Quantity<T> quantity;

    static {
        UnitInitializer.init();
    }

    public QuantityType() {
        this.quantity = QuantityType.ZERO.quantity;
    }

    public QuantityType(String value) {
        this(value, Locale.ENGLISH);
    }

    public QuantityType(String value, Locale locale) {
        String formatted;
        CharSequence[] constituents = UNIT_PATTERN.split(value);
        if (constituents.length > 0) {
            constituents[0] = ((String)constituents[0]).toUpperCase(locale);
        }
        if (!(formatted = String.join((CharSequence)" ", constituents)).contains(" ")) {
            DecimalFormat df = (DecimalFormat)NumberFormat.getInstance(locale);
            df.setParseBigDecimal(true);
            ParsePosition position = new ParsePosition(0);
            BigDecimal parsedValue = (BigDecimal)df.parseObject(formatted, position);
            if (parsedValue == null || position.getErrorIndex() != -1 || position.getIndex() < value.length()) {
                throw new NumberFormatException("Invalid BigDecimal value: " + value);
            }
            this.quantity = Quantities.getQuantity((Number)parsedValue, (Unit)AbstractUnit.ONE, (Quantity.Scale)Quantity.Scale.RELATIVE);
        } else {
            SimpleUnitFormat unitFormat = SimpleUnitFormat.getInstance();
            NumberDelimiterQuantityFormat quantityFormat = new NumberDelimiterQuantityFormat.Builder().setNumberFormat(NumberFormat.getInstance(locale)).setUnitFormat((UnitFormat)unitFormat).setLocaleSensitive(true).build();
            ParsePosition position = new ParsePosition(0);
            try {
                Quantity absoluteQuantity = quantityFormat.parse((CharSequence)formatted, position);
                Unit unit = absoluteQuantity.getUnit();
                if (!(position.getErrorIndex() == -1 && position.getIndex() >= value.length() || unit.equals(unitFormat.parse((CharSequence)value.substring(position.getIndex()).trim())))) {
                    throw new IllegalArgumentException("Invalid Quantity value: " + value);
                }
                this.quantity = Quantities.getQuantity((Number)absoluteQuantity.getValue(), (Unit)absoluteQuantity.getUnit(), (Quantity.Scale)Quantity.Scale.RELATIVE);
            }
            catch (MeasurementParseException e) {
                throw new IllegalArgumentException("Invalid Quantity value: " + value, e);
            }
        }
    }

    public QuantityType(Number value, Unit<T> unit) {
        BigDecimal bd = new BigDecimal(value.toString());
        this.quantity = Quantities.getQuantity((Number)bd, unit, (Quantity.Scale)Quantity.Scale.RELATIVE);
    }

    private QuantityType(Quantity<T> quantity) {
        this.quantity = Quantities.getQuantity((Number)quantity.getValue(), (Unit)quantity.getUnit(), (Quantity.Scale)Quantity.Scale.RELATIVE);
    }

    public static <T extends Quantity<T>> QuantityType<T> valueOf(double value, Unit<T> unit) {
        return new QuantityType<T>(value, unit);
    }

    public String toString() {
        return this.toFullString();
    }

    public static QuantityType<? extends Quantity<?>> valueOf(String value) {
        return new QuantityType(value);
    }

    /*
     * WARNING - void declaration
     */
    public boolean equals(@Nullable Object obj) {
        void other;
        void var3_2;
        QuantityType quantityType;
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        Object object = obj;
        if (!(object instanceof QuantityType) || (quantityType = (QuantityType)object) != (QuantityType)var3_2) {
            return false;
        }
        if (!this.quantity.getUnit().isCompatible(other.quantity.getUnit()) && !this.quantity.getUnit().inverse().isCompatible(other.quantity.getUnit())) {
            return false;
        }
        return this.internalCompareTo((QuantityType<?>)other) == 0;
    }

    @Override
    public int compareTo(QuantityType<T> o) {
        return this.internalCompareTo(o);
    }

    private int internalCompareTo(QuantityType<?> o) {
        if (this.quantity.getUnit().isCompatible(o.quantity.getUnit())) {
            QuantityType<T> v1 = this.toUnit(this.getUnit().getSystemUnit());
            QuantityType<?> v2 = o.toUnit(o.getUnit().getSystemUnit());
            if (v1 != null && v2 != null) {
                return Double.compare(v1.doubleValue(), v2.doubleValue());
            }
            throw new IllegalArgumentException("Unable to convert to system unit during compare.");
        }
        if (this.quantity.getUnit().inverse().isCompatible(o.quantity.getUnit())) {
            return this.inverse().internalCompareTo(o);
        }
        throw new IllegalArgumentException("Can not compare incompatible units.");
    }

    public Unit<T> getUnit() {
        return this.quantity.getUnit();
    }

    public Dimension getDimension() {
        return this.getUnit().getDimension();
    }

    public @Nullable QuantityType<T> toUnit(Unit<?> targetUnit) {
        if (!targetUnit.equals(this.getUnit())) {
            try {
                UnitConverter uc = this.getUnit().getConverterToAny(targetUnit);
                ComparableQuantity result = Quantities.getQuantity((Number)uc.convert(this.quantity.getValue()), targetUnit);
                return new QuantityType(result.getValue(), targetUnit);
            }
            catch (IncommensurableException | UnconvertibleException e) {
                this.logger.debug("Unable to convert unit from {} to {}", this.getUnit(), targetUnit);
                return null;
            }
        }
        return this;
    }

    public @Nullable QuantityType<T> toUnit(String targetUnit) {
        Unit unit = AbstractUnit.parse((CharSequence)targetUnit);
        if (unit != null) {
            return this.toUnit(unit);
        }
        return null;
    }

    public @Nullable QuantityType<?> toInvertibleUnit(Unit<?> targetUnit) {
        if (!targetUnit.equals(this.getUnit()) && !targetUnit.isCompatible(AbstractUnit.ONE) && this.getUnit().inverse().isCompatible(targetUnit)) {
            return this.inverse().toUnit(targetUnit);
        }
        return this.toUnit(targetUnit);
    }

    public @Nullable QuantityType<?> toInvertibleUnit(String targetUnit) {
        Unit unit = AbstractUnit.parse((CharSequence)targetUnit);
        if (unit != null) {
            return this.toInvertibleUnit(unit);
        }
        return null;
    }

    public @Nullable QuantityType<T> toUnitRelative(Unit<T> targetUnit) {
        if (targetUnit.equals(this.getUnit())) {
            return this;
        }
        if (!this.quantity.getUnit().isCompatible(targetUnit)) {
            return null;
        }
        Quantity result = this.quantity.to(targetUnit);
        return new QuantityType<T>(result.getValue(), targetUnit);
    }

    public @Nullable QuantityType<T> toUnitRelative(String targetUnit) {
        Unit unit = AbstractUnit.parse((CharSequence)targetUnit);
        if (unit != null) {
            return this.toUnitRelative(unit);
        }
        return null;
    }

    public BigDecimal toBigDecimal() {
        return new BigDecimal(this.quantity.getValue().toString());
    }

    public int hashCode() {
        int prime = 31;
        int tmp = 31 * this.getUnit().hashCode();
        return tmp += 31 * (this.quantity.getValue() == null ? 0 : this.quantity.getValue().hashCode());
    }

    @Override
    public String format(String pattern) {
        QuantityType<T> millis;
        String formatPattern;
        boolean unitPlaceholder = pattern.contains("%unit%");
        if (unitPlaceholder) {
            String unitSymbol = this.getUnit().equals(Units.PERCENT) ? "%%" : this.getUnit().toString();
            formatPattern = pattern.replace("%unit%", unitSymbol);
        } else {
            formatPattern = pattern;
        }
        if (this.quantity.getUnit().isCompatible(Units.SECOND) && !unitPlaceholder && (millis = this.toUnit(MetricPrefix.MILLI(Units.SECOND))) != null) {
            try {
                return String.format(formatPattern, ZonedDateTime.ofInstant(Instant.ofEpochMilli(millis.longValue()), ZoneOffset.UTC));
            }
            catch (IllegalFormatConversionException illegalFormatConversionException) {
                // empty catch block
            }
        }
        BigDecimal bd = this.toBigDecimal();
        try {
            return String.format(formatPattern, bd.toBigIntegerExact());
        }
        catch (ArithmeticException arithmeticException) {
        }
        catch (IllegalFormatConversionException illegalFormatConversionException) {
            // empty catch block
        }
        return String.format(formatPattern, bd);
    }

    @Override
    public int intValue() {
        return this.quantity.getValue().intValue();
    }

    @Override
    public long longValue() {
        return this.quantity.getValue().longValue();
    }

    @Override
    public float floatValue() {
        return this.quantity.getValue().floatValue();
    }

    @Override
    public double doubleValue() {
        return this.quantity.getValue().doubleValue();
    }

    @Override
    public String toFullString() {
        if (AbstractUnit.ONE.equals(this.quantity.getUnit())) {
            return this.quantity.getValue().toString();
        }
        return this.quantity.toString();
    }

    public <U extends State> @Nullable U as(@Nullable Class<U> target) {
        if (target == OnOffType.class) {
            if (this.intValue() == 0) {
                return (U)((State)target.cast(OnOffType.OFF));
            }
            if (Units.PERCENT.equals(this.getUnit())) {
                return (U)((State)target.cast(this.toBigDecimal().compareTo(BigDecimal.ZERO) > 0 ? OnOffType.ON : OnOffType.OFF));
            }
            if (this.toBigDecimal().compareTo(BigDecimal.ONE) == 0) {
                return (U)((State)target.cast(OnOffType.ON));
            }
            return null;
        }
        if (target == UpDownType.class) {
            if (this.doubleValue() == 0.0) {
                return (U)((State)target.cast(UpDownType.UP));
            }
            if (this.toBigDecimal().compareTo(BigDecimal.ONE) == 0) {
                return (U)((State)target.cast(UpDownType.DOWN));
            }
            return null;
        }
        if (target == OpenClosedType.class) {
            if (this.doubleValue() == 0.0) {
                return (U)((State)target.cast(OpenClosedType.CLOSED));
            }
            if (this.toBigDecimal().compareTo(BigDecimal.ONE) == 0) {
                return (U)((State)target.cast(OpenClosedType.OPEN));
            }
            return null;
        }
        if (target == HSBType.class) {
            return (U)((State)target.cast(new HSBType(DecimalType.ZERO, PercentType.ZERO, new PercentType(this.toBigDecimal().multiply(BIG_DECIMAL_HUNDRED)))));
        }
        if (target == PercentType.class) {
            QuantityType<T> inPercent = this.toUnit(Units.PERCENT);
            if (inPercent == null) {
                return null;
            }
            return (U)((State)target.cast(new PercentType(inPercent.toBigDecimal())));
        }
        if (target == DecimalType.class) {
            return (U)((State)target.cast(new DecimalType(this.toBigDecimal())));
        }
        return State.super.as(target);
    }

    public QuantityType<T> add(QuantityType<T> state) {
        ComparableQuantity quantity = Quantities.getQuantity((Number)this.quantity.getValue(), (Unit)this.quantity.getUnit(), (Quantity.Scale)Quantity.Scale.ABSOLUTE);
        return new QuantityType<T>(quantity.add(state.quantity));
    }

    public QuantityType<T> negate() {
        return new QuantityType<T>(this.quantity.negate());
    }

    public QuantityType<T> subtract(QuantityType<T> state) {
        ComparableQuantity quantity = Quantities.getQuantity((Number)this.quantity.getValue(), (Unit)this.quantity.getUnit(), (Quantity.Scale)Quantity.Scale.ABSOLUTE);
        return new QuantityType<T>(quantity.subtract(state.quantity));
    }

    public QuantityType<?> multiply(BigDecimal value) {
        ComparableQuantity quantity = Quantities.getQuantity((Number)this.quantity.getValue(), (Unit)this.quantity.getUnit(), (Quantity.Scale)Quantity.Scale.ABSOLUTE);
        return new QuantityType<T>(quantity.multiply((Number)value));
    }

    public QuantityType<?> multiply(QuantityType<?> state) {
        ComparableQuantity quantity = Quantities.getQuantity((Number)this.quantity.getValue(), (Unit)this.quantity.getUnit(), (Quantity.Scale)Quantity.Scale.ABSOLUTE);
        ComparableQuantity stateQuantity = Quantities.getQuantity((Number)state.quantity.getValue(), (Unit)state.quantity.getUnit(), (Quantity.Scale)Quantity.Scale.ABSOLUTE);
        QuantityType<T> result = new QuantityType<T>(quantity.multiply((Quantity)stateQuantity));
        Unit<T> unit = result.getUnit();
        QuantityType<T> convertedResult = this.getUnit().isCompatible(unit) ? result.toUnit(this.getUnit()) : (state.getUnit().isCompatible(unit) ? result.toUnit(state.getUnit()) : result);
        return convertedResult == null ? result : convertedResult;
    }

    public QuantityType<?> divide(BigDecimal value) {
        ComparableQuantity quantity = Quantities.getQuantity((Number)this.quantity.getValue(), (Unit)this.quantity.getUnit(), (Quantity.Scale)Quantity.Scale.ABSOLUTE);
        return new QuantityType<T>(quantity.divide((Number)value));
    }

    public QuantityType<?> divide(QuantityType<?> state) {
        ComparableQuantity quantity = Quantities.getQuantity((Number)this.quantity.getValue(), (Unit)this.quantity.getUnit(), (Quantity.Scale)Quantity.Scale.ABSOLUTE);
        ComparableQuantity stateQuantity = Quantities.getQuantity((Number)state.quantity.getValue(), (Unit)state.quantity.getUnit(), (Quantity.Scale)Quantity.Scale.ABSOLUTE);
        QuantityType<T> result = new QuantityType<T>(quantity.divide((Quantity)stateQuantity));
        Unit<T> unit = result.getUnit();
        QuantityType<T> convertedResult = this.getUnit().isCompatible(unit) ? result.toUnit(this.getUnit()) : (state.getUnit().isCompatible(unit) ? result.toUnit(state.getUnit()) : result);
        return convertedResult == null ? result : convertedResult;
    }

    public QuantityType<T> offset(QuantityType<T> offset, Unit<T> unit) {
        ComparableQuantity quantity = Quantities.getQuantity((Number)this.quantity.getValue(), (Unit)this.quantity.getUnit(), (Quantity.Scale)Quantity.Scale.ABSOLUTE);
        Quantity sum = Stream.of(quantity, offset.quantity).reduce(QuantityFunctions.sum(unit)).get();
        return new QuantityType<T>(sum);
    }

    public QuantityType<?> inverse() {
        ComparableQuantity quantity = Quantities.getQuantity((Number)this.quantity.getValue(), (Unit)this.quantity.getUnit(), (Quantity.Scale)Quantity.Scale.ABSOLUTE);
        return new QuantityType<T>(quantity.inverse());
    }
}

