/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.library.types;

import java.time.DateTimeException;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.time.zone.ZoneRulesException;
import java.util.Locale;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.openhab.core.types.Command;
import org.openhab.core.types.PrimitiveType;
import org.openhab.core.types.State;

@NonNullByDefault
public class DateTimeType
implements PrimitiveType,
State,
Command {
    public static final String DATE_PATTERN = "yyyy-MM-dd'T'HH:mm:ss";
    public static final String DATE_PATTERN_WITH_TZ = "yyyy-MM-dd'T'HH:mm:ssz";
    public static final String DATE_PATTERN_WITH_TZ_AND_MS = "yyyy-MM-dd'T'HH:mm:ss.SSSZ";
    public static final String DATE_PATTERN_WITH_TZ_AND_MS_GENERAL = "yyyy-MM-dd'T'HH:mm:ss.SSSz";
    public static final String DATE_PATTERN_WITH_TZ_AND_MS_ISO = "yyyy-MM-dd'T'HH:mm:ss.SSSX";
    private static final String DATE_PARSE_PATTERN_WITHOUT_TZ = "yyyy-MM-dd'T'HH:mm[:ss[.SSSSSSSSS][.SSSSSSSS][.SSSSSSS][.SSSSSS][.SSSSS][.SSSS][.SSS][.SS][.S]]";
    private static final String DATE_PARSE_PATTERN_WITH_TZ = "yyyy-MM-dd'T'HH:mm[:ss[.SSSSSSSSS][.SSSSSSSS][.SSSSSSS][.SSSSSS][.SSSSS][.SSSS][.SSS][.SS][.S]]z";
    private static final String DATE_PARSE_PATTERN_WITH_TZ_RFC = "yyyy-MM-dd'T'HH:mm[:ss[.SSSSSSSSS][.SSSSSSSS][.SSSSSSS][.SSSSSS][.SSSSS][.SSSS][.SSS][.SS][.S]]Z";
    private static final String DATE_PARSE_PATTERN_WITH_TZ_ISO = "yyyy-MM-dd'T'HH:mm[:ss[.SSSSSSSSS][.SSSSSSSS][.SSSSSSS][.SSSSSS][.SSSSS][.SSSS][.SSS][.SS][.S]]X";
    private static final DateTimeFormatter PARSER = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm[:ss[.SSSSSSSSS][.SSSSSSSS][.SSSSSSS][.SSSSSS][.SSSSS][.SSSS][.SSS][.SS][.S]]");
    private static final DateTimeFormatter PARSER_TZ = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm[:ss[.SSSSSSSSS][.SSSSSSSS][.SSSSSSS][.SSSSSS][.SSSSS][.SSSS][.SSS][.SS][.S]]z");
    private static final DateTimeFormatter PARSER_TZ_RFC = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm[:ss[.SSSSSSSSS][.SSSSSSSS][.SSSSSSS][.SSSSSS][.SSSSS][.SSSS][.SSS][.SS][.S]]Z");
    private static final DateTimeFormatter PARSER_TZ_ISO = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm[:ss[.SSSSSSSSS][.SSSSSSSS][.SSSSSSS][.SSSSSS][.SSSSS][.SSSS][.SSS][.SS][.S]]X");
    private static final String DATE_FORMAT_PATTERN_WITH_TZ_RFC = "yyyy-MM-dd'T'HH:mm[:ss[.SSSSSSSSS]]Z";
    private static final DateTimeFormatter FORMATTER_TZ_RFC = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm[:ss[.SSSSSSSSS]]Z");
    private ZonedDateTime zonedDateTime;

    public DateTimeType() {
        this(ZonedDateTime.now());
    }

    public DateTimeType(ZonedDateTime zoned) {
        this.zonedDateTime = ZonedDateTime.from(zoned).withFixedOffsetZone();
    }

    public DateTimeType(String zonedValue) {
        ZonedDateTime date;
        block9: {
            date = null;
            try {
                try {
                    date = this.parse(zonedValue);
                }
                catch (DateTimeParseException fullDtException) {
                    try {
                        date = this.parse("1970-01-01T" + zonedValue);
                    }
                    catch (DateTimeParseException timeOnlyException) {
                        try {
                            long epoch = Double.valueOf(zonedValue).longValue();
                            int length = (int)(Math.log10(epoch >= 0L ? epoch : epoch * -1L) + 1.0);
                            Instant i = length < 12 ? Instant.ofEpochSecond(epoch) : Instant.ofEpochMilli(epoch);
                            date = ZonedDateTime.ofInstant(i, ZoneOffset.UTC);
                        }
                        catch (NumberFormatException notANumberException) {
                            if (zonedValue.length() == 10) {
                                date = this.parse(String.valueOf(zonedValue) + "T00:00:00");
                                break block9;
                            }
                            date = this.parse(String.valueOf(zonedValue.substring(0, 10)) + "T00:00:00" + zonedValue.substring(10));
                        }
                    }
                }
            }
            catch (DateTimeParseException invalidFormatException) {
                throw new IllegalArgumentException(String.valueOf(zonedValue) + " is not in a valid format.", invalidFormatException);
            }
        }
        this.zonedDateTime = date.withFixedOffsetZone();
    }

    public ZonedDateTime getZonedDateTime() {
        return this.zonedDateTime;
    }

    public Instant getInstant() {
        return this.zonedDateTime.toInstant();
    }

    public static DateTimeType valueOf(String value) {
        return new DateTimeType(value);
    }

    @Override
    public String format(@Nullable String pattern) {
        if (pattern == null) {
            return DateTimeFormatter.ofPattern(DATE_PATTERN).format(this.zonedDateTime);
        }
        return String.format(pattern, this.zonedDateTime);
    }

    public String format(Locale locale, String pattern) {
        return String.format(locale, pattern, this.zonedDateTime);
    }

    public DateTimeType toLocaleZone() throws DateTimeException, ZoneRulesException {
        return this.toZone(ZoneId.systemDefault());
    }

    public DateTimeType toZone(String zone) throws DateTimeException, ZoneRulesException {
        return this.toZone(ZoneId.of(zone));
    }

    public DateTimeType toZone(ZoneId zoneId) throws DateTimeException {
        return new DateTimeType(this.zonedDateTime.withZoneSameInstant(zoneId));
    }

    public String toString() {
        return this.toFullString();
    }

    @Override
    public String toFullString() {
        String formatted = this.zonedDateTime.format(FORMATTER_TZ_RFC);
        if (formatted.contains(".")) {
            String sign = "";
            if (formatted.contains("+")) {
                sign = "+";
            } else if (formatted.contains("-")) {
                sign = "-";
            }
            if (!sign.isEmpty()) {
                return formatted.replace("000" + sign, sign).replace("000" + sign, sign);
            }
        }
        return formatted;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.getZonedDateTime().hashCode();
        return result;
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DateTimeType other = (DateTimeType)obj;
        return this.zonedDateTime.compareTo(other.zonedDateTime) == 0;
    }

    private ZonedDateTime parse(String value) throws DateTimeParseException {
        ZonedDateTime date = null;
        try {
            date = ZonedDateTime.parse(value, PARSER_TZ_RFC);
        }
        catch (DateTimeParseException tzMsRfcException) {
            try {
                date = ZonedDateTime.parse(value, PARSER_TZ_ISO);
            }
            catch (DateTimeParseException tzMsIsoException) {
                try {
                    date = ZonedDateTime.parse(value, PARSER_TZ);
                }
                catch (DateTimeParseException tzException) {
                    LocalDateTime localDateTime = LocalDateTime.parse(value, PARSER);
                    date = ZonedDateTime.of(localDateTime, ZoneId.systemDefault());
                }
            }
        }
        return date;
    }
}

