/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.library.items;

import java.math.BigDecimal;
import java.util.List;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.openhab.core.library.items.DimmerItem;
import org.openhab.core.library.types.DecimalType;
import org.openhab.core.library.types.HSBType;
import org.openhab.core.library.types.IncreaseDecreaseType;
import org.openhab.core.library.types.OnOffType;
import org.openhab.core.library.types.PercentType;
import org.openhab.core.types.Command;
import org.openhab.core.types.RefreshType;
import org.openhab.core.types.State;
import org.openhab.core.types.TimeSeries;
import org.openhab.core.types.UnDefType;

@NonNullByDefault
public class ColorItem
extends DimmerItem {
    private static final List<Class<? extends State>> ACCEPTED_DATA_TYPES = List.of(HSBType.class, PercentType.class, OnOffType.class, UnDefType.class);
    private static final List<Class<? extends Command>> ACCEPTED_COMMAND_TYPES = List.of(HSBType.class, PercentType.class, OnOffType.class, IncreaseDecreaseType.class, RefreshType.class);

    public ColorItem(String name) {
        super("Color", name);
    }

    public void send(HSBType command) {
        this.internalSend(command);
    }

    @Override
    public List<Class<? extends State>> getAcceptedDataTypes() {
        return ACCEPTED_DATA_TYPES;
    }

    @Override
    public List<Class<? extends Command>> getAcceptedCommandTypes() {
        return ACCEPTED_COMMAND_TYPES;
    }

    @Override
    public void setState(State state) {
        if (this.isAcceptedState(ACCEPTED_DATA_TYPES, state)) {
            State currentState = this.state;
            if (currentState instanceof HSBType var3_4) {
                DecimalType hue = hsbType.getHue();
                PercentType saturation = hsbType.getSaturation();
                if (state == OnOffType.OFF) {
                    this.applyState(new HSBType(hue, saturation, PercentType.ZERO));
                } else if (state == OnOffType.ON) {
                    this.applyState(new HSBType(hue, saturation, PercentType.HUNDRED));
                } else {
                    if (state instanceof PercentType var7_9 && !(state instanceof HSBType)) {
                        this.applyState(new HSBType(hue, saturation, (PercentType)percentType));
                    } else {
                        if (state instanceof DecimalType var9_11 && !(state instanceof HSBType)) {
                            this.applyState(new HSBType(hue, saturation, new PercentType(decimalType.toBigDecimal().multiply(BigDecimal.valueOf(100L)))));
                        } else {
                            this.applyState(state);
                        }
                    }
                }
            } else {
                HSBType convertedState = state.as(HSBType.class);
                if (convertedState != null) {
                    this.applyState(convertedState);
                } else {
                    this.applyState(state);
                }
            }
        } else {
            this.logSetTypeError(state);
        }
    }

    @Override
    public void setTimeSeries(TimeSeries timeSeries) {
        if (timeSeries.getStates().allMatch(s -> s.state() instanceof HSBType)) {
            this.applyTimeSeries(timeSeries);
        } else {
            this.logSetTypeError(timeSeries);
        }
    }
}

