/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.items.events;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.time.Instant;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.openhab.core.events.AbstractEventFactory;
import org.openhab.core.events.Event;
import org.openhab.core.events.EventFactory;
import org.openhab.core.items.Item;
import org.openhab.core.items.dto.ItemDTO;
import org.openhab.core.items.dto.ItemDTOMapper;
import org.openhab.core.items.events.GroupItemStateChangedEvent;
import org.openhab.core.items.events.GroupStateUpdatedEvent;
import org.openhab.core.items.events.ItemAddedEvent;
import org.openhab.core.items.events.ItemCommandEvent;
import org.openhab.core.items.events.ItemEvent;
import org.openhab.core.items.events.ItemRemovedEvent;
import org.openhab.core.items.events.ItemStateChangedEvent;
import org.openhab.core.items.events.ItemStateEvent;
import org.openhab.core.items.events.ItemStatePredictedEvent;
import org.openhab.core.items.events.ItemStateUpdatedEvent;
import org.openhab.core.items.events.ItemTimeSeriesEvent;
import org.openhab.core.items.events.ItemTimeSeriesUpdatedEvent;
import org.openhab.core.items.events.ItemUpdatedEvent;
import org.openhab.core.types.Command;
import org.openhab.core.types.RefreshType;
import org.openhab.core.types.State;
import org.openhab.core.types.TimeSeries;
import org.openhab.core.types.Type;
import org.openhab.core.types.UnDefType;
import org.osgi.service.component.annotations.Component;

@Component(immediate=true, service={EventFactory.class})
@NonNullByDefault
public class ItemEventFactory
extends AbstractEventFactory {
    private static final String TYPE_POSTFIX = "Type";
    private static final String CORE_LIBRARY_PACKAGE = "org.openhab.core.library.types.";
    private static final String ITEM_COMAND_EVENT_TOPIC = "openhab/items/{itemName}/command";
    private static final String ITEM_STATE_EVENT_TOPIC = "openhab/items/{itemName}/state";
    private static final String ITEM_STATE_UPDATED_EVENT_TOPIC = "openhab/items/{itemName}/stateupdated";
    private static final String ITEM_TIME_SERIES_EVENT_TOPIC = "openhab/items/{itemName}/timeseries";
    private static final String ITEM_TIME_SERIES_UPDATED_EVENT_TOPIC = "openhab/items/{itemName}/timeseriesupdated";
    private static final String ITEM_STATE_PREDICTED_EVENT_TOPIC = "openhab/items/{itemName}/statepredicted";
    private static final String ITEM_STATE_CHANGED_EVENT_TOPIC = "openhab/items/{itemName}/statechanged";
    private static final String GROUP_STATE_EVENT_TOPIC = "openhab/items/{itemName}/{memberName}/stateupdated";
    private static final String GROUPITEM_STATE_CHANGED_EVENT_TOPIC = "openhab/items/{itemName}/{memberName}/statechanged";
    private static final String ITEM_ADDED_EVENT_TOPIC = "openhab/items/{itemName}/added";
    private static final String ITEM_REMOVED_EVENT_TOPIC = "openhab/items/{itemName}/removed";
    private static final String ITEM_UPDATED_EVENT_TOPIC = "openhab/items/{itemName}/updated";

    public ItemEventFactory() {
        super(Set.of(ItemCommandEvent.TYPE, ItemStateEvent.TYPE, ItemStatePredictedEvent.TYPE, ItemStateUpdatedEvent.TYPE, ItemStateChangedEvent.TYPE, ItemAddedEvent.TYPE, ItemUpdatedEvent.TYPE, ItemRemovedEvent.TYPE, GroupStateUpdatedEvent.TYPE, GroupItemStateChangedEvent.TYPE, ItemTimeSeriesEvent.TYPE, ItemTimeSeriesUpdatedEvent.TYPE));
    }

    @Override
    protected Event createEventByType(String eventType, String topic, String payload, @Nullable String source) throws Exception {
        if (ItemCommandEvent.TYPE.equals(eventType)) {
            return this.createCommandEvent(topic, payload, source);
        }
        if (ItemStateEvent.TYPE.equals(eventType)) {
            return this.createStateEvent(topic, payload, source);
        }
        if (ItemStatePredictedEvent.TYPE.equals(eventType)) {
            return this.createStatePredictedEvent(topic, payload);
        }
        if (ItemStateUpdatedEvent.TYPE.equals(eventType)) {
            return this.createStateUpdatedEvent(topic, payload);
        }
        if (ItemStateChangedEvent.TYPE.equals(eventType)) {
            return this.createStateChangedEvent(topic, payload);
        }
        if (ItemTimeSeriesEvent.TYPE.equals(eventType)) {
            return this.createTimeSeriesEvent(topic, payload);
        }
        if (ItemTimeSeriesUpdatedEvent.TYPE.equals(eventType)) {
            return this.createTimeSeriesUpdatedEvent(topic, payload);
        }
        if (ItemAddedEvent.TYPE.equals(eventType)) {
            return this.createAddedEvent(topic, payload);
        }
        if (ItemUpdatedEvent.TYPE.equals(eventType)) {
            return this.createUpdatedEvent(topic, payload);
        }
        if (ItemRemovedEvent.TYPE.equals(eventType)) {
            return this.createRemovedEvent(topic, payload);
        }
        if (GroupStateUpdatedEvent.TYPE.equals(eventType)) {
            return this.createGroupStateUpdatedEvent(topic, payload);
        }
        if (GroupItemStateChangedEvent.TYPE.equals(eventType)) {
            return this.createGroupStateChangedEvent(topic, payload);
        }
        throw new IllegalArgumentException("The event type '" + eventType + "' is not supported by this factory.");
    }

    private Event createGroupStateUpdatedEvent(String topic, String payload) {
        String itemName = this.getItemName(topic);
        String memberName = this.getMemberName(topic);
        ItemEventPayloadBean bean = ItemEventFactory.deserializePayload(payload, ItemEventPayloadBean.class);
        State state = this.getState(bean.getType(), bean.getValue());
        return new GroupStateUpdatedEvent(topic, payload, itemName, memberName, state, null);
    }

    private Event createGroupStateChangedEvent(String topic, String payload) {
        String itemName = this.getItemName(topic);
        String memberName = this.getMemberName(topic);
        ItemStateChangedEventPayloadBean bean = ItemEventFactory.deserializePayload(payload, ItemStateChangedEventPayloadBean.class);
        State state = this.getState(bean.getType(), bean.getValue());
        State oldState = this.getState(bean.getOldType(), bean.getOldValue());
        return new GroupItemStateChangedEvent(topic, payload, itemName, memberName, state, oldState);
    }

    private Event createCommandEvent(String topic, String payload, @Nullable String source) {
        String itemName = this.getItemName(topic);
        ItemEventPayloadBean bean = ItemEventFactory.deserializePayload(payload, ItemEventPayloadBean.class);
        Command command = ItemEventFactory.parseType(bean.getType(), bean.getValue(), Command.class);
        return new ItemCommandEvent(topic, payload, itemName, command, source);
    }

    private Event createStateEvent(String topic, String payload, @Nullable String source) {
        String itemName = this.getItemName(topic);
        ItemEventPayloadBean bean = ItemEventFactory.deserializePayload(payload, ItemEventPayloadBean.class);
        State state = this.getState(bean.getType(), bean.getValue());
        return new ItemStateEvent(topic, payload, itemName, state, source);
    }

    private Event createStatePredictedEvent(String topic, String payload) {
        String itemName = this.getItemName(topic);
        ItemStatePredictedEventPayloadBean bean = ItemEventFactory.deserializePayload(payload, ItemStatePredictedEventPayloadBean.class);
        State state = this.getState(bean.getPredictedType(), bean.getPredictedValue());
        return new ItemStatePredictedEvent(topic, payload, itemName, state, bean.isConfirmation());
    }

    private Event createStateUpdatedEvent(String topic, String payload) {
        String itemName = this.getItemName(topic);
        ItemEventPayloadBean bean = ItemEventFactory.deserializePayload(payload, ItemEventPayloadBean.class);
        State state = this.getState(bean.getType(), bean.getValue());
        return new ItemStateUpdatedEvent(topic, payload, itemName, state, null);
    }

    private Event createStateChangedEvent(String topic, String payload) {
        String itemName = this.getItemName(topic);
        ItemStateChangedEventPayloadBean bean = ItemEventFactory.deserializePayload(payload, ItemStateChangedEventPayloadBean.class);
        State state = this.getState(bean.getType(), bean.getValue());
        State oldState = this.getState(bean.getOldType(), bean.getOldValue());
        return new ItemStateChangedEvent(topic, payload, itemName, state, oldState);
    }

    private Event createTimeSeriesEvent(String topic, String payload) {
        String itemName = this.getItemName(topic);
        ItemTimeSeriesEventPayloadBean bean = ItemEventFactory.deserializePayload(payload, ItemTimeSeriesEventPayloadBean.class);
        TimeSeries timeSeries = bean.getTimeSeries();
        return new ItemTimeSeriesEvent(topic, payload, itemName, timeSeries, null);
    }

    private Event createTimeSeriesUpdatedEvent(String topic, String payload) {
        String itemName = this.getItemName(topic);
        ItemTimeSeriesEventPayloadBean bean = ItemEventFactory.deserializePayload(payload, ItemTimeSeriesEventPayloadBean.class);
        TimeSeries timeSeries = bean.getTimeSeries();
        return new ItemTimeSeriesUpdatedEvent(topic, payload, itemName, timeSeries, null);
    }

    private State getState(String type, String value) {
        return ItemEventFactory.parseType(type, value, State.class);
    }

    private String getItemName(String topic) {
        String[] topicElements = this.getTopicElements(topic);
        if (topicElements.length < 4) {
            throw new IllegalArgumentException("Event creation failed, invalid topic: " + topic);
        }
        return topicElements[2];
    }

    private String getMemberName(String topic) {
        String[] topicElements = this.getTopicElements(topic);
        if (topicElements.length < 5) {
            throw new IllegalArgumentException("Event creation failed, invalid topic: " + topic);
        }
        return topicElements[3];
    }

    private static <T> T parseType(String typeName, String valueToParse, Class<T> desiredClass) {
        Object parsedObject = null;
        String simpleClassName = String.valueOf(typeName) + TYPE_POSTFIX;
        parsedObject = ItemEventFactory.parseSimpleClassName(simpleClassName, valueToParse);
        if (parsedObject == null || !desiredClass.isAssignableFrom(parsedObject.getClass())) {
            String parsedObjectClassName = parsedObject != null ? parsedObject.getClass().getName() : "<undefined>";
            throw new IllegalArgumentException("Error parsing simpleClasssName '" + simpleClassName + "' with value '" + valueToParse + "'. Desired type was '" + desiredClass.getName() + "' but got '" + parsedObjectClassName + "'.");
        }
        return desiredClass.cast(parsedObject);
    }

    private static @Nullable Object parseSimpleClassName(String simpleClassName, String valueToParse) {
        if (simpleClassName.equals(UnDefType.class.getSimpleName())) {
            return UnDefType.valueOf(valueToParse);
        }
        if (simpleClassName.equals(RefreshType.class.getSimpleName())) {
            return RefreshType.valueOf(valueToParse);
        }
        try {
            Class<?> stateClass = Class.forName(CORE_LIBRARY_PACKAGE + simpleClassName);
            Method valueOfMethod = stateClass.getMethod("valueOf", String.class);
            return valueOfMethod.invoke(stateClass, valueToParse);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException("Error getting class for simple name: '" + simpleClassName + "' using package name '" + CORE_LIBRARY_PACKAGE + "'.", e);
        }
        catch (NoSuchMethodException | SecurityException e) {
            throw new IllegalStateException("Error getting method #valueOf(String) of class 'org.openhab.core.library.types." + simpleClassName + "'.", e);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            throw new IllegalStateException("Error invoking #valueOf(String) on class 'org.openhab.core.library.types." + simpleClassName + "' with value '" + valueToParse + "'.", e);
        }
    }

    private Event createAddedEvent(String topic, String payload) {
        ItemDTO itemDTO = ItemEventFactory.deserializePayload(payload, ItemDTO.class);
        return new ItemAddedEvent(topic, payload, itemDTO);
    }

    private Event createRemovedEvent(String topic, String payload) {
        ItemDTO itemDTO = ItemEventFactory.deserializePayload(payload, ItemDTO.class);
        return new ItemRemovedEvent(topic, payload, itemDTO);
    }

    private Event createUpdatedEvent(String topic, String payload) {
        ItemDTO[] itemDTOs = ItemEventFactory.deserializePayload(payload, ItemDTO[].class);
        if (itemDTOs.length != 2) {
            throw new IllegalArgumentException("ItemUpdateEvent creation failed, invalid payload: " + payload);
        }
        return new ItemUpdatedEvent(topic, payload, itemDTOs[0], itemDTOs[1]);
    }

    public static ItemCommandEvent createCommandEvent(String itemName, Command command, @Nullable String source) {
        ItemEventFactory.assertValidArguments(itemName, command, "command");
        String topic = ItemEventFactory.buildTopic(ITEM_COMAND_EVENT_TOPIC, itemName);
        ItemEventPayloadBean bean = new ItemEventPayloadBean(ItemEventFactory.getCommandType(command), command.toString());
        String payload = ItemEventFactory.serializePayload(bean);
        return new ItemCommandEvent(topic, payload, itemName, command, source);
    }

    public static ItemCommandEvent createCommandEvent(String itemName, Command command) {
        return ItemEventFactory.createCommandEvent(itemName, command, null);
    }

    public static ItemStateEvent createStateEvent(String itemName, State state, @Nullable String source) {
        ItemEventFactory.assertValidArguments(itemName, state, "state");
        String topic = ItemEventFactory.buildTopic(ITEM_STATE_EVENT_TOPIC, itemName);
        ItemEventPayloadBean bean = new ItemEventPayloadBean(ItemEventFactory.getStateType(state), state.toFullString());
        String payload = ItemEventFactory.serializePayload(bean);
        return new ItemStateEvent(topic, payload, itemName, state, source);
    }

    public static ItemEvent createStateEvent(String itemName, State state) {
        return ItemEventFactory.createStateEvent(itemName, state, null);
    }

    public static ItemStateUpdatedEvent createStateUpdatedEvent(String itemName, State state) {
        return ItemEventFactory.createStateUpdatedEvent(itemName, state, null);
    }

    public static ItemStateUpdatedEvent createStateUpdatedEvent(String itemName, State state, @Nullable String source) {
        ItemEventFactory.assertValidArguments(itemName, state, "state");
        String topic = ItemEventFactory.buildTopic(ITEM_STATE_UPDATED_EVENT_TOPIC, itemName);
        ItemEventPayloadBean bean = new ItemEventPayloadBean(ItemEventFactory.getStateType(state), state.toFullString());
        String payload = ItemEventFactory.serializePayload(bean);
        return new ItemStateUpdatedEvent(topic, payload, itemName, state, source);
    }

    public static ItemTimeSeriesEvent createTimeSeriesEvent(String itemName, TimeSeries timeSeries, @Nullable String source) {
        String topic = ItemEventFactory.buildTopic(ITEM_TIME_SERIES_EVENT_TOPIC, itemName);
        ItemTimeSeriesEventPayloadBean bean = new ItemTimeSeriesEventPayloadBean(timeSeries);
        String payload = ItemEventFactory.serializePayload(bean);
        return new ItemTimeSeriesEvent(topic, payload, itemName, timeSeries, source);
    }

    public static ItemTimeSeriesUpdatedEvent createTimeSeriesUpdatedEvent(String itemName, TimeSeries timeSeries, @Nullable String source) {
        String topic = ItemEventFactory.buildTopic(ITEM_TIME_SERIES_UPDATED_EVENT_TOPIC, itemName);
        ItemTimeSeriesEventPayloadBean bean = new ItemTimeSeriesEventPayloadBean(timeSeries);
        String payload = ItemEventFactory.serializePayload(bean);
        return new ItemTimeSeriesUpdatedEvent(topic, payload, itemName, timeSeries, source);
    }

    public static GroupStateUpdatedEvent createGroupStateUpdatedEvent(String groupName, String member, State state, @Nullable String source) {
        ItemEventFactory.assertValidArguments(groupName, member, state, "state");
        String topic = ItemEventFactory.buildGroupTopic(GROUP_STATE_EVENT_TOPIC, groupName, member);
        ItemEventPayloadBean bean = new ItemEventPayloadBean(ItemEventFactory.getStateType(state), state.toFullString());
        String payload = ItemEventFactory.serializePayload(bean);
        return new GroupStateUpdatedEvent(topic, payload, groupName, member, state, source);
    }

    public static ItemStatePredictedEvent createStatePredictedEvent(String itemName, State state, boolean isConfirmation) {
        ItemEventFactory.assertValidArguments(itemName, state, "state");
        String topic = ItemEventFactory.buildTopic(ITEM_STATE_PREDICTED_EVENT_TOPIC, itemName);
        ItemStatePredictedEventPayloadBean bean = new ItemStatePredictedEventPayloadBean(ItemEventFactory.getStateType(state), state.toFullString(), isConfirmation);
        String payload = ItemEventFactory.serializePayload(bean);
        return new ItemStatePredictedEvent(topic, payload, itemName, state, isConfirmation);
    }

    public static ItemStateChangedEvent createStateChangedEvent(String itemName, State newState, State oldState) {
        ItemEventFactory.assertValidArguments(itemName, newState, "state");
        String topic = ItemEventFactory.buildTopic(ITEM_STATE_CHANGED_EVENT_TOPIC, itemName);
        ItemStateChangedEventPayloadBean bean = new ItemStateChangedEventPayloadBean(ItemEventFactory.getStateType(newState), newState.toFullString(), ItemEventFactory.getStateType(oldState), oldState.toFullString());
        String payload = ItemEventFactory.serializePayload(bean);
        return new ItemStateChangedEvent(topic, payload, itemName, newState, oldState);
    }

    public static GroupItemStateChangedEvent createGroupStateChangedEvent(String itemName, String memberName, State newState, State oldState) {
        ItemEventFactory.assertValidArguments(itemName, memberName, newState, "state");
        String topic = ItemEventFactory.buildGroupTopic(GROUPITEM_STATE_CHANGED_EVENT_TOPIC, itemName, memberName);
        ItemStateChangedEventPayloadBean bean = new ItemStateChangedEventPayloadBean(ItemEventFactory.getStateType(newState), newState.toFullString(), ItemEventFactory.getStateType(oldState), oldState.toFullString());
        String payload = ItemEventFactory.serializePayload(bean);
        return new GroupItemStateChangedEvent(topic, payload, itemName, memberName, newState, oldState);
    }

    public static ItemAddedEvent createAddedEvent(Item item) {
        ItemEventFactory.assertValidArgument(item, "item");
        String topic = ItemEventFactory.buildTopic(ITEM_ADDED_EVENT_TOPIC, item.getName());
        ItemDTO itemDTO = ItemEventFactory.map(item);
        String payload = ItemEventFactory.serializePayload(itemDTO);
        return new ItemAddedEvent(topic, payload, itemDTO);
    }

    public static ItemRemovedEvent createRemovedEvent(Item item) {
        ItemEventFactory.assertValidArgument(item, "item");
        String topic = ItemEventFactory.buildTopic(ITEM_REMOVED_EVENT_TOPIC, item.getName());
        ItemDTO itemDTO = ItemEventFactory.map(item);
        String payload = ItemEventFactory.serializePayload(itemDTO);
        return new ItemRemovedEvent(topic, payload, itemDTO);
    }

    public static ItemUpdatedEvent createUpdateEvent(Item item, Item oldItem) {
        ItemEventFactory.assertValidArgument(item, "item");
        ItemEventFactory.assertValidArgument(oldItem, "oldItem");
        String topic = ItemEventFactory.buildTopic(ITEM_UPDATED_EVENT_TOPIC, item.getName());
        ItemDTO itemDTO = ItemEventFactory.map(item);
        ItemDTO oldItemDTO = ItemEventFactory.map(oldItem);
        LinkedList<ItemDTO> itemDTOs = new LinkedList<ItemDTO>();
        itemDTOs.add(itemDTO);
        itemDTOs.add(oldItemDTO);
        String payload = ItemEventFactory.serializePayload(itemDTOs);
        return new ItemUpdatedEvent(topic, payload, itemDTO, oldItemDTO);
    }

    private static String buildTopic(String topic, String itemName) {
        return topic.replace("{itemName}", itemName);
    }

    private static String buildGroupTopic(String topic, String itemName, String memberName) {
        return ItemEventFactory.buildTopic(topic, itemName).replace("{memberName}", memberName);
    }

    private static ItemDTO map(Item item) {
        return ItemDTOMapper.map(item);
    }

    private static String getStateType(State state) {
        String stateClassName = state.getClass().getSimpleName();
        return stateClassName.substring(0, stateClassName.length() - TYPE_POSTFIX.length());
    }

    private static String getCommandType(Command command) {
        String commandClassName = command.getClass().getSimpleName();
        return commandClassName.substring(0, commandClassName.length() - TYPE_POSTFIX.length());
    }

    private static void assertValidArguments(String itemName, Type type, String typeArgumentName) {
        ItemEventFactory.checkNotNullOrEmpty(itemName, "itemName");
        ItemEventFactory.checkNotNull(type, typeArgumentName);
    }

    private static void assertValidArguments(String itemName, String memberName, Type type, String typeArgumentName) {
        ItemEventFactory.checkNotNullOrEmpty(itemName, "itemName");
        ItemEventFactory.checkNotNullOrEmpty(memberName, "memberName");
        ItemEventFactory.checkNotNull(type, typeArgumentName);
    }

    private static void assertValidArgument(Item item, String argumentName) {
        ItemEventFactory.checkNotNull(item, argumentName);
    }

    private static class ItemEventPayloadBean {
        @NonNullByDefault(value={})
        private String type;
        @NonNullByDefault(value={})
        private String value;

        protected ItemEventPayloadBean() {
        }

        public ItemEventPayloadBean(String type, String value) {
            this.type = type;
            this.value = value;
        }

        public String getType() {
            return this.type;
        }

        public String getValue() {
            return this.value;
        }
    }

    private static class ItemStateChangedEventPayloadBean {
        @NonNullByDefault(value={})
        private String type;
        @NonNullByDefault(value={})
        private String value;
        @NonNullByDefault(value={})
        private String oldType;
        @NonNullByDefault(value={})
        private String oldValue;

        protected ItemStateChangedEventPayloadBean() {
        }

        public ItemStateChangedEventPayloadBean(String type, String value, String oldType, String oldValue) {
            this.type = type;
            this.value = value;
            this.oldType = oldType;
            this.oldValue = oldValue;
        }

        public String getType() {
            return this.type;
        }

        public String getValue() {
            return this.value;
        }

        public String getOldType() {
            return this.oldType;
        }

        public String getOldValue() {
            return this.oldValue;
        }
    }

    private static class ItemStatePredictedEventPayloadBean {
        @NonNullByDefault(value={})
        private String predictedType;
        @NonNullByDefault(value={})
        private String predictedValue;
        private boolean isConfirmation;

        protected ItemStatePredictedEventPayloadBean() {
        }

        public ItemStatePredictedEventPayloadBean(String predictedType, String predictedValue, boolean isConfirmation) {
            this.predictedType = predictedType;
            this.predictedValue = predictedValue;
            this.isConfirmation = isConfirmation;
        }

        public String getPredictedType() {
            return this.predictedType;
        }

        public String getPredictedValue() {
            return this.predictedValue;
        }

        public boolean isConfirmation() {
            return this.isConfirmation;
        }
    }

    private static class ItemTimeSeriesEventPayloadBean {
        @NonNullByDefault(value={})
        private List<TimeSeriesPayload> timeSeries;
        @NonNullByDefault(value={})
        private String policy;

        private ItemTimeSeriesEventPayloadBean() {
        }

        public ItemTimeSeriesEventPayloadBean(TimeSeries timeSeries) {
            this.timeSeries = timeSeries.getStates().map(TimeSeriesPayload::new).toList();
            this.policy = timeSeries.getPolicy().name();
        }

        public TimeSeries getTimeSeries() {
            TimeSeries timeSeries1 = new TimeSeries(TimeSeries.Policy.valueOf(this.policy));
            this.timeSeries.forEach(e -> {
                State state = ItemEventFactory.parseType(e.getType(), e.getValue(), State.class);
                Instant instant = Instant.parse(e.getTimestamp());
                timeSeries1.add(instant, state);
            });
            return timeSeries1;
        }

        private static class TimeSeriesPayload {
            @NonNullByDefault(value={})
            private String type;
            @NonNullByDefault(value={})
            private String value;
            @NonNullByDefault(value={})
            private String timestamp;

            private TimeSeriesPayload() {
            }

            public TimeSeriesPayload(TimeSeries.Entry entry) {
                this.type = ItemEventFactory.getStateType(entry.state());
                this.value = entry.state().toFullString();
                this.timestamp = entry.timestamp().toString();
            }

            public String getType() {
                return this.type;
            }

            public String getValue() {
                return this.value;
            }

            public String getTimestamp() {
                return this.timestamp;
            }
        }
    }
}

