/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.items.dto;

import java.util.ArrayList;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.openhab.core.internal.items.GroupFunctionHelper;
import org.openhab.core.items.GroupFunction;
import org.openhab.core.items.GroupItem;
import org.openhab.core.items.Item;
import org.openhab.core.items.ItemBuilder;
import org.openhab.core.items.ItemBuilderFactory;
import org.openhab.core.items.ItemUtil;
import org.openhab.core.items.dto.GroupFunctionDTO;
import org.openhab.core.items.dto.GroupItemDTO;
import org.openhab.core.items.dto.ItemDTO;
import org.openhab.core.types.State;

@NonNullByDefault
public class ItemDTOMapper {
    private static final GroupFunctionHelper GROUP_FUNCTION_HELPER = new GroupFunctionHelper();

    public static @Nullable Item map(ItemDTO itemDTO, ItemBuilderFactory itemBuilderFactory) {
        if (itemDTO == null) {
            throw new IllegalArgumentException("The argument 'itemDTO' must no be null.");
        }
        if (itemBuilderFactory == null) {
            throw new IllegalArgumentException("The argument 'itemBuilderFactory' must no be null.");
        }
        if (!ItemUtil.isValidItemName(itemDTO.name)) {
            throw new IllegalArgumentException("The item name '" + itemDTO.name + "' is invalid.");
        }
        if (itemDTO.type != null) {
            ItemBuilder builder = itemBuilderFactory.newItemBuilder(itemDTO.type, itemDTO.name);
            if (itemDTO instanceof GroupItemDTO var3_4 && "Group".equals(itemDTO.type)) {
                Item baseItem = null;
                if (groupItemDTO.groupType != null && !groupItemDTO.groupType.isEmpty()) {
                    baseItem = itemBuilderFactory.newItemBuilder(groupItemDTO.groupType, itemDTO.name).build();
                    builder.withBaseItem(baseItem);
                }
                GroupFunction function = new GroupFunction.Equality();
                if (groupItemDTO.function != null) {
                    function = ItemDTOMapper.mapFunction(baseItem, groupItemDTO.function);
                }
                builder.withGroupFunction(function);
            }
            builder.withLabel(itemDTO.label);
            builder.withCategory(itemDTO.category);
            builder.withGroups(itemDTO.groupNames);
            builder.withTags(itemDTO.tags);
            try {
                return builder.build();
            }
            catch (IllegalStateException e) {
                return null;
            }
        }
        return null;
    }

    public static GroupFunction mapFunction(@Nullable Item baseItem, GroupFunctionDTO function) {
        return GROUP_FUNCTION_HELPER.createGroupFunction(function, baseItem);
    }

    public static ItemDTO map(Item item) {
        ItemDTO itemDTO = item instanceof GroupItem ? new GroupItemDTO() : new ItemDTO();
        ItemDTOMapper.fillProperties(itemDTO, item);
        return itemDTO;
    }

    /*
     * WARNING - void declaration
     */
    private static void fillProperties(ItemDTO itemDTO, Item item) {
        void var3_2;
        GroupItem groupItem;
        Item item2 = item;
        if (item2 instanceof GroupItem && (groupItem = (GroupItem)item2) == (GroupItem)var3_2) {
            void groupItem2;
            GroupItemDTO groupItemDTO = (GroupItemDTO)itemDTO;
            Item baseItem = groupItem2.getBaseItem();
            if (baseItem != null) {
                groupItemDTO.groupType = baseItem.getType();
                groupItemDTO.function = ItemDTOMapper.mapFunction(groupItem2.getFunction());
            }
        }
        itemDTO.name = item.getName();
        itemDTO.type = item.getType();
        itemDTO.label = item.getLabel();
        itemDTO.tags = item.getTags();
        itemDTO.category = item.getCategory();
        itemDTO.groupNames = item.getGroupNames();
    }

    public static @Nullable GroupFunctionDTO mapFunction(@Nullable GroupFunction function) {
        if (function == null) {
            return null;
        }
        GroupFunctionDTO dto = new GroupFunctionDTO();
        dto.name = function.getClass().getSimpleName().toUpperCase();
        ArrayList<String> params = new ArrayList<String>();
        State[] stateArray = function.getParameters();
        int n = stateArray.length;
        int n2 = 0;
        while (n2 < n) {
            State param = stateArray[n2];
            params.add(param.toString());
            ++n2;
        }
        if (!params.isEmpty()) {
            dto.params = params.toArray(new String[params.size()]);
        }
        return dto;
    }
}

