/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.items;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.openhab.core.events.EventPublisher;
import org.openhab.core.items.GenericItem;
import org.openhab.core.items.GroupFunction;
import org.openhab.core.items.Item;
import org.openhab.core.items.Metadata;
import org.openhab.core.items.MetadataAwareItem;
import org.openhab.core.items.StateChangeListener;
import org.openhab.core.items.events.ItemEventFactory;
import org.openhab.core.service.CommandDescriptionService;
import org.openhab.core.service.StateDescriptionService;
import org.openhab.core.types.Command;
import org.openhab.core.types.State;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NonNullByDefault
public class GroupItem
extends GenericItem
implements StateChangeListener,
MetadataAwareItem {
    public static final String TYPE = "Group";
    private final Logger logger = LoggerFactory.getLogger(GroupItem.class);
    protected final @Nullable Item baseItem;
    protected @Nullable GroupFunction function;
    protected final CopyOnWriteArrayList<Item> members;

    public GroupItem(String name) {
        this(name, null, null);
    }

    public GroupItem(String name, @Nullable Item baseItem) {
        this(name, baseItem, new GroupFunction.Equality());
    }

    public GroupItem(String name, @Nullable Item baseItem, @Nullable GroupFunction function) {
        super(TYPE, name);
        if (baseItem == null || function == null) {
            this.baseItem = null;
            this.function = null;
        } else {
            this.baseItem = baseItem;
            this.function = function;
        }
        this.members = new CopyOnWriteArrayList();
    }

    @Override
    public void dispose() {
        super.dispose();
        this.removeAllMembers();
    }

    public @Nullable Item getBaseItem() {
        return this.baseItem;
    }

    public @Nullable GroupFunction getFunction() {
        return this.function;
    }

    public Set<Item> getMembers() {
        return Collections.unmodifiableSet(new LinkedHashSet<Item>(this.members));
    }

    public Set<Item> getAllMembers() {
        return Collections.unmodifiableSet(new LinkedHashSet<Item>(this.getMembers(i -> !(i instanceof GroupItem))));
    }

    private void collectMembers(Collection<Item> allMembers, Collection<Item> members) {
        for (Item member : members) {
            if (allMembers.contains(member)) continue;
            allMembers.add(member);
            if (!(member instanceof GroupItem var5_5)) continue;
            this.collectMembers(allMembers, item.members);
        }
    }

    public Set<Item> getMembers(Predicate<Item> filterItem) {
        LinkedHashSet<Item> allMembers = new LinkedHashSet<Item>();
        this.collectMembers(allMembers, this.members);
        return allMembers.stream().filter(filterItem).collect(Collectors.toSet());
    }

    public void addMember(Item item) {
        if (item == null) {
            throw new IllegalArgumentException("Item must not be null!");
        }
        boolean added = this.members.addIfAbsent(item);
        if (added && item instanceof GenericItem var3_4) {
            genericItem.addGroupName(this.getName());
        }
        this.registerStateListener(item);
    }

    /*
     * WARNING - void declaration
     */
    private void registerStateListener(Item item) {
        void var3_2;
        GenericItem genericItem;
        Item item2 = item;
        if (item2 instanceof GenericItem && (genericItem = (GenericItem)item2) == (GenericItem)var3_2) {
            void genericItem2;
            genericItem2.addStateChangeListener(this);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void unregisterStateListener(Item old) {
        void var3_2;
        GenericItem genericItem;
        Item item = old;
        if (item instanceof GenericItem && (genericItem = (GenericItem)item) == (GenericItem)var3_2) {
            void genericItem2;
            genericItem2.removeStateChangeListener(this);
        }
    }

    public void replaceMember(Item oldItem, Item newItem) {
        if (oldItem == null || newItem == null) {
            throw new IllegalArgumentException("Items must not be null!");
        }
        int index = this.members.indexOf(oldItem);
        if (index > -1) {
            Item old = this.members.set(index, newItem);
            this.unregisterStateListener(old);
        }
        this.registerStateListener(newItem);
    }

    public void removeMember(Item item) {
        if (item == null) {
            throw new IllegalArgumentException("Item must not be null!");
        }
        this.members.remove(item);
        this.unregisterStateListener(item);
    }

    public void removeAllMembers() {
        for (Item member : this.getMembers()) {
            this.unregisterStateListener(member);
        }
        this.members.clear();
    }

    @Override
    public List<Class<? extends State>> getAcceptedDataTypes() {
        if (this.baseItem != null) {
            return this.baseItem.getAcceptedDataTypes();
        }
        ArrayList<Class<? extends State>> acceptedDataTypes = null;
        for (Item item : this.members) {
            if (acceptedDataTypes == null) {
                acceptedDataTypes = new ArrayList<Class<? extends State>>(item.getAcceptedDataTypes());
                continue;
            }
            acceptedDataTypes.retainAll(item.getAcceptedDataTypes());
        }
        return acceptedDataTypes == null ? List.of() : Collections.unmodifiableList(acceptedDataTypes);
    }

    @Override
    public List<Class<? extends Command>> getAcceptedCommandTypes() {
        if (this.baseItem != null) {
            return this.baseItem.getAcceptedCommandTypes();
        }
        ArrayList<Class<? extends Command>> acceptedCommandTypes = null;
        for (Item item : this.members) {
            if (acceptedCommandTypes == null) {
                acceptedCommandTypes = new ArrayList<Class<? extends Command>>(item.getAcceptedCommandTypes());
                continue;
            }
            acceptedCommandTypes.retainAll(item.getAcceptedCommandTypes());
        }
        return acceptedCommandTypes == null ? List.of() : Collections.unmodifiableList(acceptedCommandTypes);
    }

    public void send(Command command) {
        if (this.getAcceptedCommandTypes().contains(command.getClass())) {
            this.internalSend(command);
        } else {
            this.logger.warn("Command '{}' has been ignored for group '{}' as it is not accepted.", (Object)command, (Object)this.getName());
        }
    }

    @Override
    protected void internalSend(Command command) {
        if (this.eventPublisher != null) {
            for (Item member : this.members) {
                this.eventPublisher.post(ItemEventFactory.createCommandEvent(member.getName(), command));
            }
        }
    }

    @Override
    public <T extends State> @Nullable T getStateAs(Class<T> typeClass) {
        @Nullable T newState = null;
        if (this.function != null) {
            newState = this.function.getStateAs(this.getStateMembers(this.getMembers()), typeClass);
        }
        if (newState == null && this.baseItem != null && this.baseItem instanceof GenericItem var3_4) {
            item.setState(this.state);
            newState = this.baseItem.getStateAs(typeClass);
        }
        if (newState == null) {
            newState = super.getStateAs(typeClass);
        }
        return newState;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getName());
        sb.append(" (");
        sb.append("Type=");
        sb.append(this.getClass().getSimpleName());
        sb.append(", ");
        if (this.getBaseItem() != null) {
            sb.append("BaseType=");
            sb.append(this.baseItem.getClass().getSimpleName());
            sb.append(", ");
        }
        sb.append("Members=");
        sb.append(this.members.size());
        sb.append(", ");
        sb.append("State=");
        sb.append(this.getState());
        sb.append(", ");
        sb.append("Label=");
        sb.append(this.getLabel());
        sb.append(", ");
        sb.append("Category=");
        sb.append(this.getCategory());
        if (!this.getTags().isEmpty()) {
            sb.append(", ");
            sb.append("Tags=[");
            sb.append(this.getTags().stream().collect(Collectors.joining(", ")));
            sb.append("]");
        }
        if (!this.getGroupNames().isEmpty()) {
            sb.append(", ");
            sb.append("Groups=[");
            sb.append(this.getGroupNames().stream().collect(Collectors.joining(", ")));
            sb.append("]");
        }
        sb.append(")");
        return sb.toString();
    }

    @Override
    public void stateChanged(Item item, State oldState, State newState) {
    }

    @Override
    public void stateUpdated(Item item, State state) {
        State oldState;
        State newState = oldState = this.state;
        if (this.function != null && this.baseItem != null && this.itemStateConverter != null) {
            State calculatedState = this.function.calculate(this.getStateMembers(this.getMembers()));
            newState = this.itemStateConverter.convertToAcceptedState(calculatedState, this.baseItem);
            this.setState(newState);
            this.sendGroupStateUpdatedEvent(item.getName(), newState);
        }
        if (!oldState.equals(newState)) {
            this.sendGroupStateChangedEvent(item.getName(), newState, oldState);
        }
    }

    @Override
    public void setState(State state) {
        State oldState = this.state;
        if (this.baseItem != null && this.baseItem instanceof GenericItem var3_4) {
            item.setState(state);
            this.state = this.baseItem.getState();
        } else {
            this.state = state;
        }
        this.notifyListeners(oldState, state);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setStateDescriptionService(@Nullable StateDescriptionService stateDescriptionService) {
        void var3_2;
        GenericItem genericItem;
        super.setStateDescriptionService(stateDescriptionService);
        Item item = this.baseItem;
        if (item instanceof GenericItem && (genericItem = (GenericItem)item) == (GenericItem)var3_2) {
            void item2;
            item2.setStateDescriptionService(stateDescriptionService);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setCommandDescriptionService(@Nullable CommandDescriptionService commandDescriptionService) {
        void var3_2;
        GenericItem genericItem;
        super.setCommandDescriptionService(commandDescriptionService);
        Item item = this.baseItem;
        if (item instanceof GenericItem && (genericItem = (GenericItem)item) == (GenericItem)var3_2) {
            void item2;
            item2.setCommandDescriptionService(commandDescriptionService);
        }
    }

    private void sendGroupStateUpdatedEvent(String memberName, State state) {
        EventPublisher eventPublisher1 = this.eventPublisher;
        if (eventPublisher1 != null) {
            eventPublisher1.post(ItemEventFactory.createGroupStateUpdatedEvent(this.getName(), memberName, state, null));
        }
    }

    private void sendGroupStateChangedEvent(String memberName, State newState, State oldState) {
        EventPublisher eventPublisher1 = this.eventPublisher;
        if (eventPublisher1 != null) {
            eventPublisher1.post(ItemEventFactory.createGroupStateChangedEvent(this.getName(), memberName, newState, oldState));
        }
    }

    private Set<Item> getStateMembers(Set<Item> items) {
        HashSet<Item> result = new HashSet<Item>();
        this.collectStateMembers(result, items);
        return result.stream().filter(i -> !this.isGroupItem((Item)i) || this.hasOwnState((GroupItem)i)).collect(Collectors.toSet());
    }

    private void collectStateMembers(Set<Item> result, Set<Item> items) {
        for (Item item : items) {
            if (result.contains(item)) continue;
            if (!this.isGroupItem(item) || this.isGroupItem(item) && this.hasOwnState((GroupItem)item)) {
                result.add(item);
                continue;
            }
            result.add(item);
            this.collectStateMembers(result, ((GroupItem)item).getMembers());
        }
    }

    private boolean isGroupItem(Item item) {
        return item instanceof GroupItem;
    }

    private boolean hasOwnState(GroupItem item) {
        return item.getFunction() != null && item.getBaseItem() != null;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void addedMetadata(Metadata metadata) {
        void var3_2;
        MetadataAwareItem metadataAwareItem;
        Item item = this.baseItem;
        if (item instanceof MetadataAwareItem && (metadataAwareItem = (MetadataAwareItem)((Object)item)) == (MetadataAwareItem)var3_2) {
            void metadataAwareItem2;
            metadataAwareItem2.addedMetadata(metadata);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void updatedMetadata(Metadata oldMetadata, Metadata newMetadata) {
        Item item = this.baseItem;
        if (item instanceof MetadataAwareItem var3_4) {
            void metadataAwareItem;
            metadataAwareItem.updatedMetadata(oldMetadata, newMetadata);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void removedMetadata(Metadata metadata) {
        void var3_2;
        MetadataAwareItem metadataAwareItem;
        Item item = this.baseItem;
        if (item instanceof MetadataAwareItem && (metadataAwareItem = (MetadataAwareItem)((Object)item)) == (MetadataAwareItem)var3_2) {
            void metadataAwareItem2;
            metadataAwareItem2.removedMetadata(metadata);
        }
    }
}

