/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.internal.service;

import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Consumer;
import org.openhab.core.service.ReadyMarker;
import org.openhab.core.service.ReadyMarkerFilter;
import org.openhab.core.service.ReadyService;
import org.osgi.service.component.annotations.Component;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component
public class ReadyServiceImpl
implements ReadyService {
    private final Logger logger = LoggerFactory.getLogger(ReadyServiceImpl.class);
    private static final ReadyMarkerFilter ANY = new ReadyMarkerFilter();
    private final Set<ReadyMarker> markers = Collections.synchronizedSet(new LinkedHashSet());
    private final Map<ReadyService.ReadyTracker, ReadyMarkerFilter> trackers = new HashMap<ReadyService.ReadyTracker, ReadyMarkerFilter>();
    private final ReentrantReadWriteLock rwlTrackers = new ReentrantReadWriteLock(true);

    @Override
    public void markReady(ReadyMarker readyMarker) {
        this.rwlTrackers.readLock().lock();
        try {
            boolean isNew = this.markers.add(readyMarker);
            if (isNew) {
                this.notifyTrackers(readyMarker, tracker -> tracker.onReadyMarkerAdded(readyMarker));
                this.logger.trace("Added ready marker {}", (Object)readyMarker);
            }
        }
        finally {
            this.rwlTrackers.readLock().unlock();
        }
    }

    @Override
    public void unmarkReady(ReadyMarker readyMarker) {
        this.rwlTrackers.readLock().lock();
        try {
            boolean isRemoved = this.markers.remove(readyMarker);
            if (isRemoved) {
                this.notifyTrackers(readyMarker, tracker -> tracker.onReadyMarkerRemoved(readyMarker));
                this.logger.trace("Removed ready marker {}", (Object)readyMarker);
            }
        }
        finally {
            this.rwlTrackers.readLock().unlock();
        }
    }

    private void notifyTrackers(ReadyMarker readyMarker, Consumer<ReadyService.ReadyTracker> action) {
        this.trackers.entrySet().stream().filter(entry -> ((ReadyMarkerFilter)entry.getValue()).apply(readyMarker)).map(Map.Entry::getKey).forEach(action);
    }

    @Override
    public boolean isReady(ReadyMarker readyMarker) {
        return this.markers.contains(readyMarker);
    }

    @Override
    public void registerTracker(ReadyService.ReadyTracker readyTracker) {
        this.registerTracker(readyTracker, ANY);
    }

    @Override
    public void registerTracker(ReadyService.ReadyTracker readyTracker, ReadyMarkerFilter filter) {
        this.rwlTrackers.writeLock().lock();
        try {
            try {
                if (!this.trackers.containsKey(readyTracker)) {
                    this.trackers.put(readyTracker, filter);
                    this.notifyTracker(readyTracker, readyTracker::onReadyMarkerAdded);
                }
            }
            catch (RuntimeException e) {
                this.logger.error("Registering tracker '{}' failed!", (Object)readyTracker, (Object)e);
                this.rwlTrackers.writeLock().unlock();
            }
        }
        finally {
            this.rwlTrackers.writeLock().unlock();
        }
    }

    @Override
    public void unregisterTracker(ReadyService.ReadyTracker readyTracker) {
        this.rwlTrackers.writeLock().lock();
        try {
            if (this.trackers.containsKey(readyTracker)) {
                this.notifyTracker(readyTracker, readyTracker::onReadyMarkerRemoved);
            }
            this.trackers.remove(readyTracker);
        }
        finally {
            this.rwlTrackers.writeLock().unlock();
        }
    }

    private void notifyTracker(ReadyService.ReadyTracker readyTracker, Consumer<ReadyMarker> action) {
        ReadyMarkerFilter f = this.trackers.get(readyTracker);
        this.markers.stream().filter(f::apply).forEach(action);
    }
}

