/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.internal.library.unit;

import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.math.MathContext;
import java.util.Map;
import java.util.Objects;
import javax.measure.UnitConverter;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import tech.units.indriya.function.AbstractConverter;
import tech.units.indriya.function.Calculus;

@NonNullByDefault
public class CurrencyConverter
extends AbstractConverter {
    private final BigDecimal factor;

    static {
        Map normalFormOrder = Calculus.getNormalFormOrder();
        try {
            Field field = Calculus.class.getDeclaredField("normalFormOrder");
            field.setAccessible(true);
            Map original = (Map)field.get(null);
            original.put(CurrencyConverter.class, 1000);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new IllegalStateException("Could not add currency converter", e);
        }
    }

    public CurrencyConverter(BigDecimal factor) {
        this.factor = factor;
    }

    /*
     * WARNING - void declaration
     */
    public boolean equals(@Nullable Object cvtr) {
        void currencyConverter;
        void var3_2;
        CurrencyConverter currencyConverter2;
        Object object = cvtr;
        return object instanceof CurrencyConverter && (currencyConverter2 = (CurrencyConverter)((Object)object)) == (CurrencyConverter)var3_2 && this.factor.equals(currencyConverter.factor);
    }

    public int hashCode() {
        return Objects.hashCode(this.factor);
    }

    protected @Nullable String transformationLiteral() {
        return null;
    }

    protected AbstractConverter inverseWhenNotIdentity() {
        return new CurrencyConverter(BigDecimal.ONE.divide(this.factor, MathContext.DECIMAL128));
    }

    protected boolean canReduceWith(@Nullable AbstractConverter that) {
        return false;
    }

    protected Number convertWhenNotIdentity(@NonNullByDefault(value={}) Number value) {
        return new BigDecimal(value.toString()).multiply(this.factor, MathContext.DECIMAL128);
    }

    /*
     * WARNING - void declaration
     */
    public int compareTo(@Nullable UnitConverter o) {
        void currencyConverter;
        void var3_2;
        CurrencyConverter currencyConverter2;
        UnitConverter unitConverter = o;
        return unitConverter instanceof CurrencyConverter && (currencyConverter2 = (CurrencyConverter)unitConverter) == (CurrencyConverter)var3_2 ? this.factor.compareTo(currencyConverter.factor) : -1;
    }

    public boolean isIdentity() {
        return false;
    }

    public boolean isLinear() {
        return true;
    }
}

