/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.internal.items;

import org.eclipse.jdt.annotation.NonNullByDefault;
import org.openhab.core.events.EventSubscriber;
import org.openhab.core.items.GenericItem;
import org.openhab.core.items.GroupItem;
import org.openhab.core.items.Item;
import org.openhab.core.items.ItemNotFoundException;
import org.openhab.core.items.ItemRegistry;
import org.openhab.core.items.events.AbstractItemEventSubscriber;
import org.openhab.core.items.events.ItemCommandEvent;
import org.openhab.core.items.events.ItemStateEvent;
import org.openhab.core.items.events.ItemTimeSeriesEvent;
import org.openhab.core.types.State;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NonNullByDefault
@Component(immediate=true, service={EventSubscriber.class})
public class ItemUpdater
extends AbstractItemEventSubscriber {
    private final Logger logger = LoggerFactory.getLogger(ItemUpdater.class);
    private final ItemRegistry itemRegistry;

    @Activate
    public ItemUpdater(@Reference ItemRegistry itemRegistry) {
        this.itemRegistry = itemRegistry;
    }

    @Override
    protected void receiveUpdate(ItemStateEvent updateEvent) {
        String itemName = updateEvent.getItemName();
        State newState = updateEvent.getItemState();
        try {
            GenericItem item = (GenericItem)this.itemRegistry.getItem(itemName);
            boolean isAccepted = false;
            if (item.getAcceptedDataTypes().contains(newState.getClass())) {
                isAccepted = true;
            } else {
                for (Class<? extends State> state : item.getAcceptedDataTypes()) {
                    try {
                        if (state.isEnum() || !state.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]).getClass().isAssignableFrom(newState.getClass())) continue;
                        isAccepted = true;
                        break;
                    }
                    catch (ReflectiveOperationException e) {
                        this.logger.warn("{} while creating {} instance: {}", new Object[]{e.getClass().getSimpleName(), state.getClass().getSimpleName(), e.getMessage()});
                    }
                }
            }
            if (isAccepted) {
                item.setState(newState);
            } else {
                this.logger.debug("Received update of a not accepted type ({}) for item {}", (Object)newState.getClass().getSimpleName(), (Object)itemName);
            }
        }
        catch (ItemNotFoundException e) {
            this.logger.debug("Received update for non-existing item: {}", (Object)e.getMessage());
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void receiveCommand(ItemCommandEvent commandEvent) {
        try {
            Item item;
            Item item2 = item = this.itemRegistry.getItem(commandEvent.getItemName());
            if (item2 instanceof GroupItem var3_5) {
                void groupItem;
                groupItem.send(commandEvent.getItemCommand());
            }
        }
        catch (ItemNotFoundException e) {
            this.logger.debug("Received command for non-existing item: {}", (Object)e.getMessage());
        }
    }

    @Override
    protected void receiveTimeSeries(ItemTimeSeriesEvent timeSeriesEvent) {
        try {
            Item item = this.itemRegistry.getItem(timeSeriesEvent.getItemName());
            if (!(item instanceof GroupItem) && item instanceof GenericItem var3_5) {
                genericItem.setTimeSeries(timeSeriesEvent.getTimeSeries());
            }
        }
        catch (ItemNotFoundException e) {
            this.logger.debug("Received command for non-existing item: {}", (Object)e.getMessage());
        }
    }
}

