/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.internal.items;

import java.util.ArrayList;
import java.util.List;
import javax.measure.Quantity;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.openhab.core.items.GroupFunction;
import org.openhab.core.items.Item;
import org.openhab.core.items.dto.GroupFunctionDTO;
import org.openhab.core.library.items.NumberItem;
import org.openhab.core.library.types.ArithmeticGroupFunction;
import org.openhab.core.library.types.DateTimeGroupFunction;
import org.openhab.core.library.types.QuantityTypeArithmeticGroupFunction;
import org.openhab.core.library.types.StringType;
import org.openhab.core.types.State;
import org.openhab.core.types.TypeParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NonNullByDefault
public class GroupFunctionHelper {
    private final Logger logger = LoggerFactory.getLogger(GroupFunctionHelper.class);

    public GroupFunction createGroupFunction(GroupFunctionDTO function, @Nullable Item baseItem) {
        Class<? extends Quantity<?>> dimension = this.getDimension(baseItem);
        if (dimension != null) {
            return this.createDimensionGroupFunction(function, baseItem, dimension);
        }
        return this.createDefaultGroupFunction(function, baseItem);
    }

    private List<State> parseStates(@Nullable Item baseItem, String @Nullable [] params) {
        if (params == null || baseItem == null) {
            return List.of();
        }
        ArrayList<State> states = new ArrayList<State>();
        String[] stringArray = params;
        int n = params.length;
        int n2 = 0;
        while (n2 < n) {
            String param = stringArray[n2];
            State state = TypeParser.parseState(baseItem.getAcceptedDataTypes(), param);
            if (state == null) {
                this.logger.warn("State '{}' is not valid for a group item with base type '{}'", (Object)param, (Object)baseItem.getType());
                states.clear();
                break;
            }
            states.add(state);
            ++n2;
        }
        return states;
    }

    private @Nullable Class<? extends Quantity<?>> getDimension(@Nullable Item baseItem) {
        if (baseItem instanceof NumberItem) {
            return ((NumberItem)baseItem).getDimension();
        }
        return null;
    }

    private GroupFunction createDimensionGroupFunction(GroupFunctionDTO function, @Nullable Item baseItem, Class<? extends Quantity<?>> dimension) {
        String functionName = function.name;
        switch (functionName.toUpperCase()) {
            case "AVG": {
                return new QuantityTypeArithmeticGroupFunction.Avg(dimension);
            }
            case "SUM": {
                return new QuantityTypeArithmeticGroupFunction.Sum(dimension);
            }
            case "MIN": {
                return new QuantityTypeArithmeticGroupFunction.Min(dimension);
            }
            case "MAX": {
                return new QuantityTypeArithmeticGroupFunction.Max(dimension);
            }
        }
        return this.createDefaultGroupFunction(function, baseItem);
    }

    private GroupFunction createDefaultGroupFunction(GroupFunctionDTO function, @Nullable Item baseItem) {
        String functionName = function.name;
        switch (functionName.toUpperCase()) {
            case "AND": {
                List<State> args = this.parseStates(baseItem, function.params);
                if (args.size() == 2) {
                    return new ArithmeticGroupFunction.And(args.get(0), args.get(1));
                }
                this.logger.error("Group function 'AND' requires two arguments. Using Equality instead.");
                break;
            }
            case "OR": {
                List<State> args = this.parseStates(baseItem, function.params);
                if (args.size() == 2) {
                    return new ArithmeticGroupFunction.Or(args.get(0), args.get(1));
                }
                this.logger.error("Group function 'OR' requires two arguments. Using Equality instead.");
                break;
            }
            case "NAND": {
                List<State> args = this.parseStates(baseItem, function.params);
                if (args.size() == 2) {
                    return new ArithmeticGroupFunction.NAnd(args.get(0), args.get(1));
                }
                this.logger.error("Group function 'NOT AND' requires two arguments. Using Equality instead.");
                break;
            }
            case "NOR": {
                List<State> args = this.parseStates(baseItem, function.params);
                if (args.size() == 2) {
                    return new ArithmeticGroupFunction.NOr(args.get(0), args.get(1));
                }
                this.logger.error("Group function 'NOT OR' requires two arguments. Using Equality instead.");
                break;
            }
            case "COUNT": {
                if (function.params != null && function.params.length == 1) {
                    StringType countParam = new StringType(function.params[0]);
                    return new ArithmeticGroupFunction.Count(countParam);
                }
                this.logger.error("Group function 'COUNT' requires one argument. Using Equality instead.");
                break;
            }
            case "AVG": {
                return new ArithmeticGroupFunction.Avg();
            }
            case "SUM": {
                return new ArithmeticGroupFunction.Sum();
            }
            case "MIN": {
                return new ArithmeticGroupFunction.Min();
            }
            case "MAX": {
                return new ArithmeticGroupFunction.Max();
            }
            case "LATEST": {
                return new DateTimeGroupFunction.Latest();
            }
            case "EARLIEST": {
                return new DateTimeGroupFunction.Earliest();
            }
            case "EQUALITY": {
                return new GroupFunction.Equality();
            }
            default: {
                this.logger.error("Unknown group function '{}'. Using Equality instead.", (Object)functionName);
            }
        }
        return new GroupFunction.Equality();
    }
}

