/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.cache;

import java.time.Duration;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Supplier;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.openhab.core.cache.ExpiringCache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NonNullByDefault
public class ExpiringCacheMap<K, V> {
    private final Logger logger = LoggerFactory.getLogger(ExpiringCacheMap.class);
    private final long expiry;
    private final ConcurrentMap<K, ExpiringCache<@Nullable V>> items;

    public ExpiringCacheMap(Duration expiry) {
        this(expiry.toMillis());
    }

    public ExpiringCacheMap(long expiry) {
        this.expiry = expiry;
        this.items = new ConcurrentHashMap<K, ExpiringCache<V>>();
    }

    public void put(K key, Supplier<@Nullable V> action) {
        this.put(key, new ExpiringCache<V>(this.expiry, action));
    }

    public void put(K key, ExpiringCache<@Nullable V> item) {
        if (key == null) {
            throw new IllegalArgumentException("Item cannot be added as key is null.");
        }
        this.items.put(key, item);
    }

    public void putIfAbsent(K key, ExpiringCache<V> item) {
        if (key == null) {
            throw new IllegalArgumentException("Item cannot be added as key is null.");
        }
        this.items.putIfAbsent(key, item);
    }

    public @Nullable V putIfAbsentAndGet(K key, Supplier<V> action) {
        return this.putIfAbsentAndGet(key, new ExpiringCache<V>(this.expiry, action));
    }

    public @Nullable V putIfAbsentAndGet(K key, ExpiringCache<V> item) {
        this.putIfAbsent(key, item);
        return this.get(key);
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public void putValue(K key, @Nullable V value) {
        @Nullable ExpiringCache item = (ExpiringCache)this.items.get(key);
        if (item == null) {
            throw new IllegalArgumentException(String.format("No item found for key '%s' .", key));
        }
        item.putValue(value);
    }

    public boolean containsKey(K key) {
        return this.items.containsKey(key);
    }

    public void remove(K key) {
        this.items.remove(key);
    }

    public void clear() {
        this.items.clear();
    }

    public synchronized Set<K> keys() {
        LinkedHashSet keys = new LinkedHashSet();
        for (Object key : this.items.keySet()) {
            keys.add(key);
        }
        return keys;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public @Nullable V get(K key) {
        @Nullable ExpiringCache item = (ExpiringCache)this.items.get(key);
        if (item == null) {
            this.logger.debug("No item for key '{}' found", key);
            return null;
        }
        return item.getValue();
    }

    public synchronized Collection<@Nullable V> values() {
        LinkedList<@Nullable V> values = new LinkedList();
        for (ExpiringCache item : this.items.values()) {
            values.add(item.getValue());
        }
        return values;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public synchronized void invalidate(K key) {
        @Nullable ExpiringCache item = (ExpiringCache)this.items.get(key);
        if (item == null) {
            this.logger.debug("No item for key '{}' found", key);
        } else {
            item.invalidateValue();
        }
    }

    public synchronized void invalidateAll() {
        this.items.values().forEach(ExpiringCache::invalidateValue);
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public synchronized @Nullable V refresh(K key) {
        @Nullable ExpiringCache item = (ExpiringCache)this.items.get(key);
        if (item == null) {
            this.logger.debug("No item for key '{}' found", key);
            return null;
        }
        return item.refreshValue();
    }

    public synchronized Collection<@Nullable V> refreshAll() {
        LinkedList<@Nullable V> values = new LinkedList();
        for (ExpiringCache item : this.items.values()) {
            values.add(item.refreshValue());
        }
        return values;
    }
}

