/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.auth.client.oauth2;

import java.io.Serializable;
import java.time.Instant;
import java.util.Objects;

public final class AccessTokenResponse
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 4837164195629364014L;
    private String accessToken;
    private String tokenType;
    private long expiresIn;
    private String refreshToken;
    private String scope;
    private String state;
    private Instant createdOn;

    public boolean isExpired(Instant givenTime, int tokenExpiresInBuffer) {
        return this.createdOn == null || this.createdOn.plusSeconds(this.expiresIn).minusSeconds(tokenExpiresInBuffer).isBefore(givenTime);
    }

    public String getAccessToken() {
        return this.accessToken;
    }

    public void setAccessToken(String accessToken) {
        this.accessToken = accessToken;
    }

    public String getTokenType() {
        return this.tokenType;
    }

    public void setTokenType(String tokenType) {
        this.tokenType = tokenType;
    }

    public long getExpiresIn() {
        return this.expiresIn;
    }

    public void setExpiresIn(long expiresIn) {
        this.expiresIn = expiresIn;
    }

    public String getRefreshToken() {
        return this.refreshToken;
    }

    public void setRefreshToken(String refreshToken) {
        this.refreshToken = refreshToken;
    }

    public String getScope() {
        return this.scope;
    }

    public void setScope(String scope) {
        this.scope = scope;
    }

    public String getState() {
        return this.state;
    }

    public void setState(String state) {
        this.state = state;
    }

    public Instant getCreatedOn() {
        return this.createdOn;
    }

    public void setCreatedOn(Instant createdOn) {
        this.createdOn = createdOn;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("not possible", e);
        }
    }

    public int hashCode() {
        return Objects.hash(this.accessToken, this.tokenType, this.expiresIn, this.refreshToken, this.scope, this.state, this.createdOn);
    }

    public boolean equals(Object thatAuthTokenObj) {
        if (this == thatAuthTokenObj) {
            return true;
        }
        if (thatAuthTokenObj == null || !this.getClass().equals(thatAuthTokenObj.getClass())) {
            return false;
        }
        AccessTokenResponse that = (AccessTokenResponse)thatAuthTokenObj;
        return Objects.equals(this.accessToken, that.accessToken) && Objects.equals(this.tokenType, that.tokenType) && Objects.equals(this.expiresIn, that.expiresIn) && Objects.equals(this.refreshToken, that.refreshToken) && Objects.equals(this.scope, that.scope) && Objects.equals(this.state, that.state) && Objects.equals(this.createdOn, that.createdOn);
    }

    public String toString() {
        return "AccessTokenResponse [accessToken=" + this.accessToken + ", tokenType=" + this.tokenType + ", expiresIn=" + this.expiresIn + ", refreshToken=" + this.refreshToken + ", scope=" + this.scope + ", state=" + this.state + ", createdOn=" + this.createdOn + "]";
    }
}

