/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.automation.module.media.internal;

import java.math.BigDecimal;
import java.util.Map;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.openhab.core.audio.AudioException;
import org.openhab.core.audio.AudioManager;
import org.openhab.core.automation.Action;
import org.openhab.core.automation.handler.BaseActionModuleHandler;
import org.openhab.core.library.types.PercentType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NonNullByDefault
public class PlayActionHandler
extends BaseActionModuleHandler {
    public static final String TYPE_ID = "media.PlayAction";
    public static final String PARAM_SOUND = "sound";
    public static final String PARAM_SINK = "sink";
    public static final String PARAM_VOLUME = "volume";
    private final Logger logger = LoggerFactory.getLogger(PlayActionHandler.class);
    private final AudioManager audioManager;
    private final String sound;
    private final @Nullable String sink;
    private final @Nullable PercentType volume;

    /*
     * WARNING - void declaration
     */
    public PlayActionHandler(Action module, AudioManager audioManager) {
        super(module);
        void bd;
        BigDecimal bigDecimal;
        Object volumeParam;
        this.audioManager = audioManager;
        this.sound = module.getConfiguration().get(PARAM_SOUND).toString();
        Object sinkParam = module.getConfiguration().get(PARAM_SINK);
        this.sink = sinkParam != null ? sinkParam.toString() : null;
        Object object = volumeParam = module.getConfiguration().get(PARAM_VOLUME);
        this.volume = object instanceof BigDecimal && (bigDecimal = (BigDecimal)object) == (BigDecimal)object ? new PercentType((BigDecimal)bd) : null;
    }

    public @Nullable Map<String, Object> execute(Map<String, Object> context) {
        try {
            this.audioManager.playFile(this.sound, this.sink, this.volume);
        }
        catch (AudioException e) {
            this.logger.error("Error playing sound '{}': {}", (Object)this.sound, (Object)e.getMessage());
        }
        return null;
    }
}

