/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.io.net.http.internal;

import java.net.Socket;
import java.security.cert.CertificateException;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.X509ExtendedTrustManager;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.openhab.core.io.net.http.ExtensibleTrustManager;
import org.openhab.core.io.net.http.TlsCertificateProvider;
import org.openhab.core.io.net.http.TlsTrustManagerProvider;
import org.openhab.core.io.net.http.internal.TlsCertificateTrustManagerAdapter;
import org.openhab.core.io.net.http.internal.TrustManagerUtil;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={ExtensibleTrustManager.class}, immediate=true)
@NonNullByDefault
public class ExtensibleTrustManagerImpl
extends X509ExtendedTrustManager
implements ExtensibleTrustManager {
    private final Logger logger = LoggerFactory.getLogger(ExtensibleTrustManagerImpl.class);
    private static final Queue<X509ExtendedTrustManager> EMPTY_QUEUE = new ConcurrentLinkedQueue<X509ExtendedTrustManager>();
    private final X509ExtendedTrustManager defaultTrustManager = TrustManagerUtil.keyStoreToTrustManager(null);
    private final Map<String, Queue<X509ExtendedTrustManager>> linkedTrustManager = new ConcurrentHashMap<String, Queue<X509ExtendedTrustManager>>();
    private final Map<TlsCertificateProvider, X509ExtendedTrustManager> mappingFromTlsCertificateProvider = new ConcurrentHashMap<TlsCertificateProvider, X509ExtendedTrustManager>();

    @Override
    public void checkClientTrusted(X509Certificate @Nullable [] chain, @Nullable String authType) throws CertificateException {
        this.checkClientTrusted(chain, authType, (Socket)null);
    }

    @Override
    public void checkServerTrusted(X509Certificate @Nullable [] chain, @Nullable String authType) throws CertificateException {
        this.checkServerTrusted(chain, authType, (Socket)null);
    }

    @Override
    public X509Certificate[] getAcceptedIssuers() {
        return this.defaultTrustManager.getAcceptedIssuers();
    }

    @Override
    public void checkClientTrusted(X509Certificate @Nullable [] chain, @Nullable String authType, @Nullable Socket socket) throws CertificateException {
        X509ExtendedTrustManager linkedTrustManager = this.getLinkedTrustMananger(chain);
        if (linkedTrustManager == null) {
            this.logger.trace("No specific trust manager found, falling back to default");
            this.defaultTrustManager.checkClientTrusted(chain, authType, socket);
        } else {
            linkedTrustManager.checkClientTrusted(chain, authType, socket);
        }
    }

    @Override
    public void checkClientTrusted(X509Certificate @Nullable [] chain, @Nullable String authType, @Nullable SSLEngine sslEngine) throws CertificateException {
        X509ExtendedTrustManager linkedTrustManager = this.getLinkedTrustMananger(chain, sslEngine);
        if (linkedTrustManager == null) {
            this.logger.trace("No specific trust manager found, falling back to default");
            this.defaultTrustManager.checkClientTrusted(chain, authType, sslEngine);
        } else {
            linkedTrustManager.checkClientTrusted(chain, authType, sslEngine);
        }
    }

    @Override
    public void checkServerTrusted(X509Certificate @Nullable [] chain, @Nullable String authType, @Nullable Socket socket) throws CertificateException {
        X509ExtendedTrustManager linkedTrustManager = this.getLinkedTrustMananger(chain);
        if (linkedTrustManager == null) {
            this.logger.trace("No specific trust manager found, falling back to default");
            this.defaultTrustManager.checkServerTrusted(chain, authType, socket);
        } else {
            linkedTrustManager.checkServerTrusted(chain, authType, socket);
        }
    }

    @Override
    public void checkServerTrusted(X509Certificate @Nullable [] chain, @Nullable String authType, @Nullable SSLEngine sslEngine) throws CertificateException {
        X509ExtendedTrustManager linkedTrustManager = this.getLinkedTrustMananger(chain, sslEngine);
        if (linkedTrustManager == null) {
            this.logger.trace("No specific trust manager found, falling back to default");
            this.defaultTrustManager.checkServerTrusted(chain, authType, sslEngine);
        } else {
            linkedTrustManager.checkServerTrusted(chain, authType, sslEngine);
        }
    }

    private @Nullable X509ExtendedTrustManager getLinkedTrustMananger(X509Certificate @Nullable [] chain, @Nullable SSLEngine sslEngine) {
        if (sslEngine != null) {
            X509ExtendedTrustManager trustManager = null;
            String peer = null;
            if (sslEngine.getPeerHost() != null) {
                peer = String.valueOf(sslEngine.getPeerHost()) + ":" + sslEngine.getPeerPort();
                trustManager = this.linkedTrustManager.getOrDefault(peer, EMPTY_QUEUE).peek();
            }
            if (trustManager != null) {
                this.logger.trace("Found trustManager by sslEngine peer/host: {}", peer);
                return trustManager;
            }
            this.logger.trace("Did NOT find trustManager by sslEngine peer/host: {}", peer);
        }
        return this.getLinkedTrustMananger(chain);
    }

    private @Nullable X509ExtendedTrustManager getLinkedTrustMananger(X509Certificate @Nullable [] chain) {
        if (chain != null) {
            try {
                String commonName = this.getCommonName(chain[0]);
                X509ExtendedTrustManager trustManager = this.linkedTrustManager.getOrDefault(commonName, EMPTY_QUEUE).peek();
                if (trustManager != null) {
                    this.logger.trace("Found trustManager by common name: {}", (Object)commonName);
                    return trustManager;
                }
                Collection<List<?>> subjectAlternatives = this.getSubjectAlternatives(chain);
                this.logger.trace("Searching trustManager by Subject Alternative Names: {}", subjectAlternatives);
                return subjectAlternatives.stream().map(e -> e.get(1)).map(Object::toString).map(this.linkedTrustManager::get).map(queue -> queue == null ? null : (X509ExtendedTrustManager)queue.peek()).filter(Objects::nonNull).findFirst().orElse(null);
            }
            catch (CommonNameNotFoundException e2) {
                this.logger.debug("CN not found", (Throwable)e2);
            }
            catch (CertificateParsingException e3) {
                this.logger.debug("Problem while parsing certificate", (Throwable)e3);
            }
        }
        return null;
    }

    private Collection<List<?>> getSubjectAlternatives(X509Certificate[] chain) throws CertificateParsingException {
        Collection<List<?>> subjectAlternativeNames = chain[0].getSubjectAlternativeNames();
        return subjectAlternativeNames != null ? subjectAlternativeNames : List.of();
    }

    private String getCommonName(X509Certificate x509Certificate) {
        String dn = x509Certificate.getSubjectX500Principal().getName("RFC2253");
        String[] stringArray = dn.split(",");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String group = stringArray[n2];
            if (group.contains("CN=")) {
                return group.trim().replace("CN=", "");
            }
            ++n2;
        }
        throw new CommonNameNotFoundException("No Common Name found in: '" + dn + "'");
    }

    @Override
    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    public void addTlsCertificateProvider(TlsCertificateProvider tlsCertificateProvider) {
        X509ExtendedTrustManager trustManager = new TlsCertificateTrustManagerAdapter(tlsCertificateProvider).getTrustManager();
        this.mappingFromTlsCertificateProvider.put(tlsCertificateProvider, trustManager);
        this.addLinkedTrustManager(tlsCertificateProvider.getHostName(), trustManager);
    }

    @Override
    public void removeTlsCertificateProvider(TlsCertificateProvider tlsCertificateProvider) {
        X509ExtendedTrustManager trustManager = this.mappingFromTlsCertificateProvider.remove(tlsCertificateProvider);
        if (trustManager != null) {
            this.removeLinkedTrustManager(tlsCertificateProvider.getHostName(), trustManager);
        }
    }

    @Override
    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    public void addTlsTrustManagerProvider(TlsTrustManagerProvider tlsTrustManagerProvider) {
        this.addLinkedTrustManager(tlsTrustManagerProvider.getHostName(), tlsTrustManagerProvider.getTrustManager());
    }

    @Override
    public void removeTlsTrustManagerProvider(TlsTrustManagerProvider tlsTrustManagerProvider) {
        this.removeLinkedTrustManager(tlsTrustManagerProvider.getHostName(), tlsTrustManagerProvider.getTrustManager());
    }

    private void addLinkedTrustManager(String hostName, X509ExtendedTrustManager trustManager) {
        this.linkedTrustManager.computeIfAbsent(hostName, h -> new ConcurrentLinkedQueue()).add(trustManager);
    }

    private void removeLinkedTrustManager(String hostName, X509ExtendedTrustManager trustManager) {
        this.linkedTrustManager.computeIfAbsent(hostName, h -> new ConcurrentLinkedQueue()).remove(trustManager);
    }

    private static class CommonNameNotFoundException
    extends RuntimeException {
        private static final long serialVersionUID = -5861764697217665026L;

        public CommonNameNotFoundException(String message) {
            super(message);
        }
    }
}

