/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.io.net.http;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.Socket;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.util.Base64;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509ExtendedTrustManager;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.openhab.core.io.net.http.TrustAllTrustManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NonNullByDefault
public final class PEMTrustManager
extends X509ExtendedTrustManager {
    public static final String BEGIN_CERT = "-----BEGIN CERTIFICATE-----";
    public static final String END_CERT = "-----END CERTIFICATE-----";
    private final Logger logger;
    private final X509Certificate trustedCert;

    public PEMTrustManager(String pemCert) throws CertificateException {
        block12: {
            this.logger = LoggerFactory.getLogger(PEMTrustManager.class);
            if (!pemCert.isBlank() && pemCert.startsWith(BEGIN_CERT)) {
                try {
                    Throwable throwable = null;
                    Object var3_5 = null;
                    try (ByteArrayInputStream certInputStream = new ByteArrayInputStream(pemCert.getBytes(StandardCharsets.UTF_8));){
                        this.trustedCert = (X509Certificate)CertificateFactory.getInstance("X.509").generateCertificate(certInputStream);
                        break block12;
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (IOException e) {
                    this.logger.debug("An IOException occurred: {}", (Object)e.getMessage());
                    throw new CertificateInstantiationException(e);
                }
            }
            throw new CertificateParsingException("Certificate is either empty or cannot be parsed correctly");
        }
    }

    public static PEMTrustManager getInstanceFromFile(String path) throws FileNotFoundException, CertificateException {
        String pemCert = PEMTrustManager.readPEMCertificateStringFromFile(path);
        if (pemCert != null) {
            return new PEMTrustManager(pemCert);
        }
        throw new CertificateInstantiationException(String.format("Unable to read certificate from file: %s", path));
    }

    public static PEMTrustManager getInstanceFromServer(String url) throws MalformedURLException, CertificateException {
        return PEMTrustManager.getInstanceFromServer(new URL(url));
    }

    public static PEMTrustManager getInstanceFromServer(URL url) throws CertificateException {
        String pemCert = PEMTrustManager.getPEMCertificateFromServer(url);
        if (pemCert != null) {
            return new PEMTrustManager(pemCert);
        }
        throw new CertificateInstantiationException(String.format("Unable to load certificate from server: %s", url));
    }

    @Override
    public void checkClientTrusted(X509Certificate @Nullable [] chain, @Nullable String authType) throws CertificateException {
        this.validatePEMCertificate(chain);
    }

    @Override
    public void checkServerTrusted(X509Certificate @Nullable [] chain, @Nullable String authType) throws CertificateException {
        this.validatePEMCertificate(chain);
    }

    @Override
    public X509Certificate[] getAcceptedIssuers() {
        X509Certificate[] certs = new X509Certificate[]{this.trustedCert};
        return certs;
    }

    @Override
    public void checkClientTrusted(X509Certificate @Nullable [] chain, @Nullable String authType, @Nullable Socket socket) throws CertificateException {
        this.validatePEMCertificate(chain);
    }

    @Override
    public void checkClientTrusted(X509Certificate @Nullable [] chain, @Nullable String authType, @Nullable SSLEngine engine) throws CertificateException {
        this.validatePEMCertificate(chain);
    }

    @Override
    public void checkServerTrusted(X509Certificate @Nullable [] chain, @Nullable String authType, @Nullable Socket socket) throws CertificateException {
        this.validatePEMCertificate(chain);
    }

    @Override
    public void checkServerTrusted(X509Certificate @Nullable [] chain, @Nullable String authType, @Nullable SSLEngine engine) throws CertificateException {
        this.validatePEMCertificate(chain);
    }

    public int hashCode() {
        return this.trustedCert.hashCode();
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PEMTrustManager)) {
            return false;
        }
        return this.trustedCert.equals(((PEMTrustManager)obj).trustedCert);
    }

    private static @Nullable String getPEMCertificateFromServer(URL url) throws CertificateException {
        HttpURLConnection connection = null;
        try {
            TrustManager[] trustManagers = new TrustManager[]{TrustAllTrustManager.getInstance()};
            SSLContext sslContext = SSLContext.getInstance("SSL");
            sslContext.init(null, trustManagers, new SecureRandom());
            connection = (HttpsURLConnection)url.openConnection();
            ((HttpsURLConnection)connection).setSSLSocketFactory(sslContext.getSocketFactory());
            connection.connect();
            Certificate[] certs = ((HttpsURLConnection)connection).getServerCertificates();
            byte[] bytes = ((X509Certificate)certs[0]).getEncoded();
            if (bytes.length != 0) {
                String string = BEGIN_CERT + System.lineSeparator() + Base64.getEncoder().encodeToString(bytes) + System.lineSeparator() + END_CERT;
                return string;
            }
        }
        catch (IOException e) {
            LoggerFactory.getLogger(PEMTrustManager.class).debug("An IOException occurred: {}", (Object)e.getMessage());
            throw new CertificateInstantiationException(e);
        }
        catch (KeyManagementException | NoSuchAlgorithmException e) {
            LoggerFactory.getLogger(PEMTrustManager.class).error("An unexpected exception occurred: ", (Throwable)e);
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
        return null;
    }

    private static @Nullable String readPEMCertificateStringFromFile(String path) throws FileNotFoundException {
        File certFile = new File(path);
        if (certFile.exists()) {
            try {
                return new String(Files.readAllBytes(certFile.toPath()), StandardCharsets.UTF_8);
            }
            catch (IOException e) {
                LoggerFactory.getLogger(PEMTrustManager.class).error("An unexpected IOException occurred: ", (Throwable)e);
            }
        } else {
            throw new FileNotFoundException(String.format("File %s does not exist", path));
        }
        return null;
    }

    private void validatePEMCertificate(X509Certificate @Nullable [] chain) throws CertificateException {
        if (chain == null || !this.trustedCert.equals(chain[0])) {
            throw new CertificateException();
        }
    }

    public static class CertificateInstantiationException
    extends CertificateException {
        private static final long serialVersionUID = -5861764697217665026L;

        public CertificateInstantiationException(String message) {
            super(message);
        }

        public CertificateInstantiationException(Throwable cause) {
            super(cause);
        }
    }
}

