/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.model.script.lib;

import java.math.BigDecimal;
import java.math.RoundingMode;
import org.openhab.core.library.types.DecimalType;
import org.openhab.core.library.types.QuantityType;
import org.openhab.core.library.unit.Units;
import org.openhab.core.types.Type;

public class NumberExtensions {
    public static final BigDecimal NULL_DEFINITION = new BigDecimal(0);

    public static BigDecimal operator_plus(Number x, Number y) {
        BigDecimal xValue = NumberExtensions.numberToBigDecimal(x);
        BigDecimal yValue = NumberExtensions.numberToBigDecimal(y);
        if (xValue == null) {
            return yValue;
        }
        if (yValue == null) {
            return xValue;
        }
        return xValue.add(yValue);
    }

    public static BigDecimal operator_minus(Number x) {
        BigDecimal xValue = NumberExtensions.numberToBigDecimal(x);
        if (xValue == null) {
            return xValue;
        }
        return xValue.negate();
    }

    public static BigDecimal operator_minus(Number x, Number y) {
        BigDecimal xValue = NumberExtensions.numberToBigDecimal(x);
        BigDecimal yValue = NumberExtensions.numberToBigDecimal(y);
        if (xValue == null) {
            return NumberExtensions.operator_minus(yValue);
        }
        if (yValue == null) {
            return xValue;
        }
        return xValue.subtract(yValue);
    }

    public static BigDecimal operator_multiply(Number x, Number y) {
        BigDecimal xValue = NumberExtensions.numberToBigDecimal(x);
        BigDecimal yValue = NumberExtensions.numberToBigDecimal(y);
        if (xValue == null) {
            return NULL_DEFINITION;
        }
        if (yValue == null) {
            return NULL_DEFINITION;
        }
        return xValue.multiply(yValue);
    }

    public static BigDecimal operator_divide(Number x, Number y) {
        BigDecimal xValue = NumberExtensions.numberToBigDecimal(x);
        BigDecimal yValue = NumberExtensions.numberToBigDecimal(y);
        return xValue.divide(yValue, 8, RoundingMode.HALF_UP);
    }

    public static boolean operator_equals(Number left, Number right) {
        if (NumberExtensions.oneIsQuantity(left, right)) {
            return false;
        }
        BigDecimal leftValue = NumberExtensions.numberToBigDecimal(left);
        BigDecimal rightValue = NumberExtensions.numberToBigDecimal(right);
        if (leftValue == null) {
            return rightValue == null;
        }
        if (rightValue == null) {
            return false;
        }
        return leftValue.compareTo(rightValue) == 0;
    }

    public static boolean operator_notEquals(Number left, Number right) {
        BigDecimal leftValue = NumberExtensions.numberToBigDecimal(left);
        BigDecimal rightValue = NumberExtensions.numberToBigDecimal(right);
        if (leftValue == null) {
            return rightValue != null;
        }
        if (rightValue == null) {
            return true;
        }
        return leftValue.compareTo(rightValue) != 0;
    }

    public static boolean operator_lessThan(Number left, Number right) {
        BigDecimal leftValue = NumberExtensions.numberToBigDecimal(left);
        BigDecimal rightValue = NumberExtensions.numberToBigDecimal(right);
        if (leftValue == null) {
            return true;
        }
        if (rightValue == null) {
            return false;
        }
        return leftValue.compareTo(rightValue) < 0;
    }

    public static boolean operator_greaterThan(Number left, Number right) {
        BigDecimal leftValue = NumberExtensions.numberToBigDecimal(left);
        BigDecimal rightValue = NumberExtensions.numberToBigDecimal(right);
        if (leftValue == null) {
            return false;
        }
        if (rightValue == null) {
            return true;
        }
        return leftValue.compareTo(rightValue) > 0;
    }

    public static boolean operator_lessEqualsThan(Number left, Number right) {
        BigDecimal leftValue = NumberExtensions.numberToBigDecimal(left);
        BigDecimal rightValue = NumberExtensions.numberToBigDecimal(right);
        if (leftValue == null) {
            return true;
        }
        if (rightValue == null) {
            return false;
        }
        return leftValue.compareTo(rightValue) <= 0;
    }

    public static boolean operator_greaterEqualsThan(Number left, Number right) {
        BigDecimal leftValue = NumberExtensions.numberToBigDecimal(left);
        BigDecimal rightValue = NumberExtensions.numberToBigDecimal(right);
        if (leftValue == null) {
            return rightValue == null;
        }
        if (rightValue == null) {
            return true;
        }
        return leftValue.compareTo(rightValue) >= 0;
    }

    public static boolean operator_equals(Type type, Number x) {
        if (type instanceof QuantityType var2_3 && ( instanceOfPatternExpressionValue = x) instanceof QuantityType var3_5) {
            return NumberExtensions.operator_equals(qtype, qx);
        }
        if (type != null && ( instanceOfPatternExpressionValue = type) instanceof DecimalType var6_7 && x != null) {
            return decimalType.toBigDecimal().compareTo(NumberExtensions.numberToBigDecimal(x)) == 0;
        }
        return type == x;
    }

    public static boolean operator_notEquals(Type type, Number x) {
        if (type instanceof QuantityType var2_3 && ( instanceOfPatternExpressionValue = x) instanceof QuantityType var3_5) {
            return NumberExtensions.operator_notEquals(qtype, qx);
        }
        if (type != null && ( instanceOfPatternExpressionValue = type) instanceof DecimalType var6_7 && x != null) {
            return decimalType.toBigDecimal().compareTo(NumberExtensions.numberToBigDecimal(x)) != 0;
        }
        return type != x;
    }

    public static boolean operator_greaterThan(Type type, Number x) {
        if (type instanceof QuantityType var2_3 && ( instanceOfPatternExpressionValue = x) instanceof QuantityType var3_5) {
            return NumberExtensions.operator_greaterThan(qtype, qx);
        }
        if (type != null && ( instanceOfPatternExpressionValue = type) instanceof DecimalType var6_7 && x != null) {
            return decimalType.toBigDecimal().compareTo(NumberExtensions.numberToBigDecimal(x)) > 0;
        }
        return false;
    }

    public static boolean operator_greaterEqualsThan(Type type, Number x) {
        if (type instanceof QuantityType var2_3 && ( instanceOfPatternExpressionValue = x) instanceof QuantityType var3_5) {
            return NumberExtensions.operator_greaterEqualsThan(qtype, qx);
        }
        if (type != null && ( instanceOfPatternExpressionValue = type) instanceof DecimalType var6_7 && x != null) {
            return decimalType.toBigDecimal().compareTo(NumberExtensions.numberToBigDecimal(x)) >= 0;
        }
        return false;
    }

    public static boolean operator_lessThan(Type type, Number x) {
        if (type instanceof QuantityType var2_3 && ( instanceOfPatternExpressionValue = x) instanceof QuantityType var3_5) {
            return NumberExtensions.operator_lessThan(qtype, qx);
        }
        if (type != null && ( instanceOfPatternExpressionValue = type) instanceof DecimalType var6_7 && x != null) {
            return decimalType.toBigDecimal().compareTo(NumberExtensions.numberToBigDecimal(x)) < 0;
        }
        return false;
    }

    public static boolean operator_lessEqualsThan(Type type, Number x) {
        if (type instanceof QuantityType var2_3 && ( instanceOfPatternExpressionValue = x) instanceof QuantityType var3_5) {
            return NumberExtensions.operator_lessEqualsThan(qtype, qx);
        }
        if (type != null && ( instanceOfPatternExpressionValue = type) instanceof DecimalType var6_7 && x != null) {
            return decimalType.toBigDecimal().compareTo(NumberExtensions.numberToBigDecimal(x)) <= 0;
        }
        return false;
    }

    public static QuantityType<?> operator_plus(QuantityType<?> x, QuantityType<?> y) {
        return x == null ? y : (y == null ? x : x.add(y));
    }

    public static QuantityType<?> operator_minus(QuantityType<?> x) {
        return x == null ? null : x.negate();
    }

    public static QuantityType<?> operator_minus(QuantityType<?> x, QuantityType<?> y) {
        return x == null ? NumberExtensions.operator_minus(y) : (y == null ? x : x.subtract(y));
    }

    public static QuantityType<?> operator_multiply(Number x, QuantityType<?> y) {
        BigDecimal xValue = NumberExtensions.numberToBigDecimal(x);
        if (xValue == null) {
            return QuantityType.ZERO;
        }
        if (y == null) {
            return QuantityType.ZERO;
        }
        return y.multiply(xValue);
    }

    public static QuantityType<?> operator_multiply(QuantityType<?> x, Number y) {
        return NumberExtensions.operator_multiply(y, x);
    }

    public static QuantityType<?> operator_multiply(QuantityType<?> x, QuantityType<?> y) {
        return x == null || y == null ? QuantityType.ZERO : x.multiply(y);
    }

    public static QuantityType<?> operator_divide(QuantityType<?> x, Number y) {
        BigDecimal yValue = NumberExtensions.numberToBigDecimal(y);
        return x.divide(yValue);
    }

    public static QuantityType<?> operator_divide(Number x, QuantityType<?> y) {
        QuantityType xQuantity = new QuantityType(x, Units.ONE);
        return NumberExtensions.operator_divide(xQuantity, y);
    }

    public static QuantityType<?> operator_divide(QuantityType<?> x, QuantityType<?> y) {
        return x.divide(y);
    }

    public static boolean operator_equals(QuantityType<?> left, QuantityType<?> right) {
        return left.equals(right);
    }

    public static boolean operator_equals(QuantityType<?> left, Number right) {
        return NumberExtensions.operator_equals(left, right);
    }

    public static boolean operator_notEquals(QuantityType<?> left, QuantityType<?> right) {
        return !NumberExtensions.operator_equals(left, right);
    }

    public static boolean operator_notEquals(QuantityType<?> left, Number right) {
        return NumberExtensions.operator_notEquals(left, right);
    }

    public static boolean operator_lessThan(QuantityType<?> x, QuantityType<?> y) {
        if (x != null && y != null) {
            return x.compareTo(y) < 0;
        }
        return false;
    }

    public static boolean operator_lessThan(QuantityType<?> x, Number y) {
        return NumberExtensions.operator_lessThan(x, y);
    }

    public static boolean operator_lessEqualsThan(QuantityType<?> x, QuantityType<?> y) {
        if (x != null && y != null) {
            return x.compareTo(y) <= 0;
        }
        return false;
    }

    public static boolean operator_lessEqualsThan(QuantityType<?> x, Number y) {
        return NumberExtensions.operator_lessEqualsThan(x, y);
    }

    public static boolean operator_greaterThan(QuantityType<?> x, QuantityType<?> y) {
        if (x != null && y != null) {
            return x.compareTo(y) > 0;
        }
        return false;
    }

    public static boolean operator_greaterThan(QuantityType<?> x, Number y) {
        return NumberExtensions.operator_greaterThan(x, y);
    }

    public static boolean operator_greaterEqualsThan(QuantityType<?> x, QuantityType<?> y) {
        if (x != null && y != null) {
            return x.compareTo(y) >= 0;
        }
        return false;
    }

    public static boolean operator_greaterEqualsThan(QuantityType<?> x, Number y) {
        return NumberExtensions.operator_greaterEqualsThan(x, y);
    }

    public static BigDecimal numberToBigDecimal(Number number) {
        if (number instanceof QuantityType) {
            QuantityType state = ((QuantityType)number).toInvertibleUnit(((QuantityType)number).getUnit().getSystemUnit());
            if (state != null) {
                return state.toBigDecimal();
            }
            return null;
        }
        if (number != null) {
            return new BigDecimal(number.toString());
        }
        return null;
    }

    private static boolean oneIsQuantity(Number left, Number right) {
        return left instanceof QuantityType && !NumberExtensions.isAbstractUnitOne((QuantityType)left) || right instanceof QuantityType && !NumberExtensions.isAbstractUnitOne((QuantityType)right);
    }

    private static boolean isAbstractUnitOne(QuantityType<?> left) {
        return Units.ONE.equals(left.getUnit());
    }
}

