/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.model.script.engine;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.openhab.core.model.script.engine.ScriptError;

public abstract class ScriptException
extends Exception {
    private static final long serialVersionUID = -4155948282895039148L;
    private String scriptText;
    private final List<ScriptError> errors;

    protected ScriptException(String message) {
        super(message);
        this.errors = new ArrayList<ScriptError>(1);
        this.errors.add(new ScriptError(message, 0, 0, -1));
    }

    protected ScriptException(ScriptError scriptError) {
        super(scriptError.getMessage());
        this.errors = new ArrayList<ScriptError>(1);
        this.errors.add(scriptError);
    }

    protected ScriptException(String message, String scriptText, Throwable cause) {
        super(message, cause);
        this.scriptText = scriptText;
        this.errors = new LinkedList<ScriptError>();
    }

    protected ScriptException(String message, String scriptText) {
        super(message);
        this.scriptText = scriptText;
        this.errors = new LinkedList<ScriptError>();
    }

    public ScriptException(String message, String scriptText, int line, int column, int length) {
        this(scriptText, new ScriptError(message, line, column, length));
    }

    public ScriptException(Throwable cause, String message, String scriptText, int line, int column, int length) {
        this(cause, scriptText, new ScriptError(message, line, column, length));
    }

    private ScriptException(Throwable cause, String scriptText, ScriptError error) {
        super(error.getMessage(), cause);
        this.scriptText = scriptText;
        this.errors = new ArrayList<ScriptError>(1);
        this.errors.add(error);
    }

    private ScriptException(String scriptText, ScriptError error) {
        super(error.getMessage());
        this.scriptText = scriptText;
        this.errors = new ArrayList<ScriptError>(1);
        this.errors.add(error);
    }

    public ScriptException(String message, Throwable cause) {
        super(message, cause);
        this.errors = new ArrayList<ScriptError>(0);
    }

    public List<ScriptError> getErrors() {
        return this.errors;
    }

    public void setScriptText(String scriptText) {
        this.scriptText = scriptText;
    }

    @Override
    public String getMessage() {
        StringBuilder sb = new StringBuilder();
        if (this.scriptText == null) {
            sb.append(super.getMessage());
        } else {
            int l = 1;
            int c = 0;
            int x = 0;
            while (x < this.scriptText.length()) {
                if (this.hasMatchingError(l, c)) {
                    sb.append(" ___ ");
                }
                sb.append(this.scriptText.charAt(x));
                if (this.scriptText.charAt(x) == '\n') {
                    ++l;
                    c = 0;
                } else {
                    ++c;
                }
                ++x;
            }
            int i = 1;
            for (ScriptError e : this.getErrors()) {
                if (sb.length() > 0) {
                    sb.append('\n');
                }
                sb.append("   ");
                if (this.getErrors().size() > 1) {
                    sb.append(i++);
                    sb.append(". ");
                }
                sb.append(e.getMessage());
            }
        }
        return sb.toString();
    }

    private boolean hasMatchingError(int l, int c) {
        for (ScriptError e : this.getErrors()) {
            if (e.getLineNumber() != l || e.getColumnNumber() != c) continue;
            return true;
        }
        return false;
    }
}

