/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.auth.oauth2client.internal;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonPrimitive;
import java.security.GeneralSecurityException;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeParseException;
import java.time.temporal.ChronoUnit;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.openhab.core.auth.client.oauth2.AccessTokenResponse;
import org.openhab.core.auth.client.oauth2.StorageCipher;
import org.openhab.core.auth.oauth2client.internal.OAuthStoreHandler;
import org.openhab.core.auth.oauth2client.internal.PersistedParams;
import org.openhab.core.auth.oauth2client.internal.StorageRecordType;
import org.openhab.core.storage.Storage;
import org.openhab.core.storage.StorageService;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NonNullByDefault
@Component(property={"CIPHER_TARGET=SymmetricKeyCipher"})
public class OAuthStoreHandlerImpl
implements OAuthStoreHandler {
    protected static final int EXPIRE_DAYS = 183;
    protected static final int ACCESS_TOKEN_CACHE_SIZE = 50;
    private static final String STORE_NAME = "StorageHandler.For.OAuthClientService";
    private static final String STORE_KEY_INDEX_OF_HANDLES = "INDEX_HANDLES";
    private final Set<String> allHandles = new HashSet<String>();
    private final StorageFacade storageFacade;
    private final Set<StorageCipher> allAvailableStorageCiphers = new LinkedHashSet<StorageCipher>();
    private Optional<StorageCipher> storageCipher = Optional.empty();
    private final Logger logger = LoggerFactory.getLogger(OAuthStoreHandlerImpl.class);

    @Activate
    public OAuthStoreHandlerImpl(@Reference StorageService storageService) {
        this.storageFacade = new StorageFacade((Storage<String>)storageService.getStorage(STORE_NAME));
    }

    @Activate
    public void activate(Map<String, Object> properties) throws GeneralSecurityException {
        String cipherTarget = (String)properties.getOrDefault("CIPHER_TARGET", "SymmetricKeyCipher");
        this.storageCipher = this.allAvailableStorageCiphers.stream().filter(cipher -> cipher.getUniqueCipherId().equals(cipherTarget)).findFirst();
        this.logger.debug("Using Cipher: {}", (Object)this.storageCipher.orElseThrow(() -> new GeneralSecurityException("No StorageCipher with target=" + cipherTarget)));
    }

    @Deactivate
    public void deactivate() {
        this.storageFacade.close();
    }

    @Override
    public @Nullable AccessTokenResponse loadAccessTokenResponse(String handle) throws GeneralSecurityException {
        AccessTokenResponse accessTokenResponseFromStore = (AccessTokenResponse)this.storageFacade.get(handle, StorageRecordType.ACCESS_TOKEN_RESPONSE);
        if (accessTokenResponseFromStore == null) {
            return null;
        }
        return this.decryptToken(accessTokenResponseFromStore);
    }

    @Override
    public void saveAccessTokenResponse(String handle, @Nullable AccessTokenResponse pAccessTokenResponse) {
        AccessTokenResponse encryptedToken;
        AccessTokenResponse accessTokenResponse = pAccessTokenResponse;
        if (accessTokenResponse == null) {
            accessTokenResponse = new AccessTokenResponse();
        }
        try {
            encryptedToken = this.encryptToken(accessTokenResponse);
        }
        catch (GeneralSecurityException e) {
            this.logger.warn("Unable to encrypt token, storing as-is", (Throwable)e);
            encryptedToken = accessTokenResponse;
        }
        this.storageFacade.put(handle, encryptedToken);
    }

    @Override
    public void remove(String handle) {
        this.storageFacade.removeByHandle(handle);
    }

    @Override
    public void removeAll() {
        this.storageFacade.removeAll();
        this.allHandles.clear();
    }

    @Override
    public void savePersistedParams(String handle, @Nullable PersistedParams persistedParams) {
        this.storageFacade.put(handle, persistedParams);
    }

    @Override
    public @Nullable PersistedParams loadPersistedParams(String handle) {
        return (PersistedParams)this.storageFacade.get(handle, StorageRecordType.SERVICE_CONFIGURATION);
    }

    private AccessTokenResponse encryptToken(AccessTokenResponse accessTokenResponse) throws GeneralSecurityException {
        AccessTokenResponse encryptedAccessToken = (AccessTokenResponse)accessTokenResponse.clone();
        if (accessTokenResponse.getAccessToken() != null) {
            encryptedAccessToken.setAccessToken(this.encrypt(accessTokenResponse.getAccessToken()));
        }
        if (accessTokenResponse.getRefreshToken() != null) {
            encryptedAccessToken.setRefreshToken(this.encrypt(accessTokenResponse.getRefreshToken()));
        }
        return encryptedAccessToken;
    }

    private AccessTokenResponse decryptToken(AccessTokenResponse accessTokenResponse) throws GeneralSecurityException {
        AccessTokenResponse decryptedToken = (AccessTokenResponse)accessTokenResponse.clone();
        if (this.storageCipher.isEmpty()) {
            return decryptedToken;
        }
        this.logger.debug("Decrypting token: {}", (Object)accessTokenResponse);
        decryptedToken.setAccessToken(this.storageCipher.get().decrypt(accessTokenResponse.getAccessToken()));
        decryptedToken.setRefreshToken(this.storageCipher.get().decrypt(accessTokenResponse.getRefreshToken()));
        return decryptedToken;
    }

    private @Nullable String encrypt(String token) throws GeneralSecurityException {
        if (this.storageCipher.isEmpty()) {
            return token;
        }
        StorageCipher cipher = this.storageCipher.get();
        return cipher.encrypt(token);
    }

    @Reference(cardinality=ReferenceCardinality.AT_LEAST_ONE)
    protected synchronized void setStorageCipher(StorageCipher storageCipher) {
        this.allAvailableStorageCiphers.add(storageCipher);
    }

    protected synchronized void unsetStorageCipher(StorageCipher storageCipher) {
        this.allAvailableStorageCiphers.remove(storageCipher);
        if (this.storageCipher.isPresent() && this.storageCipher.get() == storageCipher) {
            this.storageCipher = Optional.empty();
        }
    }

    private boolean isExpired(@Nullable Instant lastUsed) {
        if (lastUsed == null) {
            return false;
        }
        return lastUsed.plus(183L, ChronoUnit.DAYS).isBefore(Instant.now());
    }

    private class StorageFacade
    implements AutoCloseable {
        private final Storage<String> storage;
        private final Lock storageLock = new ReentrantLock();
        private final Gson gson;

        public StorageFacade(Storage<String> storage) {
            this.storage = storage;
            this.gson = new GsonBuilder().registerTypeAdapter(Instant.class, (json, typeOfT, context) -> {
                try {
                    return Instant.parse(json.getAsString());
                }
                catch (DateTimeParseException e) {
                    return LocalDateTime.parse(json.getAsString()).atZone(ZoneId.systemDefault()).toInstant();
                }
            }).registerTypeAdapter(Instant.class, (date, type, jsonSerializationContext) -> new JsonPrimitive(date.toString())).setPrettyPrinting().create();
        }

        public Set<String> getAllHandlesFromIndex() {
            try {
                String allHandlesStr = this.get(OAuthStoreHandlerImpl.STORE_KEY_INDEX_OF_HANDLES);
                OAuthStoreHandlerImpl.this.logger.debug("All available handles: {}", (Object)allHandlesStr);
                if (allHandlesStr == null) {
                    return Set.of();
                }
                return Objects.requireNonNullElse((Set)this.gson.fromJson(allHandlesStr, HashSet.class), Set.of());
            }
            catch (RuntimeException storeNotAvailable) {
                return Set.of();
            }
        }

        public @Nullable String get(String key) {
            this.storageLock.lock();
            try {
                String string = (String)this.storage.get(key);
                return string;
            }
            finally {
                this.storageLock.unlock();
            }
        }

        /*
         * Exception decompiling
         */
        public @Nullable Object get(String handle, StorageRecordType recordType) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        public void put(String handle, @Nullable AccessTokenResponse accessTokenResponse) {
            this.storageLock.lock();
            try {
                if (accessTokenResponse == null) {
                    this.storage.put(StorageRecordType.ACCESS_TOKEN_RESPONSE.getKey(handle), null);
                } else {
                    String gsonAccessTokenStr = this.gson.toJson((Object)accessTokenResponse);
                    this.storage.put(StorageRecordType.ACCESS_TOKEN_RESPONSE.getKey(handle), (Object)gsonAccessTokenStr);
                    String gsonDateStr = this.gson.toJson((Object)Instant.now());
                    this.storage.put(StorageRecordType.LAST_USED.getKey(handle), (Object)gsonDateStr);
                    if (!OAuthStoreHandlerImpl.this.allHandles.contains(handle)) {
                        OAuthStoreHandlerImpl.this.allHandles.add(handle);
                        this.storage.put(OAuthStoreHandlerImpl.STORE_KEY_INDEX_OF_HANDLES, (Object)this.gson.toJson(OAuthStoreHandlerImpl.this.allHandles));
                    }
                }
            }
            finally {
                this.storageLock.unlock();
            }
        }

        public void put(String handle, @Nullable PersistedParams persistedParams) {
            this.storageLock.lock();
            try {
                if (persistedParams == null) {
                    this.storage.put(StorageRecordType.SERVICE_CONFIGURATION.getKey(handle), null);
                } else {
                    String gsonPersistedParamsStr = this.gson.toJson((Object)persistedParams);
                    this.storage.put(StorageRecordType.SERVICE_CONFIGURATION.getKey(handle), (Object)gsonPersistedParamsStr);
                    String gsonDateStr = this.gson.toJson((Object)Instant.now());
                    this.storage.put(StorageRecordType.LAST_USED.getKey(handle), (Object)gsonDateStr);
                    if (!OAuthStoreHandlerImpl.this.allHandles.contains(handle)) {
                        OAuthStoreHandlerImpl.this.allHandles.add(handle);
                        this.storage.put(OAuthStoreHandlerImpl.STORE_KEY_INDEX_OF_HANDLES, (Object)this.gson.toJson(OAuthStoreHandlerImpl.this.allHandles));
                    }
                }
            }
            finally {
                this.storageLock.unlock();
            }
        }

        public void removeByHandle(String handle) {
            OAuthStoreHandlerImpl.this.logger.debug("Removing handle {} from storage", (Object)handle);
            this.storageLock.lock();
            try {
                if (OAuthStoreHandlerImpl.this.allHandles.remove(handle)) {
                    this.storage.remove(StorageRecordType.ACCESS_TOKEN_RESPONSE.getKey(handle));
                    this.storage.remove(StorageRecordType.LAST_USED.getKey(handle));
                    this.storage.remove(StorageRecordType.SERVICE_CONFIGURATION.getKey(handle));
                    this.storage.put(OAuthStoreHandlerImpl.STORE_KEY_INDEX_OF_HANDLES, (Object)this.gson.toJson(OAuthStoreHandlerImpl.this.allHandles));
                }
            }
            finally {
                this.storageLock.unlock();
            }
        }

        public void removeAll() {
            Set<String> allHandlesFromStore = this.getAllHandlesFromIndex();
            for (String handle : allHandlesFromStore) {
                this.removeByHandle(handle);
            }
        }

        @Override
        public void close() {
            block15: {
                boolean lockGained = false;
                try {
                    try {
                        String handlesSSV;
                        lockGained = this.storageLock.tryLock(15L, TimeUnit.SECONDS);
                        if (lockGained && (handlesSSV = (String)this.storage.get(OAuthStoreHandlerImpl.STORE_KEY_INDEX_OF_HANDLES)) != null) {
                            String[] handles;
                            String[] stringArray = handles = handlesSSV.trim().split(" ");
                            int n = handles.length;
                            int n2 = 0;
                            while (n2 < n) {
                                String handle = stringArray[n2];
                                Instant lastUsed = (Instant)this.get(handle, StorageRecordType.LAST_USED);
                                if (OAuthStoreHandlerImpl.this.isExpired(lastUsed)) {
                                    this.removeByHandle(handle);
                                }
                                ++n2;
                            }
                        }
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        if (!lockGained) break block15;
                        try {
                            this.storageLock.unlock();
                        }
                        catch (IllegalMonitorStateException e2) {
                            OAuthStoreHandlerImpl.this.logger.error("Unexpected attempt to unlock without lock", (Throwable)e2);
                        }
                    }
                }
                finally {
                    if (lockGained) {
                        try {
                            this.storageLock.unlock();
                        }
                        catch (IllegalMonitorStateException e) {
                            OAuthStoreHandlerImpl.this.logger.error("Unexpected attempt to unlock without lock", (Throwable)e);
                        }
                    }
                }
            }
        }
    }
}

