/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.auth.oauth2client.internal;

import com.google.gson.FieldNamingPolicy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonSyntaxException;
import java.io.IOException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeParseException;
import java.util.Base64;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.client.api.ContentProvider;
import org.eclipse.jetty.client.api.ContentResponse;
import org.eclipse.jetty.client.api.Request;
import org.eclipse.jetty.client.util.FormContentProvider;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.HttpMethod;
import org.eclipse.jetty.util.Fields;
import org.openhab.core.auth.client.oauth2.AccessTokenResponse;
import org.openhab.core.auth.client.oauth2.OAuthException;
import org.openhab.core.auth.client.oauth2.OAuthResponseException;
import org.openhab.core.io.net.http.HttpClientFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NonNullByDefault
public class OAuthConnector {
    private static final String HTTP_CLIENT_CONSUMER_NAME = "OAuthConnector";
    private final HttpClientFactory httpClientFactory;
    private final @Nullable Fields extraFields;
    private final Logger logger = LoggerFactory.getLogger(OAuthConnector.class);
    private final Gson gson;

    public OAuthConnector(HttpClientFactory httpClientFactory) {
        this(httpClientFactory, null, new GsonBuilder());
    }

    public OAuthConnector(HttpClientFactory httpClientFactory, @Nullable Fields extraFields) {
        this(httpClientFactory, extraFields, new GsonBuilder());
    }

    public OAuthConnector(HttpClientFactory httpClientFactory, GsonBuilder gsonBuilder) {
        this(httpClientFactory, null, gsonBuilder);
    }

    public OAuthConnector(HttpClientFactory httpClientFactory, @Nullable Fields extraFields, GsonBuilder gsonBuilder) {
        this.httpClientFactory = httpClientFactory;
        this.extraFields = extraFields;
        this.gson = gsonBuilder.setFieldNamingPolicy(FieldNamingPolicy.LOWER_CASE_WITH_UNDERSCORES).registerTypeAdapter(Instant.class, (json, typeOfT, context) -> {
            try {
                return Instant.parse(json.getAsString());
            }
            catch (DateTimeParseException e) {
                return LocalDateTime.parse(json.getAsString()).atZone(ZoneId.systemDefault()).toInstant();
            }
        }).create();
    }

    public String getAuthorizationUrl(String authorizationEndpoint, String clientId, @Nullable String redirectURI, @Nullable String state, @Nullable String scope) {
        StringBuilder authorizationUrl = new StringBuilder(authorizationEndpoint);
        if (authorizationUrl.indexOf("?") == -1) {
            authorizationUrl.append('?');
        } else {
            authorizationUrl.append('&');
        }
        authorizationUrl.append("response_type=code");
        authorizationUrl.append("&client_id=").append(URLEncoder.encode(clientId, StandardCharsets.UTF_8));
        if (state != null) {
            authorizationUrl.append("&state=").append(URLEncoder.encode(state, StandardCharsets.UTF_8));
        }
        if (redirectURI != null) {
            authorizationUrl.append("&redirect_uri=").append(URLEncoder.encode(redirectURI, StandardCharsets.UTF_8));
        }
        if (scope != null) {
            authorizationUrl.append("&scope=").append(URLEncoder.encode(scope, StandardCharsets.UTF_8));
        }
        return authorizationUrl.toString();
    }

    public AccessTokenResponse grantTypePassword(String tokenUrl, String username, String password, @Nullable String clientId, @Nullable String clientSecret, @Nullable String scope, boolean supportsBasicAuth) throws OAuthResponseException, OAuthException, IOException {
        HttpClient httpClient = null;
        try {
            httpClient = this.createHttpClient(tokenUrl);
            Request request = this.getMethod(httpClient, tokenUrl);
            Fields fields = this.initFields("grant_type", "password", "username", username, "password", password, "scope", scope);
            this.setAuthentication(clientId, clientSecret, request, fields, supportsBasicAuth);
            AccessTokenResponse accessTokenResponse = this.doRequest("password", httpClient, request, fields);
            return accessTokenResponse;
        }
        finally {
            this.shutdownQuietly(httpClient);
        }
    }

    public AccessTokenResponse grantTypeRefreshToken(String tokenUrl, String refreshToken, @Nullable String clientId, @Nullable String clientSecret, @Nullable String scope, boolean supportsBasicAuth) throws OAuthResponseException, OAuthException, IOException {
        HttpClient httpClient = null;
        try {
            httpClient = this.createHttpClient(tokenUrl);
            Request request = this.getMethod(httpClient, tokenUrl);
            Fields fields = this.initFields("grant_type", "refresh_token", "refresh_token", refreshToken, "scope", scope);
            this.setAuthentication(clientId, clientSecret, request, fields, supportsBasicAuth);
            AccessTokenResponse accessTokenResponse = this.doRequest("refresh_token", httpClient, request, fields);
            return accessTokenResponse;
        }
        finally {
            this.shutdownQuietly(httpClient);
        }
    }

    public AccessTokenResponse grantTypeAuthorizationCode(String tokenUrl, String authorizationCode, String clientId, @Nullable String clientSecret, @Nullable String redirectUrl, boolean supportsBasicAuth) throws OAuthResponseException, OAuthException, IOException {
        HttpClient httpClient = null;
        try {
            httpClient = this.createHttpClient(tokenUrl);
            Request request = this.getMethod(httpClient, tokenUrl);
            Fields fields = this.initFields("grant_type", "authorization_code", "code", authorizationCode, "redirect_uri", redirectUrl);
            this.setAuthentication(clientId, clientSecret, request, fields, supportsBasicAuth);
            AccessTokenResponse accessTokenResponse = this.doRequest("authorization_code", httpClient, request, fields);
            return accessTokenResponse;
        }
        finally {
            this.shutdownQuietly(httpClient);
        }
    }

    public AccessTokenResponse grantTypeClientCredentials(String tokenUrl, String clientId, @Nullable String clientSecret, @Nullable String scope, boolean supportsBasicAuth) throws OAuthResponseException, OAuthException, IOException {
        HttpClient httpClient = null;
        try {
            httpClient = this.createHttpClient(tokenUrl);
            Request request = this.getMethod(httpClient, tokenUrl);
            Fields fields = this.initFields("grant_type", "client_credentials", "scope", scope);
            this.setAuthentication(clientId, clientSecret, request, fields, supportsBasicAuth);
            AccessTokenResponse accessTokenResponse = this.doRequest("client_credentials", httpClient, request, fields);
            return accessTokenResponse;
        }
        finally {
            this.shutdownQuietly(httpClient);
        }
    }

    private Request getMethod(HttpClient httpClient, String tokenUrl) {
        Request request = httpClient.newRequest(tokenUrl).method(HttpMethod.POST);
        request.header(HttpHeader.ACCEPT, "application/json");
        request.header(HttpHeader.ACCEPT_CHARSET, StandardCharsets.UTF_8.name());
        return request;
    }

    private void setAuthentication(@Nullable String clientId, @Nullable String clientSecret, Request request, Fields fields, boolean supportsBasicAuth) {
        this.logger.debug("Setting authentication for clientId {}. Using basic auth {}", (Object)clientId, (Object)supportsBasicAuth);
        if (supportsBasicAuth && clientSecret != null) {
            String authString = String.valueOf(clientId) + ":" + clientSecret;
            request.header(HttpHeader.AUTHORIZATION, "Basic " + Base64.getEncoder().encodeToString(authString.getBytes(StandardCharsets.UTF_8)));
        } else {
            if (clientId != null) {
                fields.add("client_id", clientId);
            }
            if (clientSecret != null) {
                fields.add("client_secret", clientSecret);
            }
        }
    }

    private Fields initFields(String ... parameters) {
        Fields fields = new Fields();
        int i = 0;
        while (i < parameters.length) {
            if (i + 1 < parameters.length && parameters[i] != null && parameters[i + 1] != null) {
                this.logger.debug("Oauth request parameter {}, value {}", (Object)parameters[i], (Object)parameters[i + 1]);
                fields.add(parameters[i], parameters[i + 1]);
            }
            i += 2;
        }
        if (this.extraFields != null) {
            for (Fields.Field extra : this.extraFields) {
                this.logger.debug("Oauth request (extra) parameter {}, value {}", (Object)extra.getName(), (Object)extra.getValue());
                fields.put(extra);
            }
        }
        return fields;
    }

    private AccessTokenResponse doRequest(String grantType, HttpClient httpClient, Request request, Fields fields) throws OAuthResponseException, OAuthException, IOException {
        int statusCode = 0;
        String content = "";
        try {
            FormContentProvider entity = new FormContentProvider(fields);
            Request requestWithContent = request.content((ContentProvider)entity);
            ContentResponse response = requestWithContent.send();
            statusCode = response.getStatus();
            content = response.getContentAsString();
            if (statusCode == 200) {
                AccessTokenResponse jsonResponse = (AccessTokenResponse)this.gson.fromJson(content, AccessTokenResponse.class);
                jsonResponse.setCreatedOn(Instant.now());
                this.logger.debug("grant type {} to URL {} success", (Object)grantType, (Object)request.getURI());
                return jsonResponse;
            }
            if (statusCode == 400) {
                OAuthResponseException errorResponse = (OAuthResponseException)this.gson.fromJson(content, OAuthResponseException.class);
                this.logger.error("grant type {} to URL {} failed with error code {}, description {}", new Object[]{grantType, request.getURI(), errorResponse.getError(), errorResponse.getErrorDescription()});
                throw errorResponse;
            }
            this.logger.error("grant type {} to URL {} failed with HTTP response code {}", new Object[]{grantType, request.getURI(), statusCode});
            throw new OAuthException("Bad http response, http code " + statusCode);
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            throw new IOException("Exception in oauth communication, grant type " + grantType, e);
        }
        catch (JsonSyntaxException e) {
            throw new OAuthException(String.format("Unable to deserialize json into AccessTokenResponse/ OAuthResponseException. httpCode: %d json: %s: %s", statusCode, content, e.getMessage()), (Throwable)e);
        }
        catch (Exception e) {
            throw new OAuthException("Exception in oauth communication, grant type " + grantType + ": " + e.getMessage(), (Throwable)e);
        }
    }

    private HttpClient createHttpClient(String tokenUrl) throws OAuthException {
        HttpClient httpClient = this.httpClientFactory.createHttpClient(HTTP_CLIENT_CONSUMER_NAME);
        if (!httpClient.isStarted()) {
            try {
                httpClient.start();
            }
            catch (Exception e) {
                throw new OAuthException("Exception while starting httpClient, tokenUrl: " + tokenUrl, (Throwable)e);
            }
        }
        return httpClient;
    }

    private void shutdownQuietly(@Nullable HttpClient httpClient) {
        try {
            if (httpClient != null) {
                httpClient.stop();
            }
        }
        catch (Exception e) {
            this.logger.error("Exception while shutting down httpClient, {}", (Object)e.getMessage(), (Object)e);
        }
    }
}

