/*
 * Decompiled with CFR 0.152.
 */
package de.jollyday.util;

import de.jollyday.HolidayType;
import de.jollyday.config.Configuration;
import de.jollyday.config.Month;
import de.jollyday.config.ObjectFactory;
import de.jollyday.config.Weekday;
import de.jollyday.util.ClassLoadingUtil;
import java.io.InputStream;
import java.time.DayOfWeek;
import java.util.logging.Logger;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;

public class XMLUtil {
    public static final String PACKAGE = "de.jollyday.config";
    private static final Logger LOG = Logger.getLogger(XMLUtil.class.getName());
    private JAXBContextCreator contextCreator = new JAXBContextCreator();
    private ClassLoadingUtil classLoadingUtil = new ClassLoadingUtil();

    public Configuration unmarshallConfiguration(InputStream stream) {
        if (stream == null) {
            throw new IllegalArgumentException("Stream is NULL. Cannot read XML.");
        }
        try {
            JAXBContext ctx;
            try {
                ctx = this.contextCreator.create(PACKAGE, this.classLoadingUtil.getClassloader());
            }
            catch (JAXBException e) {
                LOG.warning("Could not create JAXB context using the current threads context classloader. Falling back to ObjectFactory class classloader.");
                ctx = null;
            }
            if (ctx == null) {
                ctx = this.contextCreator.create(PACKAGE, ObjectFactory.class.getClassLoader());
            }
            Unmarshaller um = ctx.createUnmarshaller();
            JAXBElement el = (JAXBElement)um.unmarshal(stream);
            return (Configuration)el.getValue();
        }
        catch (JAXBException ue) {
            throw new IllegalStateException("Cannot parse holidays XML file.", ue);
        }
    }

    public final DayOfWeek getWeekday(Weekday weekday) {
        return DayOfWeek.valueOf(weekday.value());
    }

    public int getMonth(Month month) {
        return month.ordinal() + 1;
    }

    public HolidayType getType(de.jollyday.config.HolidayType type) {
        switch (type) {
            case OFFICIAL_HOLIDAY: {
                return HolidayType.OFFICIAL_HOLIDAY;
            }
            case UNOFFICIAL_HOLIDAY: {
                return HolidayType.UNOFFICIAL_HOLIDAY;
            }
        }
        throw new IllegalArgumentException("Unknown type " + (Object)((Object)type));
    }

    public class JAXBContextCreator {
        public JAXBContext create(String packageName, ClassLoader classLoader) throws JAXBException {
            return JAXBContext.newInstance((String)packageName, (ClassLoader)classLoader);
        }
    }
}

