/*
 * Decompiled with CFR 0.152.
 */
package de.jollyday.util;

import de.jollyday.util.ClassLoadingUtil;
import java.net.URL;
import java.util.Collections;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class ResourceUtil {
    private static final String COUNTRY_PROPERTY_PREFIX = "country.description";
    private static final String HOLIDAY_PROPERTY_PREFIX = "holiday.description";
    private static final String COUNTRY_DESCRIPTIONS_FILE_PREFIX = "descriptions.country_descriptions";
    private static final String HOLIDAY_DESCRIPTIONS_FILE_PREFIX = "descriptions.holiday_descriptions";
    public static final String UNDEFINED = "undefined";
    private static final Map<Locale, ResourceBundle> HOLIDAY_DESCRIPTION_CACHE = new ConcurrentHashMap<Locale, ResourceBundle>();
    private static final Map<Locale, ResourceBundle> COUNTRY_DESCRIPTIONS_CACHE = new ConcurrentHashMap<Locale, ResourceBundle>();
    private final ClassLoadingUtil classLoadingUtil = new ClassLoadingUtil();

    public String getHolidayDescription(String key) {
        return this.getHolidayDescription(Locale.getDefault(), key);
    }

    public String getHolidayDescription(Locale locale, String key) {
        return this.getDescription("holiday.description." + key, this.getHolidayDescriptions(locale));
    }

    public String getCountryDescription(String key) {
        return this.getCountryDescription(Locale.getDefault(), key);
    }

    public String getCountryDescription(Locale l, String key) {
        if (key != null) {
            return this.getDescription("country.description." + key.toLowerCase(), this.getCountryDescriptions(l));
        }
        return UNDEFINED;
    }

    public Set<String> getISOCodes() {
        HashSet<String> codes = new HashSet<String>();
        ResourceBundle countryDescriptions = this.getCountryDescriptions(Locale.getDefault());
        for (String property : Collections.list(countryDescriptions.getKeys())) {
            String[] split = property.split("\\.");
            if (split.length <= 2) continue;
            codes.add(split[2].toLowerCase());
        }
        return codes;
    }

    private String getDescription(String key, ResourceBundle bundle) {
        if (!bundle.containsKey(key)) {
            return UNDEFINED;
        }
        return bundle.getString(key);
    }

    private ResourceBundle getHolidayDescriptions(Locale l) {
        return this.getResourceBundle(l, HOLIDAY_DESCRIPTION_CACHE, HOLIDAY_DESCRIPTIONS_FILE_PREFIX);
    }

    private ResourceBundle getCountryDescriptions(Locale l) {
        return this.getResourceBundle(l, COUNTRY_DESCRIPTIONS_CACHE, COUNTRY_DESCRIPTIONS_FILE_PREFIX);
    }

    private ResourceBundle getResourceBundle(Locale l, Map<Locale, ResourceBundle> resourceCache, String filePrefix) {
        if (!resourceCache.containsKey(l)) {
            ResourceBundle bundle = ResourceBundle.getBundle(filePrefix, l, this.classLoadingUtil.getClassloader());
            resourceCache.put(l, bundle);
        }
        return resourceCache.get(l);
    }

    public URL getResource(String resourceName) {
        try {
            URL resource = this.classLoadingUtil.getClassloader().getResource(resourceName);
            return resource == null ? this.getClass().getClassLoader().getResource(resourceName) : resource;
        }
        catch (Exception e) {
            throw new IllegalStateException("Cannot load resource: " + resourceName, e);
        }
    }
}

