/*
 * Decompiled with CFR 0.152.
 */
package de.jollyday.util;

import de.jollyday.Holiday;
import de.jollyday.HolidayType;
import de.jollyday.config.Fixed;
import de.jollyday.util.XMLUtil;
import java.time.DayOfWeek;
import java.time.LocalDate;
import java.time.Month;
import java.time.chrono.ChronoLocalDate;
import java.time.chrono.Chronology;
import java.time.chrono.HijrahChronology;
import java.time.temporal.ChronoField;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalAccessor;
import java.util.Calendar;
import java.util.HashSet;
import java.util.Set;
import org.threeten.extra.chrono.CopticChronology;
import org.threeten.extra.chrono.JulianChronology;

public class CalendarUtil {
    private final XMLUtil xmlUtil = new XMLUtil();

    public LocalDate create() {
        return LocalDate.now();
    }

    public LocalDate create(int year, int month, int day) {
        return LocalDate.of(year, month, day);
    }

    public ChronoLocalDate create(int year, int month, int day, Chronology chronology) {
        return chronology.date(year, month, day);
    }

    public LocalDate create(int year, Fixed fixed) {
        return this.create(year, this.xmlUtil.getMonth(fixed.getMonth()), fixed.getDay());
    }

    public LocalDate create(Calendar c) {
        return LocalDate.of(c.get(1), c.get(2) + 1, c.get(5));
    }

    public LocalDate getEasterSunday(int year) {
        if (year <= 1583) {
            return this.getJulianEasterSunday(year);
        }
        return this.getGregorianEasterSunday(year);
    }

    public LocalDate getJulianEasterSunday(int year) {
        int a = year % 4;
        int b = year % 7;
        int c = year % 19;
        int d = (19 * c + 15) % 30;
        int e = (2 * a + 4 * b - d + 34) % 7;
        int x = d + e + 114;
        int month = x / 31;
        int day = x % 31 + 1;
        return LocalDate.from((TemporalAccessor)JulianChronology.INSTANCE.date(year, month == 3 ? 3 : 4, day));
    }

    public LocalDate getGregorianEasterSunday(int year) {
        int a = year % 19;
        int b = year / 100;
        int c = year % 100;
        int d = b / 4;
        int e = b % 4;
        int f = (b + 8) / 25;
        int g = (b - f + 1) / 3;
        int h = (19 * a + b - d - g + 15) % 30;
        int i = c / 4;
        int j = c % 4;
        int k = (32 + 2 * e + 2 * i - h - j) % 7;
        int l = (a + 11 * h + 22 * k) / 451;
        int x = h + k - 7 * l + 114;
        int month = x / 31;
        int day = x % 31 + 1;
        return LocalDate.of(year, month == 3 ? Month.MARCH : Month.APRIL, day);
    }

    public boolean isWeekend(LocalDate date) {
        return date.getDayOfWeek() == DayOfWeek.SATURDAY || date.getDayOfWeek() == DayOfWeek.SUNDAY;
    }

    public Set<LocalDate> getIslamicHolidaysInGregorianYear(int gregorianYear, int islamicMonth, int islamicDay) {
        return this.getDatesFromChronologyWithinGregorianYear(islamicMonth, islamicDay, gregorianYear, HijrahChronology.INSTANCE);
    }

    public Set<LocalDate> getRelativeIslamicHolidaysInGregorianYear(int gregorianYear, int islamicMonth, int islamicDay, int relativeShift) {
        return this.getRelativeDatesFromChronologyWithinGregorianYear(islamicMonth, islamicDay, gregorianYear, HijrahChronology.INSTANCE, relativeShift);
    }

    public Set<LocalDate> getEthiopianOrthodoxHolidaysInGregorianYear(int gregorianYear, int eoMonth, int eoDay) {
        return this.getDatesFromChronologyWithinGregorianYear(eoMonth, eoDay, gregorianYear, (Chronology)CopticChronology.INSTANCE);
    }

    private Set<LocalDate> getDatesFromChronologyWithinGregorianYear(int targetMonth, int targetDay, int gregorianYear, Chronology targetChrono) {
        return this.getRelativeDatesFromChronologyWithinGregorianYear(targetMonth, targetDay, gregorianYear, targetChrono, 0);
    }

    private Set<LocalDate> getRelativeDatesFromChronologyWithinGregorianYear(int targetMonth, int targetDay, int gregorianYear, Chronology targetChrono, int relativeShift) {
        int absoluteShift = Math.abs(relativeShift);
        HashSet<LocalDate> holidays = new HashSet<LocalDate>();
        LocalDate firstGregorianDate = LocalDate.of(gregorianYear, Month.JANUARY, 1);
        LocalDate lastGregorianDate = LocalDate.of(gregorianYear, Month.DECEMBER, 31);
        ChronoLocalDate firstTargetDate = targetChrono.date(firstGregorianDate.minusDays(absoluteShift));
        ChronoLocalDate lastTargetDate = targetChrono.date(lastGregorianDate.plusDays(absoluteShift));
        int lastYear = lastTargetDate.get(ChronoField.YEAR);
        for (int targetYear = firstTargetDate.get(ChronoField.YEAR); targetYear <= lastYear; ++targetYear) {
            ChronoLocalDate d = targetChrono.date(targetYear, targetMonth, targetDay).plus(relativeShift, ChronoUnit.DAYS);
            if (firstGregorianDate.isAfter(d) || lastGregorianDate.isBefore(d)) continue;
            holidays.add(LocalDate.from(d));
        }
        return holidays;
    }

    public boolean contains(Set<Holiday> holidays, LocalDate date, HolidayType holidayType) {
        return holidays.stream().anyMatch(h -> h.getDate().equals(date) && (holidayType == null || h.getType() == holidayType));
    }

    public boolean contains(Set<Holiday> holidays, LocalDate date) {
        return this.contains(holidays, date, null);
    }
}

