/*
 * Decompiled with CFR 0.152.
 */
package de.jollyday.util;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class Cache<VALUE> {
    private final Map<String, VALUE> cachingMap = new ConcurrentHashMap<String, VALUE>();

    public VALUE get(ValueHandler<VALUE> valueHandler) {
        String key = valueHandler.getKey();
        VALUE value = this.cachingMap.get(key);
        return (VALUE)(value != null ? value : this.cachingMap.computeIfAbsent(key, k -> valueHandler.createValue()));
    }

    public void clear() {
        this.cachingMap.clear();
    }

    public static interface ValueHandler<VALUE> {
        public String getKey();

        public VALUE createValue();
    }
}

